(function() {
    tinymce.PluginManager.add('sp_add_shortcode_button', function( editor, url ) {
        editor.addButton( 'sp_add_shortcode_button', {
            icon: 'shortcodes-icon',
            type: 'menubutton',
            menu: [
                {
					text: 'Button',
					onclick: function() {
						editor.windowManager.open( {
							title: 'Button',
							body: [
								{
									type: 'listbox',
									name: 'ButtonStyle',
									label: 'Görünüm',
									'values': [
										{text: 'Normal', value: 'normal'},
										{text: 'Kenarları Yumuşatılmış', value: 'rounded'},
									]
								},
								{
									type: 'listbox',
									name: 'ButtonColor',
									label: 'Renk',
									'values': [
										{text: 'Birincil Renk', value: 'uckan-btn--red'},
										{text: 'Mavi', value: 'uckan-btn--blue'},
										{text: 'Yeşil', value: 'uckan-btn--green'},
										{text: 'Beyaz', value: ''},
									]
								},
								{
									type: 'listbox',
									name: 'ButtonSize',
									label: 'Boyut',
									'values': [
										{text: 'Küçük', value: 'uckan-btn--small'},
										{text: 'Orta', value: 'uckan-btn--middle'},
										{text: 'Büyük', value: 'uckan-btn--big'},
										{text: 'Blok', value: 'uckan-btn--block'},
									]
								},
								{
									type: 'textbox',
									name: 'ButtonLink',
									label: 'Link',
									minWidth: 300,
									value: 'http://'
								},
								{
									type: 'textbox',
									name: 'ButtonText',
									label: 'Yazı',
									value: 'Geoit'
								},
								{
									type: 'checkbox',
									name: 'ButtonTarget',
									label: 'Yeni Sekmede Aç',
									value: 'blank',
								}

							],
							onsubmit: function( e ) {
								editor.insertContent( '[button style="' + e.data.ButtonStyle + '" color="' + e.data.ButtonColor + '" size="' + e.data.ButtonSize + '" link="' + e.data.ButtonLink + '" target="' + e.data.ButtonTarget + '"]'+ e.data.ButtonText +'[/button]');
							}
						});
					}
				},
				
				{
					text: 'Bilgi Kutusu',
					onclick: function() {
						editor.windowManager.open( {
							title: 'Bilgi Kutusu',
							body: [
								{
									type: 'listbox',
									name: 'style',
									label: 'Stil',
									value: '2',
									'values': [
										{text: '1', value: '1'},
										{text: '2', value: '2'},
									]
								},
								{
									type: 'listbox',
									name: 'color',
									label: 'Renk',
									'values': [
										{text: 'Birincil Renk', value: 'primary'},
										{text: 'Bilgi', value: 'info'},
										{text: 'Başarılı', value: 'success'},
										{text: 'Tehlike', value: 'danger'},
										{text: 'Uyarı', value: 'warning'},
										{text: 'Koyu', value: 'dark'},
									]
								},
								{
									type: 'textbox',
									name: 'text',
									label: 'İçerik',
									value: ''
								}

							],
							onsubmit: function( e ) {
								editor.insertContent( '[geo_alert style="' + e.data.style + '" color="' + e.data.color + '" ]'+ e.data.text +'[/geo_alert]');
							}
						});
					}
				},
                {
					text: 'Başlık',
					onclick: function() {
						editor.windowManager.open( {
							title: 'Başlık',
							body: [
								{
									type: 'listbox',
									name: 'tag',
									value: 'h2',
									label: 'HTML Etiket',
									'values': [
										{text: 'H1', value: 'h1'},
										{text: 'H2', value: 'h2'},
										{text: 'H3', value: 'h3'},
										{text: 'H4', value: 'h4'},
										{text: 'H5', value: 'h5'},
										{text: 'H6', value: 'h6'},
									]
								},
								{
									type: 'listbox',
									name: 'number',
									label: 'Numara',
									value: '1',
									'values': [
										{text: 'Numarasız', value: 'none'},
										{text: '1', value: '1'},
										{text: '2', value: '2'},
										{text: '3', value: '3'},
										{text: '4', value: '4'},
										{text: '5', value: '5'},
										{text: '6', value: '6'},
										{text: '7', value: '7'},
										{text: '8', value: '8'},
										{text: '9', value: '9'},
										{text: '10', value: '10'},
										{text: '11', value: '11'},
										{text: '12', value: '12'},
										{text: '13', value: '13'},
										{text: '14', value: '14'},
										{text: '15', value: '15'},
										{text: '16', value: '16'},
										{text: '17', value: '17'},
										{text: '18', value: '18'},
										{text: '19', value: '19'},
										{text: '20', value: '20'},
									]
								},
								{
									type: 'listbox',
									name: 'type',
									value: 'square',
									label: 'Numara Görünümü',
									'values': [
										{text: 'Yuvarlak', value: 'round'},
										{text: 'Düz', value: 'square'},
									]
								},
								{
									type: 'listbox',
									name: 'style',
									label: 'Numara Tasarımı',
									'values': [
										{text: 'Renk Kaplı', value: 'colored'},
										{text: 'Kenarlıklı', value: 'bordered'},
									]
								},
								{
									type: 'textbox',
									name: 'text',
									label: 'Başlık',
									value: 'Geoit Wordpress Teması'
								},

							],
							onsubmit: function( e ) {
								editor.insertContent( '[geo_headline tag="' + e.data.tag + '" style="' + e.data.style + '" type="' + e.data.type + '" number="' + e.data.number + '"]'+ e.data.text +'[/geo_headline]');
							}
						});
					}
				},
				{
								text: 'Reklam',
								onclick: function() {
									editor.windowManager.open( {
										title: 'Kısakod Reklam',
										body: [
											{
												type: 'textbox',
												name: 'shortcodeAd',
												label: 'Kısakod Reklam',
												value: '[geo_ad]'
											},
									],
										onsubmit: function( e ) {
										editor.insertContent( '[geo_ad]');
										}
									});
								}
							},
				{
					text: 'Tab Menu',
					onclick: function() {
						editor.windowManager.open( {
							title: 'Tab Menu',
							width: 350,
							height: 275,
							body: [
								{
									type: 'textbox',
									name: 'geo_tabTitle',
									label: 'Başlık',
									value: 'Geoit Başlık 1'
								},
								{
									type: 'listbox',
									name: 'geo_tabStatus',
									label: 'Durum',
									'values': [
										{text: 'Aktif', value: 'active'},
										{text: 'Aktif Değil', value: 'is-no-active'},
									]
								},
								{
									type: 'textbox',
									name: 'geo_tabTitle1',
									label: 'Başlık',
									value: 'Geoit Başlık 2'
								},
								{
									type: 'listbox',
									name: 'geo_tabStatus1',
									label: 'Status',
									'values': [
										{text: 'Aktif Değil', value: 'is-no-active'},
										{text: 'Aktif', value: 'active'},
									]
								},
								{
									type: 'textbox',
									name: 'geo_tabTitle2',
									label: 'Başlık',
									value: 'Geoit Başlık 3'
								},
								{
									type: 'listbox',
									name: 'geo_tabStatus2',
									label: 'Status',
									'values': [
										{text: 'Aktif Değil', value: 'is-no-active'},
										{text: 'Aktif', value: 'active'},
									]
								},
							],					

							onsubmit: function( e ) {
								editor.insertContent( '\
								[tabgroup]<br />\
									[tab status="'+ e.data.geo_tabStatus +'" title="'+ e.data.geo_tabTitle +'"] Geoit Wordpress Teması 1[/tab]<br />\
									[tab status="'+ e.data.geo_tabStatus1 +'" title="'+ e.data.geo_tabTitle1 +'"] Geoit Wordpress Teması 2[/tab]<br />\
									[tab status="'+ e.data.geo_tabStatus2 +'" title="'+ e.data.geo_tabTitle2 +'"] Geoit Wordpress Teması 3[/tab]<br />\
								[/tabgroup]');
							}
						},
						{
        					plugin_url : url
						});
					}
				},
				{
					text: 'Açılır Menü',
					onclick: function() {
						editor.windowManager.open( {
							title: 'Açılır Menu',
							width: 350,
							height: 275,
							body: [
								{
									type: 'textbox',
									name: 'geo_tabTitle',
									label: 'Başlık',
									value: 'Başlık 1'
								},
								{
									type: 'textbox',
									name: 'geo_tabTitle1',
									label: 'Başlık',
									value: 'Başlık 2'
								},
								{
									type: 'textbox',
									name: 'geo_tabTitle2',
									label: 'Başlık',
									value: 'Başlık 3'
								},
							],					

							onsubmit: function( e ) {
								editor.insertContent( '\
								[toggles]<br />\
									[toggle title="'+ e.data.geo_tabTitle +'"] Content 1 [/toggle]<br />\
									[toggle title="'+ e.data.geo_tabTitle1 +'"] Content 2 [/toggle]<br />\
									[toggle title="'+ e.data.geo_tabTitle2 +'"] Content 3 [/toggle]<br />\
								[/toggles]');
							}
						},
						{
        					plugin_url : url
						});
					}
				},
				{
					text: 'Büyük Harf',
					onclick: function() {
						editor.windowManager.open( {
							title: 'Büyük Harf',
							width: 350,
							height: 120,
							body: [
								{
									type: 'listbox',
									name: 'DropcapsType',
									label: 'Tip',
									'values': [
										{text: 'Sadece Harf', value: 'letter'},
										{text: 'Yuvarlak', value: 'circle'},
										{text: 'Düz', value: 'square'},
									]
								},
								{
									type: 'textbox',
									name: 'DropcapsText',
									label: 'Text',
									value: 'A'
								},
							],					

							onsubmit: function( e ) {
								editor.insertContent( '\
								[dropcap type="'+ e.data.DropcapsType +'"]\
									'+ e.data.DropcapsText +' \
								[/dropcap]');
							}
						},
						{
        					plugin_url : url
						});
					}
				},
				{
					text: 'Vurgula',
					onclick: function() {
						editor.windowManager.open( {
							title: 'Vurgula',
							width: 350,
							height: 120,
							body: [
								{
									type: 'textbox',
									name: 'HighlightsText',
									label: 'Text',
									value: 'Geoit Theme'
								},
							],					

							onsubmit: function( e ) {
								editor.insertContent( '\
								[highlight]\
									'+ e.data.HighlightsText +' \
								[/highlight]');
							}
						},
						{
        					plugin_url : url
						});
					}
				},
				{
					text: 'Önerilen Yazı',
					onclick: function() {
						editor.windowManager.open( {
							title: 'Önerilen Yazı',
							width: 350,
							height: 120,
							body: [
								{
									type: 'textbox',
									name: 'relatedPostID',
									label: 'Yazı ID:',
									value: '1'
								},
							],					

							onsubmit: function( e ) {
								editor.insertContent( '\
								[geo-post id="'+ e.data.relatedPostID +'" label="Önerilen Yazı"]');
							}
						},
						{
        					plugin_url : url
						});
					}
				},
				{
					text: 'Sayfa Arası',
					onclick: function() {
						editor.windowManager.open( {
							title: 'Sayfa Aras',
							width: 350,
							height: 120,
							body: [
								{
									type: 'textbox',
									name: 'relatedPostID',
									label: 'ara:',
									value: '<!--nextpage-->'
								},
							],					

							onsubmit: function( e ) {
								editor.insertContent( '\
								<!--nextpage-->]');
							}
						},
						{
        					plugin_url : url
						});
					}
				},
            ]
        });
    });
})();