<?php
/*
Sayfa Adı: Kısakodlar
@link https://developer.wordpress.org/themes/basics/template-files/#template-partials
@url kanthemes.com
*/
add_action('init', 'sp_shortcode_button');
function sp_shortcode_button() {
    global $typenow;
    if ( !current_user_can('edit_posts') && !current_user_can('edit_pages') && !current_user_can('post_type') ) {
		return;
    }
    if( in_array( $typenow, array( 'post', 'page' ) ) )
        return;
    if ( get_user_option('rich_editing') == 'true') {
        add_filter("mce_external_plugins", "sp_shortcodes_button");
        add_filter('mce_buttons', 'sp_shortcode_button_save');
    }
}
function sp_shortcodes_button($plugin_array) {
   $plugin_array['sp_add_shortcode_button'] = get_template_directory_uri().'/frameworks/shortcodes/popup-button.js';
   return $plugin_array;
}
function sp_shortcodes_css() {
	wp_enqueue_style('sp-shortcodes-admin-css',  get_template_directory_uri().'/frameworks/shortcodes/css/shortcodes.css' );
}
add_action( 'admin_enqueue_scripts', 'sp_shortcodes_css' );
function sp_shortcode_button_save($buttons) {
   array_push($buttons, "sp_add_shortcode_button");
   return $buttons;
}
/* ------------------------------------------------------------------------- *
	* 1.0 Buttons
/* ------------------------------------------------------------------------- */
function shortcode_button( $atts, $content = null ) {
	$size  = 'small';
	$color = 'gray';
	$link  = $button_target = $align = $icon = $style   = '';
	
    if( is_array( $atts ) ) extract($atts);

	if( !empty( $target ) && $target == 'true' ) $button_target = ' target="_blank"';
	if( !empty( $icon ) )   $icon   = '<i class="fa '.$icon.'"></i>';
	
	$out = '<a href="'.$link.'"'.$button_target.' class="uckan-btn uckan-btn--'.$style.' '.$size.' '.$color.'">'. $icon . do_shortcode($content). '</a>';
    return $out;
}
add_shortcode('button', 'shortcode_button');
/* ------------------------------------------------------------------------- *
 *  2.0 Collapsible Menu
/* ------------------------------------------------------------------------- */

// $_oscitas_accordion = array();

function osc_theme_toggles($params, $content = null) {
    global $_oscitas_accordion;
		static $i = 1;
    extract(shortcode_atts(array(
		'id' => $i++,
		'class' => ''
    ), $params));
    $_oscitas_accordion[$id] = array();
    $scontent = do_shortcode($content);

    $output = '';
    if (trim($scontent) != '' || count($_oscitas_accordion[$id]['details'])) {
        $scontent = isset($_oscitas_accordion[$id]['details']) && is_array($_oscitas_accordion[$id]['details']) ? implode('', $_oscitas_accordion[$id]['details']) : '';
        $output .= '<div class="uck-accordion ' . $class .'" id="oscitas-accordion-' . $id . '">' . $scontent;
        $output .= '</div>';
    }
    return $output;
}

add_shortcode('toggles', 'osc_theme_toggles');

function osc_theme_toggle($params, $content = null) {
    global $_oscitas_accordion;
    extract(shortcode_atts(array(
			'title' => 'title',
    ), $params));
    $con = do_shortcode($content);
    $index = count($_oscitas_accordion);
    $id = isset($_oscitas_accordion[$index]['details'])?'details-' . $index . '-' . count($_oscitas_accordion[$index]['details']):'details-' . $index . '-0';
    $const = get_defined_constants();
    $_oscitas_accordion[$index]['details'][] = <<<EOS
        <div id="{$id}" class="uck-accordion--box">
            <div class="uck-accordion--title">
               <div class="uck-accordion--toggle" data-toggle="{$id}" data-parent="#oscitas-accordion-{$index}">{$title}</div>
            </div>
            <div class="uck-accordion--content">
              <p class="uck-accordion--body">{$con}</p>
            </div>
        </div>
EOS;
}

add_shortcode('toggle', 'osc_theme_toggle');
/* ------------------------------------------------------------------------- *
	* 3.0 Tab Menu
/* ------------------------------------------------------------------------- */
 	function geo_tabgroup_sc( $atts, $content = null ) {
		if( !isset( $GLOBALS['tabs_groups'] ) )
			$GLOBALS['tabs_groups'] = 0;
			
		$GLOBALS['tabs_groups']++;
		$GLOBALS['tab_count'] = 0;
		$tabs_count = 1;
		do_shortcode( $content );
		if( is_array( $GLOBALS['tabs'] ) ) {
			foreach( $GLOBALS['tabs'] as $tab ) {
				$tabs[] = '<li data-href="#tab-' . $GLOBALS['tabs_groups'] . '-' . $tabs_count . '" data-toggle="tab" class="' . do_shortcode( $tab['status'] ) . '">' . $tab['title'] . '</li>';
				$panes[] = '<div id="tab-' . $GLOBALS['tabs_groups'] . '-' . $tabs_count++ . '" class="tab_content ' . do_shortcode( $tab['status'] ) . '">' . do_shortcode( $tab['content'] ) . '</div>';
			}
			$return = "\n". '<div id="tab-menu" class="tabs-shortcode"><ul class="tabs tab-shortcode">' . implode( "\n", $tabs ) . '</ul>' . "\n" . '<div class="tab_container">' . implode( "\n", $panes ) . '</div></div>' . "\n";
		}
		
		$GLOBALS['tabs'] = null;
		return $return;
	}
add_shortcode('tabgroup', 'geo_tabgroup_sc');
	// 3.1 Single tab
	function geo_tab_sc( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'title' => '',
			'status' => 'is-no-active'
		), $atts) );
		$i = $GLOBALS['tab_count'];
		$GLOBALS['tabs'][$i] = array( 'title' => sprintf( $title, $GLOBALS['tab_count'] ), 'status' => $status,'content' => $content );
		$GLOBALS['tab_count']++;
	}
add_shortcode('tab', 'geo_tab_sc');
/* ------------------------------------------------------------------------- *
	* 4.0 Dropcaps
/* ------------------------------------------------------------------------- */
function dropcap_shortcode( $atts, $content = null ) {
	$type = '';
	if( is_array( $atts ) ) extract($atts);
  return '<span class="geo_dropcap geo_dropcap-' . $type . '">' . $content . '</span>';
}
add_shortcode( 'dropcap', 'dropcap_shortcode' );
/* ------------------------------------------------------------------------- *
	* 5.0 Highlights
/* ------------------------------------------------------------------------- */
function highlights_shortcode( $atts, $content = null ) {
  return '<span class="geo_highlight">' . $content . '</span>';
}
add_shortcode( 'highlight', 'highlights_shortcode' );
/* ------------------------------------------------------------------------- *
	* 6.0 Related Post
/* ------------------------------------------------------------------------- */
function geo_related_post_shortcode($atts){
	extract(shortcode_atts(array(
    "id" => '',
    "label" => __('Önerilen Yazı', 'geo'),
  ), $atts));
 $uckan = new WP_Query(
   array( 'p'=> $id,)
 );
$list ="";
while($uckan->have_posts()) : $uckan->the_post();
if (has_post_thumbnail() ) {
    $image_id = get_post_thumbnail_id();  
    $image_url = wp_get_attachment_image_src($image_id,'geo-medium');  
    $image_url = $image_url[0]; 
}
$list .= '<a class="uckan-card--url" href="' . get_permalink() . '"></a><div class="uckan-card--left"><img class="geo-related_shortcode" height="90" width="150" src="'.$image_url.'" /></div><div class="uckan-card--right"><div class="type">'.$label.'</div><div class="headline">' . get_the_title() . '</div></div>';
endwhile;
wp_reset_postdata();
return '<div class="uckan-card"><button type="text"><i class="fa fa-times"></i></button>'.$list . '</div>';
}
add_shortcode('geo-post', 'geo_related_post_shortcode');

/* ------------------------------------------------------------------------- *
	* 7.0 ads
/* ------------------------------------------------------------------------- */
function shortcode_adverts( $atts, $content = null ) {
	$ad = ot_get_option('geo-4-ads');
  if( is_array( $atts ) ) extract($atts);
	$out = '<div class="ad ad-single">'.$ad.'</div>';
  return $out;
}
add_shortcode('geo_ad', 'shortcode_adverts');

/* ------------------------------------------------------------------------- *
	* 7.1 ads
/* ------------------------------------------------------------------------- */
function shortcode_adverts2( $atts, $content = null ) {
	$ad = ot_get_option('geo-4-1-ads');
  if( is_array( $atts ) ) extract($atts);
	$out = '<div class="ad ad-single">'.$ad.'</div>';
  return $out;
}
add_shortcode('geo_ad2', 'shortcode_adverts2');

/* ------------------------------------------------------------------------- *
	* 7.2 ads
/* ------------------------------------------------------------------------- */
function shortcode_adverts3( $atts, $content = null ) {
	$ad = ot_get_option('geo-4-2-ads');
  if( is_array( $atts ) ) extract($atts);
	$out = '<div class="ad ad-single">'.$ad.'</div>';
  return $out;
}
add_shortcode('geo_ad3', 'shortcode_adverts3');

/* ------------------------------------------------------------------------- *
	* 8.0 Mailchimp
/* ------------------------------------------------------------------------- */
function shortcode_widget($atts) {
    
    global $wp_widget_factory;
    
    extract(shortcode_atts(array(
        'widget_name' => FALSE
    ), $atts));
    
    $widget_name = esc_html($widget_name);
    $instance = '';
	$id = '1';
    if (!is_a($wp_widget_factory->widgets[$widget_name], 'WP_Widget')):
        $wp_class = 'WP_Widget_'.ucwords(strtolower($class));
        
        if (!is_a($wp_widget_factory->widgets[$wp_class], 'WP_Widget')):
            return '<p>'.sprintf(__("%s: Widget class not found. Make sure this widget exists and the class name is correct"),'<strong>'.$class.'</strong>').'</p>';
        else:
            $class = $wp_class;
        endif;
    endif;
    
    ob_start();
    the_widget($widget_name, $instance, array('widget_id'=>'arbitrary-instance-'.$id,
        'before_widget' => '',
        'after_widget' => '',
        'before_title' => '',
        'after_title' => ''
    ));
    $output = ob_get_contents();
    ob_end_clean();
    return null;
    
}
add_shortcode('widget','shortcode_widget'); 

/* ------------------------------------------------------------------------- *
	* 9.0 Headline
/* ------------------------------------------------------------------------- */
function shortcode_headline( $atts, $content = null ) {
	$color = 'colored';
	$style = 'square';
	$type = 'colored';
	$tag = 'h2';
	$number = __('Numara', 'geo');
  if( is_array( $atts ) ) extract($atts);
	$number = ($number != 'none') ? '<span class="oajısdn2 '.$style.' '.$type.'">'.$number.'</span>' : '';
	$out = '<'.$tag.' class="geoit-sc-headline">'. $number .do_shortcode($content). '</'.$tag.'>';
  return $out;
}
add_shortcode('geo_headline', 'shortcode_headline');

/* ------------------------------------------------------------------------- *
	* 10.0 Info
/* ------------------------------------------------------------------------- */
function shortcode_geo_alert( $atts, $content = null ) {
	$style = '1';
	$color = 'success';
  if( is_array( $atts ) ) extract($atts);
	$out = '<div role="alert" class="geoit-alert geo-alert-style-'.$style.' geo-alert-color-'.$color.'">'.do_shortcode($content). '</div>';
  return $out;
}
add_shortcode('geo_alert', 'shortcode_geo_alert');