<?php
/*
Name:  		Geoit Stories
Version:    0.5
Author:     Kan Themes
Author URI: https://kanthemes.com/
*/

function geoit_stories_html() {
	$custom = ot_get_option('geoit_story_site');
	$cats = ot_get_option('geoit_story_cats');
	if((ot_get_option('geoit_stories') != 'on') || (!$cats && !$custom) )
		return false;

	$page = ot_get_option('geoit_stories_page');
	$out = '';
	
	if ($page == 'on' && !is_paged())
		$out = '<div class="container"><div id="stories"></div></div>';
	else {
		if(is_front_page() && !is_paged())
			$out = '<div class="container"><div id="stories"></div></div>';
	}
	return $out;
}

add_action('geoit_footer_end', 'geoit_stories', 999);
function geoit_stories() {
	$custom = ot_get_option('geoit_story_site');
	$cats = ot_get_option('geoit_story_cats');
	if((ot_get_option('geoit_stories') != 'on') || (!$cats && !$custom) )
		return false;
	
	$dr = ot_get_option('geoit_stories_dr'); 
	$site_avatar = (!empty(ot_get_option('geoit_story_site_avatar'))) ? ot_get_option('geoit_story_site_avatar'): get_template_directory_uri().'/assets/img/kanthemes_favicon.png';
	
	$custom_title = !empty(ot_get_option('geoit_story_site_title')) ? ot_get_option('geoit_story_site_title') : get_bloginfo('name');
	ob_start(); ?>
	<script>
		var geoitStories = function () {
			var stories = new Zuck('stories', {
			  skin: 'snapgram',
			  backNative: true,
			  previousTap: true,
			  autoFullScreen: true,
			  avatars: true,
			  list: false,
			  cubeEffect: true,
			  localStorage: false,
			  stories: [
				// custom category
			    <?php if ($custom): $_timezone = date_default_timezone_get(); date_default_timezone_set( 'Europe/Istanbul' ); ?>
					{
						id: "geoit-story-site",
						photo: "<?php echo $site_avatar; ?>",
						name: "<?php echo $custom_title; ?>",
						link: "<?php echo get_home_url(); ?>",
						lastUpdated: "<?php echo strtotime($custom['0']['date']); ?>",
						seen: false,
						items: [
							<?php $i=0;foreach($custom as $item ) : $i++; ?>
								Zuck.buildItem(
									"geoit-story-site-<?php echo $i; ?>",
									"photo",
									"<?php echo $dr; ?>",
									"<?php echo $item['image']; ?>",
									"data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs%3D",
									"<?php echo $item['link']; ?>",
									"<?php echo $item['title'] ?>",
									false,
									"<?php echo strtotime($item['date']); ?>",
								),
							<?php endforeach; ?>
						]
					},
					
			    <?php date_default_timezone_set( $_timezone ); endif;?>
				
				// blog categories 
			    <?php if ($cats): ?> 
					<?php foreach($cats as $item):?>
						<?php $number_of_posts = (!empty(ot_get_option('geoit_stories_post')))? ot_get_option('geoit_stories_post') : '5'; 
						if (ot_get_option('geoit_stories_time') == 'on'):
							$query_st = new WP_Query(array( 'cat' => $item,'showposts' => $number_of_posts, 'date_query' => array(array('after' => '24 hours ago'))));
						else:
							$query_st = new WP_Query(array( 'cat' => $item,'showposts' => $number_of_posts, 'orderby' => 'modified'));
						endif;?>
						<?php if ($query_st->have_posts()): $avatar = (!empty($item['image'])) ? $item['image']: get_template_directory_uri().'/assets/img/kanthemes_favicon.png'; ?>
							{
							  id: "geoit-story-<?php echo get_category($item['id'])->slug; ?>",
							  photo: "<?php echo $avatar; ?>",
							  name: "<?php echo $item['title']; ?>",
							  link: "<?php echo get_category_link($item['id']); ?>",
							  seen: true,
							  lastUpdated: "<?php echo get_post_modified_time('U', true); ?>",
							  items: [
								<?php $i=0;while($query_st->have_posts()): $query_st->the_post(); global $post; $i++; ?>
									Zuck.buildItem(
										"geoit-story-<?php echo get_category($item['id'])->slug; ?>-<?php echo $i; ?>",
										"photo",
										"<?php echo $dr; ?>",
										"<?php echo get_the_post_thumbnail_url($post->ID,'full'); ?>",
										"data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs%3D",
										'<?php echo get_the_permalink(); ?>',
										'<?php echo get_the_title(); ?>',
										false,
										"<?php echo get_post_modified_time('U', true, $post->ID); ?>"
									),
								<?php endwhile; ?>
							  ]
							},
						<?php endif; ?>
					<?php endforeach; ?>
			    <?php endif; ?>
			  ],
			  'language': {
				'unmute': '<?php _e("Sesi açmak için dokunun", "geo"); ?>',
				'keyboardTip': '<?php _e("Bir sonrakine geçmek için dokunun", "geo"); ?>',
				'visitLink': '<?php _e("Hemen Okuyun", "geo"); ?>',
				'time': {
				  'ago':'<?php _e("önce", "geo"); ?>', 
				  'hour':'<?php _e("saat", "geo"); ?>', 
				  'hours':'<?php _e("saat", "geo"); ?>', 
				  'minute':'<?php _e("dakika", "geo"); ?>', 
				  'minutes':'<?php _e("dakika", "geo"); ?>', 
				  'fromnow': '<?php _e("şimdi", "geo"); ?>', 
				  'seconds':'<?php _e("saniye", "geo"); ?>', 
				  'yesterday': '<?php _e("dün", "geo"); ?>', 
				  'tomorrow': '<?php _e("bugün", "geo"); ?>', 
				  'days':'<?php _e("gün", "geo"); ?>'
				}
			  },
			});

		};
      geoitStories();
	</script>
	<?php $out = ob_get_clean();
	if(ot_get_option('geoit_stories_page') == 'on'): 
		echo geoit_minify_js($out); 
	else:
		if(is_front_page())
			echo geoit_minify_js($out);
	endif; 
}