<?php
/*
Sayfa Adı: Benzer Videolar
@link https://developer.wordpress.org/themes/basics/template-files/#template-partials
@url kanthemes.com
*/
?>
<div class="clearfix"></div>
<?php
$related_count = ot_get_option('related_count');
$tags = wp_get_post_terms( get_queried_object_id(), 'post_tag', ['fields' => 'ids'] );
if ( ot_get_option( 'related_order' ) == 'most-commented' ) {
	$args = array(
    'post_type' => 'post',
		'showposts' => $related_count,
    'tax_query' => array( 
			array(
				'taxonomy' => 'post_format',
				'field' => 'slug',
				'terms' => array('post-format-video'),
			)
		),
		'post__not_in' => array($post->ID),
		'orderby' => 'comment_count',
   );
}
elseif ( ot_get_option( 'related_order' ) == 'recent-posts' ) {
	$args = array(
    'post_type' => 'post',
		'showposts' => $related_count,
    'tax_query' => array( 
			array(
				'taxonomy' => 'post_format',
				'field' => 'slug',
				'terms' => array('post-format-video'),
			)
		),
		'post__not_in' => array($post->ID),
   );
}
elseif ( ot_get_option( 'related_order' ) == 'most-viewed' ) {
	$args= array(
		'post_type' => 'post',
		'tax_query' => array( 
			array(
				'taxonomy' => 'post_format',
				'field' => 'slug',
				'terms' => array('post-format-video'),
			)
		),
		'orderby' => 'post_views',
		'order'	=> 'desc',
		'suppress_filters' => false,
		'post__not_in' => array($post->ID),
		'showposts' => $related_count,
	);
}
elseif ( ot_get_option( 'related_order' ) == 'tags' ) {
	$args= array(
		'suppress_filters' => false,
		'post__not_in' => array($post->ID),
		'ignore_sticky_posts'=>1,
		'showposts' => $related_count,
		'orderby'   => 'rand',
		'tax_query' => array( 
			array(
				'taxonomy' => 'post_format',
				'field' => 'slug',
				'terms' => array('post-format-video'),
			),
			array (
				'taxonomy' => 'post_tag',
				'terms'    => $tags
			)
		)
	);
}
else {
	$args = array(
    'post_type' => 'post',
		'showposts' => $related_count,
    'tax_query' => array( 
			array(
				'taxonomy' => 'post_format',
				'field' => 'slug',
				'terms' => array('post-format-video'),
			)
		),
		'post__not_in' => array($post->ID),
		'orderby' => 'rand',
   );
}

$my_query = new wp_query($args);  if ($my_query->have_posts()) : ?>
<div id="related-posts" class="content__related-posts">
	<?php $title =  __( 'Benzer Videolar', 'geo' ); echo geoit_block_title($title, 'h3'); ?>
	<div class="masonry masonry-grid">
		<?php while($my_query->have_posts()): $my_query->the_post();?>
			<div id="post-<?php the_ID(); ?>" class="uck-card">
				<?php if(has_post_thumbnail()): ?>
					<div class="uck-card--image">
						<a href='<?php the_permalink(); ?>' title='<?php the_title(); ?>'>
							<?php the_post_thumbnail('geo-medium'); ?>
						</a>
						<?php if(get_post_meta( $post->ID, 'geo_' . 'enable_review', true )) geo_print_review_badge($post->ID); ?>
						<?php echo get_simple_likes_button( get_the_ID() ); ?>
					</div>
				<?php endif; ?>
				<div class="uck-card--content">
					<?php the_title( sprintf( '<h3 class="headline"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
					<div class="uck-card--left">
						<span class="entry_author"><?php echo geoit_get_avatar( get_the_author_meta( 'ID' ), 20 ); ?><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author(); ?></a></span>
						<span class="date"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?></span>
						<?php geoit_trending_post(get_the_ID()); ?>
						<?php geo_reaction_badge($post->ID); ?>
					</div>
				</div>
			</div>
		<?php endwhile; ?>
	</div>
</div>
<?php endif; wp_reset_query(); ?>