<?php
/*
Sayfa Adı: 404 Sayfası
@link https://developer.wordpress.org/themes/basics/template-files/#template-partials
@url kanthemes.com
*/
?>

<section class="no-results not-found">
	<header class="content__title">
		<h1 class="uckan-btn ripple-effect"><?php _e( 'Bulunamadı', 'geo' ); ?></h1>
	</header>
	<div class="page-content">
		<?php
		if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>

			<p><?php printf( __( 'İlk yazını yayınlamaya hazır mısın? <a href="%1$s">Hemen Başla!</a>.', 'geo' ), esc_url( admin_url( 'post-new.php' ) ) ); ?></p>

		<?php else : ?>

			<p><?php _e( 'Aradığınız şeyi bulamadık, arama yapmayı dener misiniz?', 'geo' ); ?></p>
			<?php
				get_search_form();
		endif; ?>
	</div><!-- .page-content -->
</section><!-- .no-results -->
