<?php 
/*
Sayfa Adı: Yazı-Grid
@link https://developer.wordpress.org/themes/basics/template-files/#template-partials
@url kanthemes.com
*/
$post_meta = !empty(ot_get_option('geoit_post_meta')) ? ot_get_option('geoit_post_meta') : 'on';
?>
<div class="uck-card post">
	<?php if(has_post_thumbnail()): ?>
		<div class="uck-card--image">
			<a href='<?php the_permalink(); ?>' title='<?php the_title(); ?>'>
					<?php the_post_thumbnail('geo-medium'); ?>
				</a>
			<?php if(get_post_meta( $post->ID, 'geo_' . 'enable_review', true )) geo_print_review_badge($post->ID); ?>
			<?php echo get_simple_likes_button( get_the_ID() ); ?>
		</div>
	<?php endif; ?>
	<div class="uck-card--content">
		<?php if($post_meta != 'off'): ?>
			<span class="date"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?></span>
			<?php echo geoit_block_views(); ?>
		<?php endif; ?>
		<?php the_title( sprintf( '<h3 class="headline"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
		<?php if($post_meta != 'off'): ?>
			<span class="entry_author"><?php echo geoit_get_avatar( get_the_author_meta( 'ID' ), 20 ); ?><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author(); ?></a></span>
			<?php geoit_trending_post(get_the_ID()); ?>
			<?php geo_reaction_badge($post->ID); ?>
		<?php endif; ?>
	</div>
</div>
