<?php
/*
Sayfa Adı: Yazı-Timeline
@link https://developer.wordpress.org/themes/basics/template-files/#template-partials
@url kanthemes.com
*/
$post_meta = !empty(ot_get_option('geoit_post_meta')) ? ot_get_option('geoit_post_meta') : 'on';
$post_author = !empty(ot_get_option('geoit_post_author')) ? ot_get_option('geoit_post_author') : 'on';
?>
<div class="uck-card uck-card-list uck-card-timeline">
	<div class="uck-card-timeline-left">
		<div class="uck-card-timeline-icon">
			<i class="fa fa-clock-o"></i>
			<span class="date"><?php echo esc_html( human_time_diff( get_the_time('U'), current_time('timestamp') ) ) . ' '.__('önce', 'geo'); ?></span>
		</div>
	</div>
	<div class="uck-card-timeline-right">
		<?php if(has_post_thumbnail()): ?>
			<?php $image = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'geo-medium'); ?>
			<div class="uck-card--image">
				<a href='<?php the_permalink(); ?>' title='<?php the_title(); ?>'>
					<?php the_post_thumbnail('geo-medium'); ?>
				</a>
				<?php if(get_post_meta( $post->ID, 'geo_' . 'enable_review', true )) geo_print_review_badge($post->ID); ?>
				<?php echo get_simple_likes_button( get_the_ID() ); ?>
			</div>
		<?php endif; ?>
		<div class="uck-card--content">
			<?php if($post_meta != 'off'): ?>
				<div class="uck-card-top">
					<?php geo_categories(); ?>
				</div>
			<?php endif; ?>
			<?php the_title( sprintf( '<h3 class="headline"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
			<?php if (ot_get_option('excerpt-length') != ''): ?>
				<?php the_excerpt(); ?>
			<?php endif; ?>
			<?php if($post_meta != 'off'): ?>
			<div class="uck-card--meta">
				<?php if($post_author != 'off'): ?>
					<div class="uck-card--left">
						<span class="entry_author"><?php echo geoit_get_avatar( get_the_author_meta( 'ID' ), 20 ); ?><a title="<?php the_author(); ?>" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author(); ?></a></span>
						<?php geo_reaction_badge($post->ID); ?>
					<?php geoit_trending_post(get_the_ID()); ?>
					</div>
				<?php endif; ?>
				<div class="uck-card--right">
					<a href='<?php the_permalink(); ?>' title='<?php the_title(); ?>'><?php _e( 'Devamını Oku', 'geo' ); ?></a>
				</div>
			</div>
		<?php endif; ?>
		</div>
	</div>
</div>
