<?php
/*
Sayfa Adı: Carousel
@link https://developer.wordpress.org/themes/basics/template-files/#template-partials
@url kanthemes.com
*/

if(is_category()) 
$cat = get_queried_object()->term_id;
else 
$cat = ot_get_option('geo-carousel-category');

$exlude = ot_get_option('geo-carousel-post-not2');
$excludepages = explode(",", $exlude);

$slider_mask = ot_get_option('slider_mask');
$slider_meta = ot_get_option('slider_meta_items');
$slider_cat = !empty(ot_get_option('slider_cats')) ? ot_get_option('slider_cats') : 'on';
$slider_author = !empty(ot_get_option('slider_author')) ? ot_get_option('slider_author') : 'on';
$mask = '';
if ($slider_mask != 'off') {
	$mask = 'slider_mask';
}
$geoit_carousel = new WP_Query(
	array(
		'post__not_in' => $excludepages,
		'showposts' => ot_get_option('geo_slider_count'),
		'cat' => $cat
	)
);
$counter = 1; 
if ($geoit_carousel->have_posts()) : ?>
	<?php if (ot_get_option('slider_container') != 'wide'): ?>
		<div class="container">
			<div class="row">
	<?php endif; ?>
				<div class="carousel carousel-featured carousel-style-2 col-md-12 <?php echo $mask; ?>">
				<?php while($geoit_carousel->have_posts()): $geoit_carousel->the_post(); 
				if($counter == 1 || $counter == 2): 
				?>
					<div class="carousel__item carousel__big--item <?php echo 'geoit_slider-'.$counter.''; ?> ">
					<a href="<?php echo esc_url( get_permalink() ); ?>" class="uckan-card--url"></a>
						<?php echo get_simple_likes_button( get_the_ID() ); ?>
						<figure <?php geoit_thumbnail_background_image2(get_post_thumbnail_id(), 'geo-carousel', 'carousel__image'); ?>></figure>
						<div class="carousel__content">
							<?php if($slider_cat != 'off') : ?>
								<div class="carousel__category">
									<?php geo_categories(); ?>
								</div>
							<?php endif; ?>
							<?php the_title( sprintf( '<h2 class="headline truncate"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
							<?php if($slider_meta != 'off') : ?>
							
							<div class="carousel__content--meta">
								<?php if($slider_author != 'off') : ?>
								<span class="author"><?php echo geoit_get_avatar( get_the_author_meta( 'ID' ), 25 ); ?><span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author(); ?></a></span></span>
								<?php endif; ?>
								<span class="date"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?><?php geo_reaction_badge($post->ID); ?><?php geoit_trending_post(get_the_ID()); ?></span>
							</div>
							
						<?php endif; ?>
						</div>
					</div>
					<?php else: ?>
					<div class="carousel__item carousel__medium--item <?php echo 'geoit_slider-'.$counter.''; ?>">
						<a href="<?php echo esc_url( get_permalink() ); ?>" class="uckan-card--url"></a>
						<?php echo get_simple_likes_button( get_the_ID() ); ?>
						<figure <?php geoit_thumbnail_background_image2(get_post_thumbnail_id(), 'geo-carousel2', 'carousel__image'); ?>></figure>
						<div class="carousel__content">
							<?php if($slider_cat != 'off') : ?>
								<div class="carousel__category">
									<?php geo_categories(); ?>
								</div>
							<?php endif; ?>
							<?php the_title( sprintf( '<h2 class="headline truncate"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
							<?php if($slider_meta != 'off') : ?>
							<div class="carousel__content--meta">
								<?php if($slider_author != 'off') : ?>
								<span class="author"><?php echo geoit_get_avatar( get_the_author_meta( 'ID' ), 25 ); ?><span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author(); ?></a></span></span>
								<?php endif; ?>
								<span class="date"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?><?php geo_reaction_badge($post->ID); ?><?php geoit_trending_post(get_the_ID()); ?></span>
							</div>
						<?php endif; ?>
						</div>
					</div>
				<?php endif;
				$counter++; endwhile; ?>
				</div>
			<?php endif; ?>
	<?php if (ot_get_option('slider_container') != 'wide'): ?>
		</div>
		</div>
	<?php endif; ?>
<?php wp_reset_query(); ?>