<?php
/*
Sayfa Adı: Slider
@link https://developer.wordpress.org/themes/basics/template-files/#template-partials
@url kanthemes.com
*/
if(is_category()) 
$cat = get_queried_object()->term_id;
else 
$cat = ot_get_option('geo-carousel-category');
$exlude = ot_get_option('geo-carousel-post-not2');
$excludepages = explode(",", $exlude);

$slider_mask = ot_get_option('slider_mask');
$slider_cat = !empty(ot_get_option('slider_cats')) ? ot_get_option('slider_cats') : 'on';
$slider_author = !empty(ot_get_option('slider_author')) ? ot_get_option('slider_author') : 'on';
$slider_meta = ot_get_option('slider_meta_items');
$mask = '';
if ($slider_mask != 'off') {
	$mask = 'slider_mask';
}
$recent_posts = new WP_Query(array('showposts' => ot_get_option('geo_slider_count'),'post__not_in' => $excludepages,'cat' => $cat)); 
	if ($recent_posts->have_posts()) : ?>
		<?php if(geo_is_mobile()): ?>
			<div class="owl-carousel loop1 h-slider w-slider owl-theme geo_mobile_slider <?php echo $mask; ?>">
				<?php $counter = 1; while($recent_posts->have_posts()): $recent_posts->the_post(); ?>
					<div class="carousel__item item <?php echo 'geoit_slider-'.$counter.''; ?>">
						<a href="<?php echo esc_url( get_permalink() ); ?>" class="uckan-card--url"></a>
						<?php echo get_simple_likes_button( get_the_ID() ); ?>
						<figure <?php geoit_thumbnail_background_image(get_post_thumbnail_id(), 'geo-carousel2'); ?>></figure>
						<div class="carousel__content ">
							<?php if($slider_cat != 'off') : ?>
								<div class="carousel__category">
									<?php geo_categories(); ?>
								</div>
							<?php endif; ?>
							<?php the_title( sprintf( '<h2 class="headline truncate"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
							<?php if($slider_meta != 'off') : ?>
								<div class="carousel__content--meta">
								<?php if($slider_author != 'off') : ?>
								<span class="author"><?php echo geoit_get_avatar( get_the_author_meta( 'ID' ), 25 ); ?><span><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author(); ?></a></span></span>
								<?php endif; ?>
								<span class="date"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?><?php geo_reaction_badge($post->ID); ?><?php geoit_trending_post(get_the_ID()); ?></span>
								</div>
							<?php endif; ?>
						</div>
					</div>
				<?php endwhile; ?>
			</div>
		<?php else: ?>
			<div class="slider-style-2">
				<div class="owl-carousel loop5 h-slider w-slider owl-theme <?php echo $mask; ?>">
				<?php $counter = 1; while($recent_posts->have_posts()): $recent_posts->the_post(); ?>
					<div class="carousel__item item <?php echo 'geoit_slider-'.$counter.''; ?>">
						<a href="<?php echo esc_url( get_permalink() ); ?>" class="uckan-card--url"></a>
						<?php echo get_simple_likes_button( get_the_ID() ); ?>
						<figure <?php geoit_thumbnail_background_image(get_post_thumbnail_id(), 'geo-slider'); ?>></figure>
						<div class="carousel__content">
							<?php if($slider_cat != 'off') : ?>
								<div class="carousel__category">
									<?php geo_categories(); ?>
								</div>
							<?php endif; ?>
							<?php the_title( sprintf( '<h2 class="headline"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
							<?php if($slider_meta != 'off') : ?>
								<div class="carousel__content--meta">
									<span class="date"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?><?php geo_reaction_badge($post->ID); ?><?php geoit_trending_post(get_the_ID()); ?></span>
									<a class="readmore" href='<?php the_permalink(); ?>' title='<?php the_title(); ?>'><?php _e( 'Devamını Oku', 'geo' ); ?></a>
								</div>
							<?php endif; ?>	
						</div>
					</div>
				<?php $counter++; endwhile;?>
				</div>
			</div>
		<?php endif; 
	endif; 
wp_reset_query(); ?>