<?php
add_action('widgets_init', 'geo_homepage_col_load_widgets');
function geo_homepage_col_load_widgets()
{
	register_widget('geo_Homepage_col_Widget');
}
class geo_Homepage_col_Widget extends WP_Widget {
	public function __construct(){
		$widget_ops = array('classname' => 'geo_homepage_col');
		$control_ops = array('id_base' => 'geo_homepage_col-widget');
		parent::__construct('geo_homepage_col-widget', ''.THEME_NAME .' - '.__( "Yazılar" , 'geo' ).' #1' , $widget_ops, $control_ops );
	}
	
	public function widget($args, $instance)
	{
		extract($args);
		
		$show_excerpt = isset($instance['show_excerpt']) ? 'true' : 'false';
		
		$title = $instance['title'];
		$categories = $instance['categories'];
		$posts = $instance['posts'];
		$sortby = $instance['sortby'];
		$postnotin = !empty($instance['postnotin']) ? $instance['postnotin'] : '';
		
		$exlude = $postnotin;
		$excludeposts = explode(",", $exlude);
		
		$link = ($categories == 'all' || $categories == '') ? '' : '<a title="'.__('Tüm Yazılar', 'geo').'" class="title-all" href="'.get_category_link($categories).'"><i class="fa fa-arrow-right"></i></a>';

		echo $before_widget;
		if(!empty($title)) {
			echo $before_title;
				echo $title; 
				echo $link; 
			echo $after_title;
		}
		
		if($sortby == 'commented') {
			$sp_query = new WP_Query(
				array( 
					'showposts' => $posts, 
					'cat' => $categories,
					'orderby' => 'comment_count',
					'post__not_in' => $excludeposts
				)
			);
		}
		elseif($sortby == 'random') {
			$sp_query = new WP_Query(
				array( 
					'cat' => $categories,
					'showposts' => $posts,
					'orderby' => 'rand',
					'post__not_in' => $excludeposts
				)
			);
		}
		elseif($sortby == 'post-viewed') {
			$sp_query = new WP_Query(
				array( 
					'cat' => $categories,
					'showposts' => $posts,
					'orderby' => 'post_views',
					'order'	=> 'desc',
					'suppress_filters' => false,
					'post__not_in' => $excludeposts
				)
			);
		}
		else {
			$sp_query = new WP_Query(
				array( 
					'cat' => $categories,
					'showposts' => $posts,
					'post__not_in' => $excludeposts
				)
			);
		}
		
		?>

		
		<?php if ($sp_query->have_posts()) :?>
			<div class="uck-card col-posts">
				<?php $counter = 1; while($sp_query->have_posts()): $sp_query->the_post(); global $post; ?>
				<?php if($counter == 1): ?>
					<div class="uck-card--col_left">
						<?php if(has_post_thumbnail()): ?>
							<div class="uck-card--image">
								<?php if(get_post_meta( $post->ID, 'geo_' . 'enable_review', true )) geo_print_review_badge($post->ID); ?>
								<a href='<?php the_permalink(); ?>' title='<?php the_title(); ?>'>
									<?php the_post_thumbnail('geo-medium'); ?>
								</a>
								<?php echo get_simple_likes_button( get_the_ID() ); ?>
							</div>
						<?php endif; ?>
							<div class="uck-card--content">
								<?php geo_categories();?>
								<?php the_title( sprintf( '<h3 class="headline"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
								<span class="date"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?></span>
								<?php echo geoit_block_views(); ?>
								<?php geoit_trending_post(get_the_ID()); ?>
								<?php if($show_excerpt == 'true'): ?>    
									<?php if (ot_get_option('excerpt-length') != '0'): ?>
										<?php the_excerpt(); ?>
									<?php endif; ?>
								<?php endif; ?>
							</div>
					</div>
					<div class="col-group">
				<?php else: ?>
					<div class="uck-card--col_right">
						<?php if(has_post_thumbnail()): ?>
							<div class="uck-card--image">
								<?php if(get_post_meta( $post->ID, 'geo_' . 'enable_review', true )) geo_print_review_badge($post->ID); ?>
								<a href='<?php the_permalink(); ?>' title='<?php the_title(); ?>'>
									<?php the_post_thumbnail('geo-small'); ?>
								</a>
								<?php echo get_simple_likes_button( get_the_ID() ); ?>
							</div>
						<?php endif; ?>
							<div class="uck-card--content">
								<?php the_title( sprintf( '<h3 class="headline truncate"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
								<span class="date"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?></span>
								<?php echo geoit_block_views(); ?>
								<?php geoit_trending_post(get_the_ID()); ?>
							</div>
					</div>
				<?php endif; ?>
				<?php $counter++; endwhile; ?>
				</div>
			</div>
		<?php else: ?>
			<div style="padding: 1em"><?php _e('Listelenecek herhangi bir yazı bulunamadı.', 'geo'); ?></div>
		<?php endif; ?>
		<?php wp_reset_query(); ?>
		<?php
		echo $after_widget;
	}
	
	public function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['show_excerpt'] = $new_instance['show_excerpt'];
		$instance['title'] = $new_instance['title'];
		$instance['categories'] = $new_instance['categories'];
		$instance['posts'] = $new_instance['posts'];
		$instance['sortby'] = $new_instance['sortby'];
		$instance['postnotin'] = $new_instance['postnotin'];
		
		return $instance;
	}

	public function form($instance)
	{
		$defaults = array('show_excerpt' => null, 'title' => __('Modül', 'geo'), 'postnotin' => '', 'categories' => '0', 'posts' => 5, 'sortby' => 'recent');
		$instance = wp_parse_args((array) $instance, $defaults); ?>
		
		<p>
			<label for="<?php echo $this->get_field_id('sortby'); ?>"><?php _e( 'Göre Sırala' , 'geo') ?></label> 
			<select id="<?php echo $this->get_field_id('sortby'); ?>" name="<?php echo $this->get_field_name('sortby'); ?>" class="widefat" style="width:100%;">
				<option value='recent' <?php if ('recent' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'Yayınlanma Tarihine Göre' , 'geo') ?></option>
				<option value='commented' <?php if ('commented' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'En Çok Yorum Yapılan' , 'geo') ?></option>
				<option value='post-viewed' <?php if ('post-viewed' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'En Çok Okunan' , 'geo') ?></option>
				<option value='random' <?php if ('random' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'Rastgele' , 'geo') ?></option>
			</select>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Başlık' , 'geo') ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" class="widefat" type="text" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('categories'); ?>"><?php _e( 'Kategori' , 'geo') ?></label> 
			<select id="<?php echo $this->get_field_id('categories'); ?>" name="<?php echo $this->get_field_name('categories'); ?>" class="widefat categories" style="width:100%;">
				<option value='all' <?php if ('all' == $instance['categories']) echo 'selected="selected"'; ?>><?php _e( 'Hepsi' , 'geo') ?></option>
				<?php $categories = get_categories('hide_empty=0&depth=1&type=post'); ?>
				<?php foreach($categories as $category) { ?>
				<option value='<?php echo $category->term_id; ?>' <?php if ($category->term_id == $instance['categories']) echo 'selected="selected"'; ?>><?php echo $category->cat_name; ?></option>
				<?php } ?>
			</select>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('posts'); ?>"><?php _e( 'Yazı Sayısı' , 'geo') ?></label>
			<input class="widefat" style="width: 30px;" id="<?php echo $this->get_field_id('posts'); ?>" name="<?php echo $this->get_field_name('posts'); ?>" value="<?php echo $instance['posts']; ?>" />
		</p>
		<p>
			<input class="checkbox" type="checkbox" <?php checked($instance['show_excerpt'], 'on'); ?> id="<?php echo $this->get_field_id('show_excerpt'); ?>" name="<?php echo $this->get_field_name('show_excerpt'); ?>" /> 
			<label for="<?php echo $this->get_field_id('show_excerpt'); ?>"><?php _e( 'Açıklamayı Göster' , 'geo') ?></label>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'postnotin' ); ?>"><?php _e( 'Hariç Tutulan Yazılar' , 'geo') ?></label>
			<br><i><?php _e('Yazı idlerini virgül ile ayırarak girin', 'geo'); ?></i>
			<input id="<?php echo $this->get_field_id( 'postnotin' ); ?>" name="<?php echo $this->get_field_name( 'postnotin' ); ?>" value="<?php echo $instance['postnotin']; ?>" class="widefat" type="text" />
		</p>
	<?php }
}
?>