<?php
add_action('widgets_init', 'geo_widget_category_images');
function geo_widget_category_images()
{
	register_widget('geo_categoryimages');
}
class geo_categoryimages extends WP_Widget {
	public function __construct(){
		$widget_ops = array('classname' => 'geoit-category-images');
		$control_ops = array('id_base' => 'geo-category-images-widget');
		parent::__construct('geo-category-images-widget', THEME_NAME .' - '.__( "Resimli Kategoriler" , 'geo' ) , $widget_ops, $control_ops );
	}
	
	public function widget($args, $instance)
	{
		extract($args);
		
		$title = empty(!$instance['title']) ? $instance['title'] : '';
		$prefix = empty(!$instance['prefix']) ? $instance['prefix'] : '';
		$style = isset($instance['style']) ? $instance['style'] : 'style1';
		$affix = empty(!$instance['affix']) ? $instance['affix'] : '';
		// $show_count = isset($instance['show_count']) ? 'true' : 'false';

		echo $before_widget;
		
		if(!empty($title)) {
			echo $before_title;
				echo $title ; 
			echo $after_title; 
		}
		
		$categories = get_categories( array(
			'orderby' => 'name',
			'order'   => 'ASC'
		) );
		
		if ($style == 'style4') :
			echo '<div class="geoit-category-images-wrapper geoit-category-images-'.$style.'">';
				echo '<div class="row">';
					foreach($categories as $category) {
						$image_id = get_term_meta( $category->term_id, 'category-image-id', true );
						$image_size = 'thumbnail';
						$image_data = wp_get_attachment_image_src( $image_id, $image_size );
						$image = $image_data[0];
						if ( ! empty( $image ) ) {
							$lazy = ot_get_option('geoit_lazy_images');
							if ($lazy == 'on') {
								echo '<div class="geoit-category-image col-xs-3 col-sm-2 col-md-1"><a href="' . get_category_link( $category->term_id ) . '"><img width="70" height="70" class="geo-lazy" alt="'.$category->name.'" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVR42mPk5ODkAQAAZAAoQWYOjQAAAABJRU5ErkJggg==" data-src="'.esc_url( $image ).'" /><div class="geoit-category-image-content"><h5>'.$prefix.$category->name.$affix.'</h5></div></a></div>';
							} else {
								echo '<div class="geoit-category-image col-xs-3 col-sm-2 col-md-1"><a href="' . get_category_link( $category->term_id ) . '"><img width="70" height="70"class="geo-lazy" alt="'.$category->name.'" src="'.esc_url( $image ).'" /><div class="geoit-category-image-content"><h5>'.$prefix.$category->name.$affix.'</h5></div></a></div>';
							}
						}
					}
				echo '</div>';
			echo '</div>';
		else:
		echo '<div class="geoit-category-images-wrapper owl-carousel owl-theme loop4 geoit-category-images-'.$style.'">';
			foreach($categories as $category) {
				$image_id = get_term_meta( $category->term_id, 'category-image-id', true );
				$image_size = 'geo-cat-image';
				$image_data = wp_get_attachment_image_src( $image_id, $image_size );
				$image = $image_data[0];
				if ( ! empty( $image ) ) {
					$lazy = ot_get_option('geoit_lazy_images');
					if ($lazy == 'on') {
						echo '<div class="geoit-category-image"><a class="uckan-card--url" href="' . get_category_link( $category->term_id ) . '"></a><div class="geoit-category-image-top"><img class="geo-lazy" alt="'.$category->name.'" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVR42mPk5ODkAQAAZAAoQWYOjQAAAABJRU5ErkJggg==" data-src="'.esc_url( $image ).'" /></div><div class="geoit-category-image-content"><h5>'.$prefix.$category->name.$affix.'</h5></div></div>';
					} else {
						echo '<div class="geoit-category-image"><a class="uckan-card--url" href="' . get_category_link( $category->term_id ) . '"></a><div class="geoit-category-image-top"><img class="geo-lazy" alt="'.$category->name.'" src="'.esc_url( $image ).'" /></div><div class="geoit-category-image-content"><h5>'.$prefix.$category->name.$affix.'</h5></div></div>';
					}
				}
			}
		echo '</div>';
		endif;

		echo $after_widget;
	}
	
	public function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['title'] = $new_instance['title'];
		$instance['prefix'] = $new_instance['prefix'];
		$instance['affix'] = $new_instance['affix'];
		$instance['style'] = $new_instance['style'];

		
		return $instance;
	}

	public function form($instance)
	{
		$defaults = array('title' => __('Kategorilerimiz', 'geo'), 'style' => 'style1', 'prefix' => '', 'affix' => __('Yazıları', 'geo'));
		$instance = wp_parse_args((array) $instance, $defaults); ?>
		
		<p>
			<label for="<?php echo $this->get_field_id('style'); ?>"><?php _e( 'Görünüm' , 'geo') ?></label> 
			<select id="<?php echo $this->get_field_id('style'); ?>" name="<?php echo $this->get_field_name('style'); ?>" class="widefat" style="width:100%;">
				<option value='style1' <?php if ('style1' == $instance['style']) echo 'selected="selected"'; ?>><?php _e( 'Görünüm' , 'geo') ?> #1</option>
				<option value='style2' <?php if ('style2' == $instance['style']) echo 'selected="selected"'; ?>><?php _e( 'Görünüm' , 'geo') ?> #2</option>
				<option value='style3' <?php if ('style3' == $instance['style']) echo 'selected="selected"'; ?>><?php _e( 'Görünüm' , 'geo') ?> #3</option>
				<option value='style4' <?php if ('style4' == $instance['style']) echo 'selected="selected"'; ?>><?php _e( 'Görünüm' , 'geo') ?> #4</option>
			</select>
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Başlık' , 'geo') ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" class="widefat" type="text" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'prefix' ); ?>"><?php _e( 'Kategori Adına Ön Ek' , 'geo') ?></label>
			<input id="<?php echo $this->get_field_id( 'prefix' ); ?>" name="<?php echo $this->get_field_name( 'prefix' ); ?>" value="<?php echo $instance['prefix']; ?>" class="widefat" type="text" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'affix' ); ?>"><?php _e( 'Kategori Adına Son Ek' , 'geo') ?></label>
			<input id="<?php echo $this->get_field_id( 'affix' ); ?>" name="<?php echo $this->get_field_name( 'affix' ); ?>" value="<?php echo $instance['affix']; ?>" class="widefat" type="text" />
		</p>
		



	<?php }
}
?>