<?php
  /**
 * Add function to widgets_init that'll load our widget.
 */
add_action('widgets_init','geo_login_widgets');

function geo_login_widgets(){
	register_widget("geo_login_widget");
}

/**
 * This class handles everything that needs to be handled with the widget:
 * the settings, form, display, and update.  Nice!
 *
 */
class geo_login_widget extends WP_widget{
	
	/**
	 * Widget setup.
	 */
	public function __construct(){
		
		/* Widget settings. */
		$widget_ops = array('classname' => 'widget_login');
		
		/* Create the widget. */
		parent::__construct('geo_login_widget', THEME_NAME .' - '.__( "Giriş" , 'geo' ) , $widget_ops );		
	}
	
	/**
	 *display the widget on the screen.
	 */
	public function widget($args,$instance){
		extract($args);
			$title = apply_filters('widget_title', $instance['title'] );
			
			echo $before_widget;
			if($title) {
				if ( !is_user_logged_in() ) {
					echo $before_title . $title . $after_title;
				}
				else {
					echo ''.$before_title.__('Hakkımda', 'geo'). $after_title.'';
				}
			}
			$fav_page_url = ot_get_option('geo-favorites');
			$posting_url = ot_get_option('geo-posting');


			if ( is_user_logged_in() ) {
				echo '<div class="geo_login-widget">';
					$current_user = wp_get_current_user();
					global $current_user;
					$avatar = geoit_get_avatar($current_user->ID, 50);
					$logout = wp_logout_url( home_url() );
					$fav_page_url = ot_get_option('geo-favorites');
					$posting_url = ot_get_option('geo-posting');
					$settings_url = ot_get_option('geo_profile');
					echo '<div class="geoit_has-login">';	
						echo '<div class="login_widget_top"><div class="login_avatar">'.$avatar.'</div>';
						echo ''.__('Hoş geldiniz', 'geo').' <a href="'.get_author_posts_url( get_the_author_meta( 'ID', $current_user->ID ) ).'">'. $current_user->display_name .'</a><br>';
						if (ot_get_option('geo_puan_sistem') == 'on') {
						echo geo_get_rank($current_user->ID);
						echo '</div><div class="geo_puan">'.geo_get_points($current_user->ID).' '.__('Puan', 'geo').'</div>';
						}
					echo '</div>';
				echo '</div>';
			}
			else {
				echo '<div class="geoit_login-wrapper login">';
				$serror = geoit_login_error_messages();
				if (!empty($serror)){
					echo '<div class="geoit_login-hata" style="margin-top: 0px">'.$serror.'</div>';
				}
				if ( get_option( 'users_can_register' ) ) {
				echo '<div class="widget-social-accounts">';
					if (ot_get_option('geo_facebook_login') == 'on') {
						echo '<a title="'.__('Facebook ile Bağlan', 'geo').'" class="s-link social-btn facebook" href="'.get_site_url().'/wp-login.php?loginSocial=facebook" data-plugin="nsl" data-action="connect" data-redirect="current" data-provider="facebook" data-popupwidth="475" data-popupheight="175">
							<i class="fa fa-facebook"></i>
						</a>';
					}
					if (ot_get_option('geo_twitter_login') == 'on') {
						echo '<a title="'.__('Twitter ile Bağlan', 'geo').'"  class="s-link social-btn twitter" href="'.get_site_url().'/wp-login.php?loginSocial=twitter" data-plugin="nsl" data-action="connect" data-redirect="current" data-provider="twitter" data-popupwidth="600" data-popupheight="600">
							<i class="fa fa-twitter"></i>
						</a>';
					}
					if (ot_get_option('geo_google_login') == 'on') {
						if(ot_get_option('geoit_lazy_images') == 'on') {
							$img = '<img class="geo-lazy" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVR42mPk5ODkAQAAZAAoQWYOjQAAAABJRU5ErkJggg==" data-src="'.get_template_directory_uri().'/assets/img/google.svg" width="18" height="18" alt="google_login" />';
						} else {
							$img = '<img src="'.get_template_directory_uri().'/assets/img/google.svg" width="18" height="18" alt="google_login" />';
						}
						echo '<a title="'.__('Google ile Bağlan', 'geo').'" class="s-link social-btn" href="'.get_site_url().'/wp-login.php?loginSocial=google" data-plugin="nsl" data-action="connect" data-redirect="current" data-provider="google" data-popupwidth="600" data-popupheight="600">
							'.$img.'
						</a>';
					}
				echo '</div>';
				
			}
				wp_login_form([
					'form_id'        => 'loginform_widget',
					'id_username'    => 'user_login_widget',
					'id_password'    => 'user_pass_widget',
					'id_remember'    => 'rememberme_widget',
					'id_submit'      => 'wp-submit_widget',
					'redirect' => $_SERVER['REQUEST_URI'].'?login=true',
					'label_log_in' => __('Giriş Yap', 'geo'),
				]);
				$register_url = ot_get_option('geo-register');
				$forgot_url = ot_get_option('geo-forgot');
				if ( get_option( 'users_can_register' ) ) {
					echo '<div class="geoit_login_232"><div class="or-div"><span>'.__('veya', 'geo').'</span></div>';
					echo '<div class="widget-social-accounts">';
					if ($register_url != '') {
						echo '<a class="reg_btn" href="'.get_page_link($register_url).'">'.__("Kayıt Ol", "geo").'</a>';
					}
					else {
						echo '<a class="reg_btn" href="'.site_url().'/wp-login.php?action=register">'.__("Kayıt Ol", "geo").'</a>';
					}
					if ($forgot_url != '') {
						echo '<a class="forgot_btn" href="'.get_page_link($forgot_url).'">'.__("Şifremi Unuttum", "geo").'</a>';
					}
					else {
						echo '<a class="forgot_btn" href="'.get_site_url(null, '/wp-login.php?action=lostpassword').'">'.__("Şifremi Unuttum", "geo").'</a>';
					}
					echo '</div>';
					echo '</div>';
				}
				echo '</div>';
			}
			
			echo $after_widget;
	}
	
	/**
	 * update widget settings
	 */
	public function update($new_instance, $old_instance){
		$instance = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );
		
		return $instance;
	}
	
	/**
	 * Displays the widget settings controls on the widget panel.
	 * Make use of the get_field_id() and get_field_name() function
	 * when creating your form elements. This handles the confusing stuff.
	 */
	public function form($instance){
		$defaults = array('title' => __('Giriş', 'geo'), 'link' => '', 'image' => '');
		$instance = wp_parse_args((array) $instance, $defaults);
		?>	
				
		<p>			

			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Başlık', 'geo') ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" />
		</p>
		<?php
	}
}
?>