<?php
add_action( 'widgets_init', 'mega_posts_widget' );
function mega_posts_widget() {
	register_widget( 'mega_posts' );
}
class mega_posts extends WP_Widget {
	public function __construct(){
		$widget_ops = array( 'classname' => 'megapost' );
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'megapost_widget' );
		parent::__construct( 'megapost_widget', THEME_NAME .' - '.__( "Mega Menü için Yazı Bileşeni" , 'geo' ) , $widget_ops, $control_ops );
	}
	
	public function widget( $args, $instance ) {
		extract( $args );

		$title = apply_filters('widget_title', $instance['title'] );
		$no_of_posts = $instance['no_of_posts'];
		$sortby = $instance['sortby'];
		$cats_id = $instance['cats_id'];
		$postnotin = !empty($instance['postnotin']) ? $instance['postnotin'] : '';
		
		$exlude = $postnotin;
		$excludeposts = explode(",", $exlude);

		echo $before_widget;
		
		if($sortby == 'commented') {
			$sp_query = new WP_Query(
				array( 
					'showposts' => $no_of_posts, 
					'cat' => $cats_id,
					'orderby' => 'comment_count',
					'post__not_in' => $excludeposts
				)
			);
		}
		elseif($sortby == 'random') {
			$sp_query = new WP_Query(
				array( 
					'cat' => $cats_id,
					'showposts' => $no_of_posts,
					'orderby' => 'rand',
					'post__not_in' => $excludeposts
				)
			);
		}
		elseif($sortby == 'post-viewed') {
			$sp_query = new WP_Query(
				array( 
					'cat' => $cats_id,
					'showposts' => $no_of_posts,
					'orderby' => 'post_views',
					'order'	=> 'desc',
					'suppress_filters' => false,
					'post__not_in' => $excludeposts
				)
			);
		}
		else {
			$sp_query = new WP_Query(
				array( 
					'cat' => $cats_id,
					'showposts' => $no_of_posts,
					'post__not_in' => $excludeposts
				)
			);
		} 
		if ( $sp_query->have_posts() ): ?>
			<div class="geoit_mega_cards">
				<?php while ( $sp_query->have_posts() ) : $sp_query->the_post(); global $post; ?>
					<div class="uck-card geoit_mega_card">
						<?php if(has_post_thumbnail()): ?>
							<div class="uck-card--image">
								<a href='<?php the_permalink(); ?>' title='<?php the_title(); ?>'>
									<?php the_post_thumbnail('geo-medium'); ?>
								</a>
								<?php echo get_simple_likes_button( get_the_ID() ); ?>
							</div>
						<?php endif; ?>
						<div class="uck-card--content">
							<?php the_title( sprintf( '<h2 class="headline"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
							<span class="date"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?></span>
							<?php echo geoit_block_views(); ?>
							<?php geoit_trending_post(get_the_ID()); ?>
						</div>
					</div>
				<?php endwhile; ?>
			</div>
		<?php else: ?>
			<div style="padding: 1em"><?php _e('Listelenecek herhangi bir yazı bulunamadı.', 'geo'); ?></div>
		<?php endif;
		
		echo $after_widget;
	}

	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['no_of_posts'] = $new_instance['no_of_posts'];
		$instance['cats_id'] = $new_instance['cats_id'];
		$instance['sortby'] = $new_instance['sortby'];
		$instance['postnotin'] = $new_instance['postnotin'];

		return $instance;
	}

	public function form( $instance ) {
		$defaults = array( 'no_of_posts' => '5' , 'cats_id' => '0', 'sortby' => 'recent', 'postnotin' => '',);
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>
		<p>
			<label for="<?php echo $this->get_field_id('sortby'); ?>"><?php _e( 'Göre Sırala' , 'geo') ?></label> 
			<select id="<?php echo $this->get_field_id('sortby'); ?>" name="<?php echo $this->get_field_name('sortby'); ?>" class="widefat" style="width:100%;">
				<option value='recent' <?php if ('recent' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'Yayınlanma Tarihine Göre' , 'geo') ?></option>
				<option value='commented' <?php if ('commented' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'En Çok Yorum Yapılan' , 'geo') ?></option>
				<option value='post-viewed' <?php if ('post-viewed' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'En Çok Okunan' , 'geo') ?></option>
				<option value='random' <?php if ('random' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'Rastgele' , 'geo') ?></option>
			</select>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'no_of_posts' ); ?>"><?php _e( 'Yazı Sayısı' , 'geo') ?></label>
			<input id="<?php echo $this->get_field_id( 'no_of_posts' ); ?>" name="<?php echo $this->get_field_name( 'no_of_posts' ); ?>" value="<?php echo $instance['no_of_posts']; ?>" type="text" size="3" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('cats_id'); ?>"><?php _e( 'Kategori' , 'geo') ?></label> 
			<select id="<?php echo $this->get_field_id('cats_id'); ?>" name="<?php echo $this->get_field_name('cats_id'); ?>" class="widefat categories" style="width:100%;">
				<option value='all' <?php if ('all' == $instance['cats_id']) echo 'selected="selected"'; ?>><?php _e( 'Hepsi' , 'geo') ?></option>
				<?php $cats_id = get_categories('hide_empty=0&depth=1&type=post'); ?>
				<?php foreach($cats_id as $cats_id) { ?>
				<option value='<?php echo $cats_id->term_id; ?>' <?php if ($cats_id->term_id == $instance['cats_id']) echo 'selected="selected"'; ?>><?php echo $cats_id->cat_name; ?></option>
				<?php } ?>
			</select>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'postnotin' ); ?>"><?php _e( 'Hariç Tutulan Yazılar' , 'geo') ?></label>
			<br><i><?php _e('Yazı idlerini virgül ile ayırarak girin', 'geo'); ?></i>
			<input id="<?php echo $this->get_field_id( 'postnotin' ); ?>" name="<?php echo $this->get_field_name( 'postnotin' ); ?>" value="<?php echo $instance['postnotin']; ?>" class="widefat" type="text" />
		</p>
	<?php
	}
}
?>