<?php
add_action( 'widgets_init', 'geoit_widget_popular_tags' );
function geoit_widget_popular_tags() {
	register_widget( 'geoit_widget_popular_tags' );
}
class geoit_widget_popular_tags extends WP_Widget {
	public function __construct(){
		$widget_ops = array( 'classname' => 'geoit_widget_popular_tags' );
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'geoit_widget_popular_tags' );
		parent::__construct( 'geoit_widget_popular_tags', ''.THEME_NAME .' - '.__( "Popüler Etiketler" , 'geo' ), $widget_ops, $control_ops );
	}
	
	public function widget( $args, $instance ) {
		extract( $args );

		$title = apply_filters('widget_title', $instance['title'] );
		$no_of_posts = $instance['no_of_posts'];
		$sortby = $instance['sortby'];
		$show_count = isset($instance['show_count']) ? true : false;

		echo $before_widget;
		
		if(!empty($title)) {
			echo $before_title;
				echo $title; 
			echo $after_title;
		}
		
		$tags = get_tags();


$args = array(
	'smallest' => '12',
	'largest' => '12',
	'unit' => 'px',
	'number' => $no_of_posts,
	'format' => 'flat',
	'separator' => " ",
	'orderby' => 'count',
	'order' => $sortby,
	'show_count' => $show_count,
	'echo' => false
);


 


$tag_string = wp_generate_tag_cloud( $tags, $args );
echo '<div class="tagcloud">'.$tag_string.'</div>';


		echo $after_widget;
	}

	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['no_of_posts'] = $new_instance['no_of_posts'];
		$instance['sortby'] = $new_instance['sortby'];
		$instance['show_count'] = $new_instance['show_count'];

		return $instance;
	}

	public function form( $instance ) {
		$defaults = array( 'title' =>__( 'Modül' , 'geo'), 'no_of_posts' => '5' , 'sortby' => 'DESC', 'show_count' => 'off' );
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>
		
		<p>
			<label for="<?php echo $this->get_field_id('sortby'); ?>"><?php _e( 'Göre Sırala' , 'geo') ?></label> 
			<select id="<?php echo $this->get_field_id('sortby'); ?>" name="<?php echo $this->get_field_name('sortby'); ?>" class="widefat" style="width:100%;">
				<option value='ASC' <?php if ('ASC' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'Artan' , 'geo') ?></option>
				<option value='DESC' <?php if ('DESC' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'Azalan' , 'geo') ?></option>
				<option value='RAND' <?php if ('RAND' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'Rastgele' , 'geo') ?></option>
			</select>
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Başlık' , 'geo') ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" class="widefat" type="text" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'no_of_posts' ); ?>"><?php _e( 'Etiket Sayısı' , 'geo') ?></label>
			<input id="<?php echo $this->get_field_id( 'no_of_posts' ); ?>" name="<?php echo $this->get_field_name( 'no_of_posts' ); ?>" value="<?php echo $instance['no_of_posts']; ?>" type="text" size="3" />
		</p>
		
		<p>
			<input class="checkbox" type="checkbox" <?php checked($instance['show_count'], 'on'); ?> id="<?php echo $this->get_field_id('show_count'); ?>" name="<?php echo $this->get_field_name('show_count'); ?>" /> 
			<label for="<?php echo $this->get_field_id('show_count'); ?>"><?php _e( 'Yazı Sayısını Göster' , 'geo') ?></label>
		</p>
		
	<?php
	}
}
?>