<?php
add_action('widgets_init', 'geo_recent_posts_main_widgets');
function geo_recent_posts_main_widgets()
{
	register_widget('geo_recent_posts_main_widget');
}
class geo_recent_posts_main_widget extends WP_Widget {
	public function __construct(){
		$widget_ops = array('classname' => 'geo_recent_posts_widget');
		$control_ops = array('id_base' => 'geo_recent_posts_widget');
		parent::__construct('geo_recent_posts_widget', ''.THEME_NAME .' - '.__( "Son Yazılar" , 'geo' ) , $widget_ops, $control_ops );

	}
	
	public function widget($args, $instance)
	{
		extract($args);
		

		$title = $instance['title'];
		$sortby = !empty($instance['sortby']) ? $instance['sortby'] : 'recent';
		$style = !empty($instance['style']) ? $instance['style'] : 'blog-list';
		$postnotin = !empty($instance['postnotin']) ? $instance['postnotin'] : '';
		
		$exlude = $postnotin;
		$excludeposts = explode(",", $exlude);
		
		$link = ($categories == 'all' || $categories == '') ? '' : '<a title="'.__('Tüm Yazılar', 'geo').'" class="title-all" href="'.get_category_link($categories).'"><i class="fa fa-arrow-right"></i></a>';

		if($sortby == 'commented') {
			query_posts(
				array( 
					'orderby' => 'comment_count',
					'post__not_in' => $excludeposts,
					'paged' => ( get_query_var('paged') ? get_query_var('paged') : 1 )
				)
			);
		}
		elseif($sortby == 'random') {
			query_posts(
				array( 
					'orderby' => 'rand',
					'post__not_in' => $excludeposts,
					'paged' => ( get_query_var('paged') ? get_query_var('paged') : 1 )
				)
			);
		}
		elseif($sortby == 'post-viewed') {
			query_posts(
				array( 
					'orderby' => 'post_views',
					'order'	=> 'desc',
					'suppress_filters' => false,
					'post__not_in' => $excludeposts,
					'paged' => ( get_query_var('paged') ? get_query_var('paged') : 1 )
				)
			);
		}
		?>
		<div class="content__recent-posts--group">
			<?php if(!empty($title)) {
			echo $before_title;
				echo $title; 
				echo $link;
			echo $after_title;
		} ?>
			<?php $counter = 0; $ad = ot_get_option('geo-5-ads'); if ( have_posts() ) : ?>
				<?php 
					if ( $style == 'blog-list' ) { ?>
					<div class="post-list-group">
						<?php while ( have_posts() ) : the_post(); $counter++;
							if ($ad != '' && $counter == 2) {
								echo $ad;
							}
							get_template_part('frameworks/template-parts/post/post-list', get_post_format() );
						endwhile; ?>
					</div>
					<?php }
					elseif ( $style == 'blog-timeline' ) { 
						if ($ad != '' && $counter == 2) {
							echo $ad;
						}?>
						<div class="masonry">
							<?php while ( have_posts() ) : the_post(); $counter++; ?>
							<?php get_template_part('frameworks/template-parts/post/post-timeline', get_post_format() ); ?>		
							<?php endwhile; ?>
						</div>
					<?php }
					elseif ( $style == 'blog-masonry' ) { 
						if ($ad != '' && $counter == 2) {
							echo $ad;
						}?>
						<div class="masonry">
							<?php while ( have_posts() ) : the_post(); $counter++; ?>
							<?php get_template_part('frameworks/template-parts/post/post', get_post_format() ); ?>		
							<?php endwhile; ?>
						</div>
					<?php }
					elseif ( $style == 'blog-masonry2' ) { 
						if ($ad != '' && $counter == 2) {
							echo $ad;
						}?>
						<div class="masonry">
							<?php while ( have_posts() ) : the_post(); $counter++; ?>
							<?php get_template_part('frameworks/template-parts/post/post-masonry', get_post_format() ); ?>		
							<?php endwhile; ?>
						</div>
					<?php }
					elseif ( $style == 'blog-big' ) { 
						if ($ad != '' && $counter == 2) {
							echo $ad;
						}?>
						<div class="blog-big-group">
							<?php while ( have_posts() ) : the_post(); $counter++; ?>
							<?php get_template_part('frameworks/template-parts/post/post-big', get_post_format() ); ?>		
							<?php endwhile; ?>
						</div>
					<?php }
					else { ?>
						<div class="masonry masonry-grid">
							<?php while ( have_posts() ) : the_post(); $counter++;
							if ($ad != '' && $counter == 2) {
								echo $ad;
							}?>
							<?php get_template_part('frameworks/template-parts/post/post-grid', get_post_format() );?>	
							<?php endwhile; ?>
						</div>
					<?php }
				?>
				<?php the_posts_pagination( array(
					'prev_text'          => '<i class="fa fa-long-arrow-left"></i>',
					'next_text'          => '<i class="fa fa-long-arrow-right"></i>',
					'mid_size' => 5,
				) ); ?>
			<?php else : ?>
				<?php get_template_part( 'frameworks/template-parts/post/post', 'none' ); ?>
			<?php endif; ?>
		</div>
		<?php wp_reset_query(); ?>
		<?php
	}
	
	public function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = $new_instance['title'];
		$instance['sortby'] = $new_instance['sortby'];
		$instance['style'] = $new_instance['style'];
		
		return $instance;
	}

	public function form($instance)
	{
		$defaults = array('sortby' => 'recent', 'title' => __('Son Yazılar', 'geo'),'postnotin' => '', 'style' => 'blog-list');
		$instance = wp_parse_args((array) $instance, $defaults); ?>
		<p>
			<label for="<?php echo $this->get_field_id('sortby'); ?>"><?php _e( 'Göre Sırala' , 'geo') ?></label> 
			<select id="<?php echo $this->get_field_id('sortby'); ?>" name="<?php echo $this->get_field_name('sortby'); ?>" class="widefat" style="width:100%;">
				<option value='recent' <?php if ('recent' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'Yayınlanma Tarihine Göre' , 'geo') ?></option>
				<option value='commented' <?php if ('commented' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'En Çok Yorum Yapılan' , 'geo') ?></option>
				<option value='post-viewed' <?php if ('post-viewed' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'En Çok Okunan' , 'geo') ?></option>
			</select>
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id('style'); ?>"><?php _e( 'Görünüm' , 'geo') ?></label> 
			<select id="<?php echo $this->get_field_id('style'); ?>" name="<?php echo $this->get_field_name('style'); ?>" class="widefat" style="width:100%;">
				<option value='blog-list' <?php if ('blog-list' == $instance['style']) echo 'selected="selected"'; ?>><?php _e( 'Liste' , 'geo') ?></option>
				<option value='blog-masonry' <?php if ('blog-masonry' == $instance['style']) echo 'selected="selected"'; ?>><?php _e( 'İkili Grid' , 'geo') ?></option>
				<option value='blog-masonry2' <?php if ('blog-masonry2' == $instance['style']) echo 'selected="selected"'; ?>><?php _e( 'İkili Grid 2)' , 'geo') ?></option>
				<option value='blog-grid' <?php if ('blog-grid' == $instance['style']) echo 'selected="selected"'; ?>><?php _e( 'Üçlü Grid' , 'geo') ?></option>
				<option value='blog-big' <?php if ('blog-masonry2' == $instance['style']) echo 'selected="selected"'; ?>><?php _e( 'Klasik' , 'geo') ?></option>
				<option value='blog-timeline' <?php if ('blog-timeline' == $instance['style']) echo 'selected="selected"'; ?>><?php _e( 'Timeline' , 'geo') ?></option>
	
			</select>
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Başlık' , 'geo') ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" class="widefat" type="text" />
		</p>
		<div style="margin:1em 0;padding: 1em;background:rgba(76, 175, 80, 0.14);border-radius:4px">Bu bileşen sadece "Homepage" alanı ile uyumludur, lütfen diğer alanlarda kullanmayın.</div>
	<?php }
}
?>