<?php
add_action( 'widgets_init', 'geoit_recent_comments' );
function geoit_recent_comments() {
	register_widget( 'geoit_recentcomments' );
}
class geoit_recentcomments extends WP_Widget {
	public function __construct(){
		$widget_ops = array( 'classname' => 'geoit_recentcomments' );
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'recentcomments_widget' );
		parent::__construct( 'recentcomments_widget', THEME_NAME .' - '.__( "Son Yorumlar" , 'geo' ) , $widget_ops, $control_ops );
	}
	
	public function widget( $args, $instance ) {
		extract( $args );

		$title = apply_filters('widget_title', $instance['title'] );
		$posts = $instance['posts'];


		echo $before_widget;
			$output = (!empty($title)) ? $before_title.$title.$after_title : '';
			$comments = get_comments( apply_filters( 'widget_comments_args', array( 'number' => $posts, 'status' => 'approve', 'post_status' => 'publish', 'type'=> 'comment') ) );
			$output .= '<ul>';
			foreach ( (array) $comments as $comment) {
				
        $output .=  '<li class="geoit_recent_comments">';
					$output .=  '<div class="geoit_recent_comments_avatar">'. geoit_get_avatar( $comment->comment_author_email, 50 ).'</div>';
					$output .= '<div class="geoit_recent_comments_content"><a class="headline" href="' . esc_url( get_comment_link($comment->comment_ID) ) . '">'.get_the_title($comment->comment_post_ID).'</a><p>'.get_comment_excerpt($comment->comment_ID).'</p></div>';
			}
			$output .= '</ul>';
			echo $output;
		
		echo $after_widget;
	}

	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['posts'] = $new_instance['posts'];

		return $instance;
	}

	public function form( $instance ) {
		$defaults = array('posts' => 5, 'title' => __('Son Yorumlar', 'geo'), 'posts' => '5');
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Başlık' , 'geo') ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" class="widefat" type="text" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id('posts'); ?>"><?php _e( 'Yazı Sayısı' , 'geo') ?></label>
			<input type="number" class="widefat" min="1" max="20" id="<?php echo $this->get_field_id('posts'); ?>" name="<?php echo $this->get_field_name('posts'); ?>" value="<?php echo $instance['posts']; ?>" />
		</p>

	<?php
	}
}
?>