<?php
  /**
 * Add function to widgets_init that'll load our widget.
 */
add_action('widgets_init','geo_social_widgets');

function geo_social_widgets(){
	register_widget("geo_social_widget");
}

/**
 * This class handles everything that needs to be handled with the widget:
 * the settings, form, display, and update.  Nice!
 *
 */
class geo_social_widget extends WP_widget{
	
	/**
	 * Widget setup.
	 */
	public function __construct(){
		
		/* Widget settings. */
		$widget_ops = array('classname' => 'widget_social');
		
		/* Create the widget. */
		parent::__construct('geo_social_widget', THEME_NAME .' - '.__( "Sosyal Medya" , 'geo' ) , $widget_ops );		
	}
	
	/**
	 *display the widget on the screen.
	 */
	public function widget($args,$instance){
		extract($args);
			$title = apply_filters('widget_title', $instance['title'] );
			$facebook = (!empty($instance['facebook'])) ? $instance['facebook'] : '';
			$twitter = (!empty($instance['twitter'])) ? $instance['twitter'] : '';
			$linkedin = (!empty($instance['linkedin'])) ? $instance['linkedin'] : '';
			$pinterest = (!empty($instance['pinterest'])) ? $instance['pinterest'] : '';
			$youtube = (!empty($instance['youtube'])) ? $instance['youtube'] : '';
			$medium = (!empty($instance['medium'])) ? $instance['medium'] : '';
			$instagram = (!empty($instance['instagram'])) ? $instance['instagram'] : '';
			$telegram = (!empty($instance['telegram'])) ? $instance['telegram'] : '';
			
			echo $before_widget;
			if ( $title ) {
			echo $before_title . $title . $after_title;
			}
			?>	

			<div class="widget-social-accounts">
				<?php if ( $facebook ) : ?>
					<a rel="nofollow noopener" target="_blank" class="s-link facebook" href="<?php echo $facebook; ?>">
						<span class="w-icon"><i class="fa fa-facebook"></i></span>
						<span class="text"><?php _e('Beğen','geo'); ?></span>
					</a>
				<?php endif; ?>
				<?php if ( $twitter ) : ?>
					<a rel="nofollow noopener" target="_blank" class="twitter s-link" href="<?php echo $twitter; ?>">
						<span class="w-icon"><i class="fa fa-twitter"></i></span>
						<span class="text"><?php _e('Takip','geo'); ?></span>
					</a>
				<?php endif; ?>
				<?php if ( $linkedin ) : ?>
					<a rel="nofollow noopener" target="_blank" class="s-link linkedin" href="<?php echo $linkedin; ?>">
						<span class="w-icon"><i class="fa fa-linkedin"></i></span>
						<span class="text"><?php _e('Takip','geo'); ?></span>
					</a>
				<?php endif; ?>
				<?php if ( $medium ) : ?>
					<a rel="nofollow noopener" target="_blank" class="s-link medium" href="<?php echo $medium; ?>">
						<span class="w-icon"><i class="fa fa-medium"></i></span>
						<span class="text"><?php _e('Takip','geo'); ?></span>
					</a>
				<?php endif; ?>
				<?php if ( $pinterest ) : ?>
					<a rel="nofollow noopener" target="_blank" class="s-link pinterest" href="<?php echo $pinterest; ?>">
						<span class="w-icon"><i class="fa fa-pinterest"></i></span>
						<span class="text"><?php _e('Takip','geo'); ?></span>
					</a>
				<?php endif; ?>
				<?php if ( $youtube ) : ?>
					<a rel="nofollow noopener" target="_blank" class="s-link youtube" href="<?php echo $youtube; ?>">
						<span class="w-icon"><i class="fa fa-youtube"></i></span>
						<span class="text"><?php _e('Abone','geo'); ?></span>
					</a>
				<?php endif; ?>
				<?php if ( $instagram ) : ?>
					<a rel="nofollow noopener" target="_blank" class="s-link instagram" href="<?php echo $instagram; ?>">
						<span class="w-icon"><i class="fa fa-instagram"></i></span>
						<span class="text"><?php _e('Takip','geo'); ?></span>
					</a>
				<?php endif; ?>
				<?php if ( $telegram ) : ?>
					<a rel="nofollow noopener" target="_blank" class="s-link telegram" href="<?php echo $telegram; ?>">
						<span class="w-icon"><i class="fa fa-telegram"></i></span>
						<span class="text"><?php _e('Takip','geo'); ?></span>
					</a>
				<?php endif; ?>
			</div>

	  <?php 
			echo $after_widget;
	}
	
	/**
	 * update widget settings
	 */
	public function update($new_instance, $old_instance){
		$instance = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['facebook'] = $new_instance['facebook'];
		$instance['twitter'] = $new_instance['twitter'];
		$instance['pinterest'] = $new_instance['pinterest'];
		$instance['linkedin'] = $new_instance['linkedin'];
		$instance['youtube'] = $new_instance['youtube'];
		$instance['medium'] = $new_instance['medium'];
		$instance['instagram'] = $new_instance['instagram'];
		$instance['telegram'] = $new_instance['telegram'];
		return $instance;
	}

	public function form($instance){
		$defaults = array('title' => __('Sosyal Medya', 'geo'), 'facebook' => '', 'twitter' => '', 'linkedin' => '', 'pinterest' => '', 'medium' => '', 'youtube' => '', 'instagram' => '', 'telegram' => '' );
		$instance = wp_parse_args((array) $instance, $defaults);
		?>	
				
		<p>	
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Başlık', 'geo') ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id('facebook'); ?>">Facebook</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id('facebook'); ?>" name="<?php echo $this->get_field_name('facebook'); ?>" value="<?php echo $instance['facebook']; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('twitter'); ?>">Twitter</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id('facebook'); ?>" name="<?php echo $this->get_field_name('twitter'); ?>" value="<?php echo $instance['twitter']; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('pinterest'); ?>">Pinterest</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id('pinterest'); ?>" name="<?php echo $this->get_field_name('pinterest'); ?>" value="<?php echo $instance['pinterest']; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('linkedin'); ?>">Linkedin</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id('linkedin'); ?>" name="<?php echo $this->get_field_name('linkedin'); ?>" value="<?php echo $instance['linkedin']; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('medium'); ?>">Medium.com</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id('medium'); ?>" name="<?php echo $this->get_field_name('medium'); ?>" value="<?php echo $instance['medium']; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('youtube'); ?>">Youtube</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id('facebook'); ?>" name="<?php echo $this->get_field_name('youtube'); ?>" value="<?php echo $instance['youtube']; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('instagram'); ?>">Instagram</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id('instagram'); ?>" name="<?php echo $this->get_field_name('instagram'); ?>" value="<?php echo $instance['instagram']; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id('telegram'); ?>">Telegram</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id('telegram'); ?>" name="<?php echo $this->get_field_name('telegram'); ?>" value="<?php echo $instance['telegram']; ?>" />
		</p>
		<?php
	}
}
?>