<?php
add_action( 'widgets_init', 'trending_posts_widget' );
function trending_posts_widget() {
	register_widget( 'trending_posts' );
}
class trending_posts extends WP_Widget {
	public function __construct(){
		$widget_ops = array( 'classname' => 'trending_post' );
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'trending_post_widget' );
		parent::__construct( 'trending_post_widget', ''.THEME_NAME .' - '.__( "Popüler Yazılar" , 'geo' ).'', $widget_ops, $control_ops );
	}
	
	public function widget( $args, $instance ) {
		extract( $args );

		$title = apply_filters('widget_title', $instance['title'] );
		$no_of_posts = $instance['no_of_posts'];
		$cats_id = $instance['cats_id'];
		$sortby = $instance['sortby'];
		$style = ($instance['style']) ? $instance['style'] : 'style1';
		
		$link = ($categories == 'all' || $cats_id == '') ? '' : '<a title="'.__('Tüm Yazılar', 'geo').'" class="title-all" href="'.get_category_link($cats_id).'"><i class="fa fa-arrow-right"></i></a>';

		echo $before_widget;
		
		if(!empty($title)) {
			echo $before_title;
				echo $title; 
				echo $link;
			echo $after_title;
		}
		
		if ($sortby == 'post-viewed') {
			$geo_query = new WP_Query(array(
				'post_type'=>'post', // your post type name
				'orderby' => 'post_views',
				'order'	=> 'desc',
				'suppress_filters' => false,
				'cat' => $cats_id,
				'showposts' => $no_of_posts, // post per page
			));
		} else {
			$geo_query= new WP_Query(array(
				'post_type'=>'post', // your post type name
				'meta_query' => array(
					array(
						'key' => 'geoit_post_trending',
						'value' => 'on',
						'compare' => '='
					)
				),
				'meta_key' => 'geoit_post_trending',
				'orderby' => 'meta_value_num',
				'order' => 'DESC',
				'showposts' => $no_of_posts, // post per page
				'cat' => $cats_id,
			));
		}
		?>
		
		<?php if($geo_query->have_posts()) : ?>
			<div class="geoit-popular-posts">
			<?php $counter=0; while($geo_query->have_posts())  : $geo_query->the_post(); global $post; $counter++; ?>
			
				<?php if ($style == 'style1'): ?>
					<div class="geoit-popular-post-item">
						<?php if(has_post_thumbnail()): ?>
							<div class="uck-card--image">
								<a href='<?php the_permalink(); ?>' title='<?php the_title(); ?>'>
									<?php the_post_thumbnail('geo-big2'); ?>
								</a>
								<?php echo get_simple_likes_button( get_the_ID() ); ?>
							</div>
							<div class="post-counter-label"><?php echo $counter; ?></div>
						<?php endif; ?>
						<div class="geoit-popular-post-content">
							<?php the_title( sprintf( '<h3 class="headline"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
							<div class="geoit-popular-post-meta">
								<?php if ($sortby != 'post-viewed'): ?>
									<span class="date"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?></span>
								<?php else: ?>
									<?php echo geoit_block_views(); ?>
								<?php endif; ?>
							</div>
						</div>
					</div>
				<?php elseif($style == 'style2'): ?>
					<div class="geoit-popular-post-item geoit-popular-post-item-style2">
						<div class="post-counter-label"><?php echo $counter; ?></div>
						<div class="geoit-popular-post-content">
							<?php the_title( sprintf( '<h3 class="headline"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
							<div class="geoit-popular-post-meta">
								<?php if ($sortby != 'post-viewed'): ?>
									<span class="date"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?></span>
								<?php else: ?>
									<?php echo geoit_block_views(); ?>
								<?php endif; ?>
							</div>
						</div>
					</div>
				<?php elseif($style == 'style3'): ?>
				<?php $first_class = ''; if($counter == '1'): ?><?php $first_class = 'geoit-popular-post-active'; ?><?php endif; ?>
					<figure <?php geoit_thumbnail_background_image2(get_post_thumbnail_id(), 'geo-big2', 'geoit-popular-post-item geoit-popular-post-item-style2 geoit-popular-post-item-style3 '.$first_class.''); ?>>
						<a href="<?php echo esc_url( get_permalink() ); ?>" class="uckan-card--url"></a>
						<div class="post-counter-label"><?php echo $counter; ?></div>
						<div class="geoit-popular-post-content">
							<?php the_title( sprintf( '<h3 class="headline"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
							<div class="geoit-popular-post-meta">
								<?php if ($sortby != 'post-viewed'): ?>
									<span class="date"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?></span>
								<?php else: ?>
									<?php echo geoit_block_views(); ?>
								<?php endif; ?>
							</div>
						</div>
					</figure>
				<?php endif; ?>
				
			<?php endwhile; ?>
			</div>
		<?php endif; ?>
		
		<?php 
		echo $after_widget;
	}

	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = $new_instance['title'];
		$instance['no_of_posts'] = $new_instance['no_of_posts'];
		$instance['cats_id'] = $new_instance['cats_id'];
		$instance['sortby'] = $new_instance['sortby'];
		$instance['style'] = $new_instance['style'];

		return $instance;
	}

	public function form( $instance ) {
		$defaults = array( 'title' =>__( 'Modül' , 'geo'), 'no_of_posts' => '5', 'cats_id' => '0', 'sortby' => 'trending',' style' => 'style1'  );
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>
		
		<p>
			<label for="<?php echo $this->get_field_id('style'); ?>"><?php _e( 'Görünüm' , 'geo') ?></label> 
			<select id="<?php echo $this->get_field_id('style'); ?>" name="<?php echo $this->get_field_name('style'); ?>" class="widefat" style="width:100%;">
				<option value='style1' <?php if ('style1' == $instance['style']) echo 'selected="selected"'; ?>><?php _e( 'Görünüm' , 'geo') ?> #1</option>
				<option value='style2' <?php if ('style2' == $instance['style']) echo 'selected="selected"'; ?>><?php _e( 'Görünüm' , 'geo') ?> #2</option>
				<option value='style3' <?php if ('style3' == $instance['style']) echo 'selected="selected"'; ?>><?php _e( 'Görünüm' , 'geo') ?> #3</option>
			</select>
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id('sortby'); ?>"><?php _e( 'Göre Sırala' , 'geo') ?></label> 
			<select id="<?php echo $this->get_field_id('sortby'); ?>" name="<?php echo $this->get_field_name('sortby'); ?>" class="widefat" style="width:100%;">
				<option value='trending' <?php if ('trending' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'Trendlere Eklenen Yazılar' , 'geo') ?></option>
				<option value='post-viewed' <?php if ('post-viewed' == $instance['sortby']) echo 'selected="selected"'; ?>><?php _e( 'En Çok Okunan' , 'geo') ?></option>
			</select>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Başlık' , 'geo') ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" class="widefat" type="text" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'no_of_posts' ); ?>"><?php _e( 'Yazı Sayısı' , 'geo') ?></label>
			<input id="<?php echo $this->get_field_id( 'no_of_posts' ); ?>" name="<?php echo $this->get_field_name( 'no_of_posts' ); ?>" value="<?php echo $instance['no_of_posts']; ?>" type="text" size="3" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id('cats_id'); ?>"><?php _e( 'Kategori' , 'geo') ?></label> 
			<select id="<?php echo $this->get_field_id('cats_id'); ?>" name="<?php echo $this->get_field_name('cats_id'); ?>" class="widefat categories" style="width:100%;">
				<option value='all' <?php if ('all' == $instance['cats_id']) echo 'selected="selected"'; ?>><?php _e( 'Hepsi' , 'geo') ?></option>
				<?php $cats_id = get_categories('hide_empty=0&depth=1&type=post'); ?>
				<?php foreach($cats_id as $cats_id) { ?>
				<option value='<?php echo $cats_id->term_id; ?>' <?php if ($cats_id->term_id == $instance['cats_id']) echo 'selected="selected"'; ?>><?php echo $cats_id->cat_name; ?></option>
				<?php } ?>
			</select>
		</p>
		
	<?php
	}
}
?>