<?php
/*
Sayfa Adı: Header Sayfası
@link https://developer.wordpress.org/themes/basics/template-files/#template-partials
@url kanthemes.com
*/
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<link rel="profile" href="https://gmpg.org/xfn/11" />
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<link rel="preload" as="font" href="<?php echo get_template_directory_uri() . '/assets/fonts/geoit-font.woff'; ?>" type="font/woff" crossorigin="anonymous">
	<link rel="preload" as="font" href="<?php echo get_template_directory_uri() . '/assets/fonts/geoit-font.ttf'; ?>" type="font/ttf" crossorigin="anonymous">
	<link rel="preload" as="script" href="//ajax.googleapis.com/ajax/libs/webfont/1/webfont.js">
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php if (function_exists( 'wp_body_open' )) { wp_body_open(); }?>

	<header id="header" class="header-one">
		<?php if(ot_get_option('header-top-status') != 'off'): ?>
			<div class="header__top">
				<div class="container">
					<div class="header__row">
						<div class="header__top--left">
							<?php $top_left = !empty(ot_get_option('geo-header-top-left')) ? ot_get_option('geo-header-top-left') : ''; if($top_left == 'menu' ): ?>
								<?php if ( has_nav_menu( 'geo-header-top' ) ) :
										wp_nav_menu( array(
											'theme_location' => 'geo-header-top',
											'menu_class'     => 'geo-top-menu',
											'depth' => 1,
										)
									);
								endif; ?>
							<?php elseif($top_left == 'date'): ?>
								<span class="geoit-data-time-header"><i class="fa fa-clock-o"></i> <?php echo date_i18n( 'j  F Y - l', current_time( 'timestamp' ) ); ?></span>
							<?php else: ?>
								<?php geo_news_ticker();?>
							<?php endif; ?>
						</div>
						<div class="header__top--right">
							<div class="header__search">
								<button class="header__search--icon" aria-label="search"><i class="fa fa-search"></i></button>
							</div>
							<div class="header__search--form">
								<form method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
									<input id="searchInput" name="s" placeholder="<?php _e('Aradığınız kelimeyi bu alana girin..', 'geo');?>" type="text">
									<button type="submit" class="search-submit" aria-label="Submit"><i class="fa fa-search"></i></button>
								</form>
							</div>
							<?php if(ot_get_option('header-top-social') != 'off'): 
								geo_social_links();
							endif; ?>
							<?php geoit_login_button(); ?>
						</div>
					</div>
				</div>
			</div>
		<?php endif; ?>
		<div class="header___bottom" style="height:64px">
		<div class="header__bottom headroom">
			<div class="container">
				<div class="header__row">
					<div class="header__logo header__logo--left">
						<?php echo geoit_site_logo(); ?>
					</div>
					<div class="uck-layout-spacer"></div>
					<?php geo_mobil_login(); ?>
					<button data-toggle="geo_mobil_menu" id="mobile-menu-icon" aria-label="menu"><i class="fa fa-bars"></i></button>
					<nav class="header__bottom--menu">
						<?php if ( has_nav_menu( 'geo-header' ) ) : ?>
							<?php wp_nav_menu( array(
								'theme_location' => 'geo-header',
								'menu_class'     => 'geo-menu',
								'walker' => new description_walker(),
							) );?>
						<?php else: ?>
							<ul class="menu">
								<li><a class="header__bottom--link current-menu-item create-menu-link" href="/wp-admin/nav-menus.php"><?php _e( 'Menü Oluştur', 'geo' ); ?></a></li>
							</ul>
						<?php endif; ?>
					</nav>
				</div>
			</div>
		</div>
		</div>
	</header>
	<?php if(geo_is_mobile()): ?>
		<?php if(ot_get_option('geo-1-ads-m')): ?>
		<div class="container">
			<div class="row">
				<div class="ad ad-header ad728 ad-center"><?php echo ot_get_option('geo-1-ads-m'); ?></div>
			</div>
		</div>
		<?php endif; ?>
	<?php else: ?>
		<?php if(ot_get_option('geo-1-ads')): ?>
			<div class="container">
				<div class="row">
					<div class="ad ad-header ad728 ad-center"><?php echo ot_get_option('geo-1-ads'); ?></div>
				</div>
			</div>
		<?php endif; ?>
	<?php endif; ?>
	<?php echo geoit_stories_html(); ?>