<?php
/*
Sayfa Adı: Header Sayfası
@link https://developer.wordpress.org/themes/basics/template-files/#template-partials
@url kanthemes.com
*/
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<link rel="profile" href="https://gmpg.org/xfn/11" />
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<link rel="preload" as="font" href="<?php echo get_template_directory_uri() . '/assets/fonts/geoit-font.woff'; ?>" type="font/woff" crossorigin="anonymous">
	<link rel="preload" as="font" href="<?php echo get_template_directory_uri() . '/assets/fonts/geoit-font.ttf'; ?>" type="font/ttf" crossorigin="anonymous">
	<link rel="preload" as="script" href="//ajax.googleapis.com/ajax/libs/webfont/1/webfont.js">
	<?php wp_head(); ?>
</head>	
<body <?php body_class(); ?>>
<?php if (function_exists( 'wp_body_open' )) { wp_body_open(); }?>
	<header id="header" class="header-two">
		<div class="header__bottom">
			<div class="header__row">
				<div class="header__logo header__logo--left">
					<?php echo geoit_site_logo(); ?>
				</div>
				<div class="uck-layout-spacer"></div>
				<nav class="header__bottom--menu">
					<?php if ( has_nav_menu( 'geo-header' ) ) :
						wp_nav_menu( array(
							'theme_location' => 'geo-header',
							'menu_class'     => 'geo-menu',
							'walker' => new description_walker(),
						));?>
					<?php else: ?>
						<ul class="menu">
							<li><a class="header__bottom--link current-menu-item create-menu-link" href="/wp-admin/nav-menus.php"><?php _e( 'Menü Oluştur', 'geo' ); ?></a></li>
						</ul>
					<?php endif; ?>
				</nav>
				<div class="header__top--right">
					<?php if(ot_get_option('header-trending') != 'off'): ?>
						<div class="header__trending" data-toggle="header__trending">
							<button class="header__search--icon" aria-label="trending posts"><i class="fa fa-bolt"></i></button>
							<?php geo_news_ticker_with_popup(); ?>
						</div>
					<?php endif; ?>
					<div class="header__search">
						<button class="header__search--icon" aria-label="search"><i class="fa fa-search"></i></button>
					</div>
					<div class="header__search--form">
						<form method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
							<input id="searchInput" name="s" placeholder="<?php _e('Aradığınız kelimeyi bu alana girin..', 'geo');?>" type="text">
							<button type="submit" class="search-submit" aria-label="submit"><i class="fa fa-search"></i></button>
						</form>
					</div>
					<?php if(ot_get_option('header-top-social') != 'off'): 
						geo_social_links();
					endif;
					geoit_login_button(); ?>
				</div>
				<?php geo_mobil_login(); ?>
				<button data-toggle="geo_mobil_menu" id="mobile-menu-icon" aria-label="menu"><i class="fa fa-bars"></i></button>
			</div>
		</div>
	</header>
	<?php if(geo_is_mobile()): ?>
		<?php if(ot_get_option('geo-1-ads-m')): ?>
		<div class="container">
			<div class="row">
				<div class="ad ad-header ad728 ad-center"><?php echo ot_get_option('geo-1-ads-m'); ?></div>
			</div>
		</div>
		<?php endif; ?>
	<?php else: ?>
		<?php if(ot_get_option('geo-1-ads')): ?>
		<div class="container">
			<div class="row">
				<div class="ad ad-header ad728 ad-center"><?php echo ot_get_option('geo-1-ads'); ?></div>
			</div>
		</div>
		<?php endif; ?>
	<?php endif; ?>
	<?php echo geoit_stories_html(); ?>