<?php
/**
 * Template Name: Yazı Ekle
 * @url kanthemes.com
 */
__( 'Yazı Ekle', 'geo' );
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

if (isset($_POST['g-recaptcha-response']) && $_POST['g-recaptcha-response'] == 0) {
	echo '<script type="text/javascript">setTimeout(function () {';
			echo 'swal("'.__('Hata', 'geo').'","'.__('Recaptcha doğrulamasını yapılması gerekiyor.', 'geo').'","success", {button: "'.__('Tekar Dene', 'geo').'",});';
		echo '}, 100);</script>';
} else {
	

	if ( ! empty( $_FILES['featured']['name'] )) {
		$filename = $_FILES['featured']['name'];
		$ext = pathinfo($filename, PATHINFO_EXTENSION);
		$allowed = array('jpg', 'png', 'jpeg');
		if( in_array( $ext, $allowed ) ){
			foreach( $_FILES as $file ) {
				if( is_array( $file ) ) {
					$attach_id = upload_user_file( $file );
				}
			}
		}
	}
	$status = ot_get_option('geo_postsubmit_status');

	if(isset($_POST['submit'])){
		
		$tags = $_POST['post_tags'];
		$postTitle = $_POST['post_title'];
		$editor = $_POST['editor'];
		
		
		global $user_ID;
		
		// get author id
		$author = $post->post_author;

		// get current meta value (and make sure its unique)
		$points = get_user_meta( $author, 'geo_user_points', true );

		// add to value
		$points += ot_get_option('geo_puan_yazi');

		// save the new value (again, make sure its unique) 
		update_user_meta( $author, 'geo_user_points', $points); 
		

		$post_info = array(
			'post_title' => wp_strip_all_tags( $postTitle ),
			'post_content' => $editor,
			'post_status' => $status,
			'tags_input'    => array($tags),
			'post_author' => $user_ID,
			'post_category'	=> (!empty($_POST['cat'])) ? array($_POST['cat']) : '',
			'post_type' => 'post',
		);
		$pid = wp_insert_post( $post_info );

		update_post_meta($pid,'_thumbnail_id',$attach_id);
		set_post_thumbnail( $pid, $attach_id );
		update_post_meta( $pid, 'geo_post_desc', $_POST['geo_post_desc']); 
		
		if ( is_wp_error( $pid ) ) {
			$hatavar =  $post_id->get_error_message();
		}
		
		else { ?>
			<script type="text/javascript">setTimeout('Redirect()',5000);
				function Redirect()
				{
					location.href = '<?php echo get_author_posts_url( get_the_author_meta( 'ID', $user_ID ) ); ?>';
				}
			</script>
			<?php echo '<script type="text/javascript">setTimeout(function () {';
				echo 'swal("'.__('Başarılı', 'geo').'","'.__('Gönderdiğiniz yazı bize ulaşmıştır, editörlerimiz tarafından incelendikten sonra yayınlanacaktır, anlayışınız için teşekkürler.', 'geo').'","success", {button: "'.__('Anasayfa Dön', 'geo').'",});';
			echo '}, 500);</script>';
		}
	}
}

geoit_header(); ?>
<style>
hr {
	display:block;
	    margin: 1em -2em;
		 width: auto
}
</style>
<main class="uck-layout__content" role="main">
	<div class="page__content">
		<div class="container">
			<div class="row">
				
				<?php if ( is_user_logged_in() ) : ?>
					<div id="content" class="content content__single content_post_add col-md-12">
						<h3><?php _e('Yazı Ekle', 'geo'); ?></h3>
						<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
							<?php $content = get_the_content(); if(!empty($content)): ?><br><div class="alert alert-secondary"><?php echo $content; ?></div><br><?php endif;?>
						<?php	endwhile; endif;?><br>

						<form action="<?php the_permalink(); ?>" method="post" enctype="multipart/form-data">
						
							<div class="form-group">
								<div class="form-label-group">
									<input autofocus required type="text" id="post_title" name="post_title" class="form-control" placeholder="<?php _e('Yazı Başlığı', 'geo'); ?>">
									<label for="post_title"><?php _e('Yazı Başlığı', 'geo'); ?></label>
								</div>
							</div>	
							<hr>

							<?php 
								$content = __('Hikayenizi bizimle paylaşmak istiyorsanız, buraya yazıp bizimle paylaşabilirsiniz.', 'geo');
								$editor_id = 'editor';
								$settings =   array(
										'wpautop' => true,
										'media_buttons' => true, 
										'textarea_name' => $editor_id, 
										'textarea_rows' => get_option('default_post_edit_rows', 10),
										'tabindex' => '', 
										'editor_css' => '', 
										'editor_class' => '', 
										'teeny' => false, 
										'dfw' => false,
										'tinymce' => true, 
										'quicktags' => true
								);
								wp_editor( $content, $editor_id, $settings );
								?>
							<hr>
							
							<div class="form-group">
								<div class="form-label-group">
									<textarea type="text" id="geo_post_desc" name="geo_post_desc" class="form-control" placeholder="<?php _e('Yazının Kısa Açıklaması', 'geo'); ?>"></textarea>
									<label for="geo_post_desc"><?php _e('Yazının Kısa Açıklaması', 'geo'); ?></label>
								</div>
							</div>
							<hr>
							<div class="form-group">
								<?php wp_dropdown_categories( 'show_option_none='.__('Kategori Seç', 'geo').'&tab_index=4&taxonomy=category' ); ?>
							</div>
							<hr>
							<div class="form-group">
								<div class="form-label-group">
									<input type="text" id="post_tags" name="post_tags" class="form-control" placeholder="<?php _e('Etiketler', 'geo'); ?>">
									<label for="post_tags"><?php _e('Etiketler', 'geo'); ?></label>
								</div>
							</div>
							<hr>
							<div class="form-group">
								<input type="file" name="featured" id="featured" accept="image/*" class="input-file">
								<label for="featured" class="js-labelFile">
									<span class="js-fileName"><?php _e('Görsel Ekle', 'geo'); ?></span>
									<span class="upload-path"></span>
								</label>
							</div>
							
							<hr>
						
							<?php echo geoit_recaptcha('login_form'); ?>
			
							<input class="geo-post-submit" name="submit" type="submit" value="<?php _e('Yazıyı Gönder', 'geo'); ?>" />
						</form>
					</div>
				<?php else: ?>
					<div class="geo_post-submit-full">
					<h2><?php _e('Giriş Yapmanız Gerekiyor!', 'geo'); ?></h2>
					</div>
				<?php endif; ?>
			
			</div>
		</div>
	</div>
</main>

<!--[if IE]>
<script src="http://html5shiv.googlecode.com/svn/trunk/html5.js"></script>
<![endif]-->
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<?php if ( ! is_user_logged_in() ) : ?>
<script>
function updateURLParameter(url, param, paramVal){
    var newAdditionalURL = "";
    var tempArray = url.split("?");
    var baseURL = tempArray[0];
    var additionalURL = tempArray[1];
    var temp = "";
    if (additionalURL) {
        tempArray = additionalURL.split("&");
        for (var i=0; i<tempArray.length; i++){
            if(tempArray[i].split('=')[0] != param){
                newAdditionalURL += temp + tempArray[i];
                temp = "&";
            }
        }
    }

    var rows_txt = temp + "" + param + "=" + paramVal;
    return baseURL + "?" + newAdditionalURL + rows_txt;
}

var newURL = updateURLParameter(window.location.href, 'locId', 'newLoc');
newURL = updateURLParameter(newURL, 'resId', 'newResId');

window.history.replaceState('', '', updateURLParameter(window.location.href, "login", "true"));
</script>
<?php endif; ?>
<?php get_footer();?>
<script>
// Span
var span = document.getElementsByClassName('upload-path');
// Button
var uploader = document.getElementsByName('featured');
// On change
for( item in uploader ) {
  // Detect changes
  uploader[item].onchange = function() {
    // Echo filename in span
    span[0].innerHTML = this.files[0].name;
  }
}

</script>