<?php
/**
 * Template Name: Kayıt Ol
 * @author: Kan Themes
 */
__('Kayıt Ol', 'geo');
geoit_header(); the_post();
?>
<main class="uck-layout__content" role="main">
	<div class="page__content">
		<div class="container">
		<div class="row">
		<div class="col-md-12">
		<div class="geoit_register_page register-frontend">
	<?php
	if ( ! is_user_logged_in() ) :
	if ( get_option( 'users_can_register' ) ) :
	$err = '';
	$success = '';

	global $wpdb, $PasswordHash, $current_user, $user_ID;

	if(isset($_POST['task']) && $_POST['task'] == 'register' ) {


		$pwd1 = esc_sql(trim($_POST['pwd1']));
		$pwd2 = esc_sql(trim($_POST['pwd2']));
		$first_name = esc_sql(trim($_POST['first_name']));
		$last_name = esc_sql(trim($_POST['last_name']));
		$email = esc_sql(trim($_POST['email']));
		$username = esc_sql(trim($_POST['username']));
		
		if (isset($_POST['g-recaptcha-response']) && $_POST['g-recaptcha-response'] == 0) {
			$err = __('Recaptcha doğrulaması yapılması gerekiyor.', 'geo');
		} else {
			if( $email == "" || $pwd1 == "" || $pwd2 == "" || $username == "" || $first_name == "" || $last_name == "") {
				$err = __('Lütfen gerekli alanları doldurun.', 'geo');
			} else if(!filter_var($email, FILTER_VALIDATE_EMAIL)) {
				$err = __('Geçersiz e-posta adresi girdiniz.', 'geo');
			} else if(email_exists($email) ) {
				$err = __('Bu e-posta adresiyle zaten üye olunmuş. Parolanızı unuttuysanız aşağıdaki "Şifrenizi Sıfırlayın" linkine tıklayabilirsiniz.', 'geo');
			} else if($pwd1 <> $pwd2 ){
				$err = __('Parolanız eşleşmedi, tekrar deneyiniz.', 'geo');
			} else {

				$user_id = wp_insert_user( array ('first_name' => apply_filters('pre_user_first_name', $first_name), 'last_name' => apply_filters('pre_user_last_name', $last_name), 'user_pass' => apply_filters('pre_user_user_pass', $pwd1), 'user_login' => apply_filters('pre_user_user_login', $username), 'user_email' => apply_filters('pre_user_user_email', $email), 'role' => 'subscriber' ) );
				if( is_wp_error($user_id) ) {
					$err = __('Kullanıcı oluşturulamadı tekrar deneyiniz.', 'geo');
				} else {
					do_action('user_register', $user_id);
					$success = __('Kayıt işleminiz başarıyla tamamlandı, giriş yapabilirsiniz.', 'geo');
				}

			}
		}

	}
	?>
	
	<div id="message">
		<?php
			if(! empty($err) ) :
				echo '<p class="error">'.$err.'';
			endif;
		?>

		<?php
			if(! empty($success) ) :
				echo '<p class="error error-succ">'.$success.'';
			endif;
		?>
	</div>

	<form method="post">
		
		<div class="register-header"><h3><?php _e('Kayıt Formu', 'geo'); ?></h3>
		<?php the_content(); ?>
		<p style="width:100%;float:none;"><?php _e('Zaten üyemizseniz <a data-toggle="geoit-login" href="#">giriş yapın</a>', 'geo');?> <?php _e('veya', 'geo'); ?>
		<?php $forgot_url = ot_get_option('geo-forgot');
		if ($forgot_url != '') {
			echo '<a href="'.get_page_link($forgot_url).'">'.__("şifrenizi sıfırlayın", "geo").'</a>';
		}
		else {
			echo '<a href="'.get_site_url(null, '/wp-login.php?action=lostpassword').'">'.__("şifrenizi sıfırlayın", "geo").'</a>';
		} ?>.
		</p></div><div class="clearfix"></div>
		
		<div class="form-group">
			<div class="form-label-group">
				<input type="text" id="first_name" name="first_name" class="form-control" placeholder="<?php _e('Adınız', 'geo'); ?>" required>
				<label for="first_name"><?php _e('Adınız', 'geo'); ?> *</label>
			</div>
		</div>
		
		<div class="form-group">
			<div class="form-label-group">
				<input type="text" id="last_name" name="last_name" class="form-control" placeholder="<?php _e('Soyadınız', 'geo'); ?>" required>
				<label for="last_name"><?php _e('Soyadınız', 'geo'); ?> *</label>
			</div>
		</div>
		
		<div class="form-group">
			<div class="form-label-group">
				<input type="email" id="email" name="email" class="form-control" placeholder="<?php _e('E-Posta Adresiniz', 'geo'); ?>" required>
				<label for="email"><?php _e('E-Posta Adresiniz', 'geo'); ?> *</label>
			</div>
		</div>
		
		<div class="form-group">
			<div class="form-label-group">
				<input type="text" id="username" name="username" class="form-control" placeholder="<?php _e('E-Posta Adresiniz', 'geo'); ?>" required>
				<label for="username"><?php _e('Kullanıcı Adı *', 'geo'); ?></label>
			</div>
		</div>
		
		<div class="form-group">
			<div class="form-label-group">
				<input type="password" id="pwd1" name="pwd1" class="form-control" placeholder="<?php _e('Şifreniz', 'geo'); ?>" required>
				<label for="pwd1"><?php _e('Şifreniz', 'geo'); ?> *</label>
			</div>
		</div>
		
		<div class="form-group">
			<div class="form-label-group">
				<input type="password" id="pwd2" name="pwd2" class="form-control" placeholder="<?php _e('Şifreniz Tekrar', 'geo'); ?>" required>
				<label for="pwd2"><?php _e('Şifreniz Tekrar', 'geo'); ?> *</label>
			</div>
		</div>
		
		<?php echo geoit_recaptcha('registration_form'); ?>

		<input type="submit" name="btnregister" class="button geo-post-submit" value="<?php _e('Kullanıcı Hesabımı Oluştur', 'geo'); ?>" />
		<input type="hidden" name="task" value="register" />
	</form>
	<?php else: ?>
		<?php _e('Kullanıcı kaydına şu an izin verilmiyor.', 'geo'); ?>
	<?php endif; ?>
	<?php else: ?>
	<?php _e('Başarıyla giriş yaptınız, ana sayfa\'ya yönlendiriliyorsunuz.', 'geo'); ?>
	<script type="text/javascript"><?php $url = site_url(); ?> location.href = '<?php echo $url; ?>';</script>
	<?php endif; ?>
</div>
</div>
</div>
</div>
</div>
</main>
<?php get_footer() ?>