<?php 

function saye_customize_register( $wp_customize ) {

	$prefix = 'geoit_';

	if ( isset( $wp_customize->selective_refresh ) ) {

		// Renk Ayarları
		$wp_customize->add_panel( $prefix.'customizer', array(
			'priority'       => 10,
			'capability'     => 'edit_theme_options',
			'title'          => __('Geoit Özelleştirmeleri', 'geo-admin'),
		) );
		
		###
		###### Genel Ayarlar
		###
		$wp_customize->add_section( 'logo', array(
			'priority'       => 20,
			'capability'     => 'edit_theme_options',
			'theme_supports' => '',
			'title'          => __('Logo', 'geo-admin'),
			'panel'  				 => $prefix.'customizer',
		) );
		
		###
		###### Genel Ayarlar
		###
		$wp_customize->add_section( 'general', array(
			'priority'       => 20,
			'capability'     => 'edit_theme_options',
			'theme_supports' => '',
			'title'          => __('Genel', 'geo-admin'),
			'panel'  				 => $prefix.'customizer',
		) );

		// Genel Ayarlar - Arkaplan Rengi
		$wp_customize->add_setting( $prefix.'bg_color', array() );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $prefix.'bg_color', array(
			'label' => __('Arkaplan Rengi', 'geo-admin'),
			'section' => 'general',
			'sanitize_callback' => 'sanitize_hex_color',
			'settings' => $prefix.'bg_color',
		) ) );

		// Genel Ayarlar - Birincil Renk
		$wp_customize->add_setting( $prefix.'primary_color', array() );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $prefix.'primary_color', array(
			'label' => __('Birincil Renk', 'geo-admin'),
			'section' => 'general',
			'sanitize_callback' => 'sanitize_hex_color',
			'settings' => $prefix.'primary_color',
		) ) );

		// Genel Ayarlar - Birincil Renk
		$wp_customize->add_setting( $prefix.'mobil_menu_primary_color', array() );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $prefix.'mobil_menu_primary_color', array(
			'label' => __('Mobil Menü Birincil Arkaplan Rengi', 'geo-admin'),
			'section' => 'general',
			'sanitize_callback' => 'sanitize_hex_color',
			'settings' => $prefix.'mobil_menu_primary_color',
		) ) );
		// Genel Ayarlar - İkincil Renk
		$wp_customize->add_setting( $prefix.'mobil_menu_secondary_color', array() );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $prefix.'mobil_menu_secondary_color', array(
			'label' => __('Mobil Menü İkincil Arkaplan Rengi', 'geo-admin'),
			'section' => 'general',
			'sanitize_callback' => 'sanitize_hex_color',
			'settings' => $prefix.'mobil_menu_secondary_color',
		) ) );
		
		

		// Genel Ayarlar - Logo
		$wp_customize->add_setting( $prefix.'logo', array());
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, $prefix.'logo', array(
			'label' => __('Logo', 'geo-admin'),
			'priority' => 20,
			'section' => 'logo',
			'settings' => $prefix.'logo',
			'sanitize_callback' => 'esc_url_raw',
			'button_labels' => array('select' => __('Logo Yükle', 'geo-admin'),'remove' => __('Logoyu Kaldır', 'geo-admin'),'change' => __('Logoyu Değiştir', 'geo-admin'))
		)));
		
		
		// Genel Ayarlar - AMP Logo
		$wp_customize->add_setting( $prefix.'logo_amp', array());
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, $prefix.'logo_amp', array(
			'label' => __('Logo (AMP)', 'geo-admin'),
			'priority' => 20,
			'section' => 'logo',
			'settings' => $prefix.'logo_amp',
			'sanitize_callback' => 'esc_url_raw',
			'button_labels' => array('select' => __('Logo Yükle', 'geo-admin'),'remove' => __('Logoyu Kaldır', 'geo-admin'),'change' => __('Logoyu Değiştir', 'geo-admin'))
		)));
		
		// Genel Ayarlar - Koyu Mod Logo
		$wp_customize->add_setting( $prefix.'logo_dark', array());
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, $prefix.'logo_dark', array(
			'label' => __('Logo (Koyu Mod)', 'geo-admin'),
			'priority' => 20,
			'section' => 'logo',
			'settings' => $prefix.'logo_dark',
			'sanitize_callback' => 'esc_url_raw',
			'button_labels' => array('select' => __('Logo Yükle', 'geo-admin'),'remove' => __('Logoyu Kaldır', 'geo-admin'),'change' => __('Logoyu Değiştir', 'geo-admin'))
		)));
		
		// Genel Ayarlar - Logo Genişliği
		$wp_customize->add_setting($prefix.'logo_width', array('sanitize_callback' => 'sanitize_float'));
		$wp_customize->add_control(
			$prefix.'logo_width',
			array(
				'label' => __('Genişlik (px)', 'geo-admin'),
				'section' => 'logo',
				'priority' => 20,
				'input_attrs' => array(
					'min' => '0', 'step' => '1', 'max' => '720',
				),
				'type' => 'number',
			)
		);
		// Genel Ayarlar - Logo Yüksekliği
		$wp_customize->add_setting($prefix.'logo_height', array('sanitize_callback' => 'sanitize_float'));
		$wp_customize->add_control(
			$prefix.'logo_height',
			array(
				'label' => __('Yükselik (px)', 'geo-admin'),
				'section' => 'logo',
				'type' => 'number',
				'input_attrs' => array(
					'min' => '0', 'step' => '1', 'max' => '300',
				),
				'priority' => 20,
			)
		);
		
		// Genel Ayarlar - Logo Title Tag
		$wp_customize->add_setting( $prefix.'logo_title', array());
    $wp_customize->add_control( $prefix.'logo_title', array(
			'label' => __( 'Logo Başlığı (HTML Title Tag)', 'geo-admin' ),
			'priority' => 20,
			'section' => 'logo'
    ) );
		
		// Genel Ayarlar - Logo Yazı
		$wp_customize->add_setting( $prefix.'logo_text', array());
    $wp_customize->add_control( $prefix.'logo_text', array(
			'label' => __( 'Yazı ile Logo', 'geo-admin' ),
			'priority' => 20,
			'section' => 'logo'
    ) );
		
		// Genel Ayarlar - Site Fontu
		$wp_customize->add_setting($prefix.'theme_font', array('sanitize_callback' => 'geoit_sanitize_select'));
    $wp_customize->add_control( 
			$prefix.'theme_font', 
			array(
				'label' => esc_html__( 'Site Fontu', 'geoit' ),
				'section' => 'general',
				'type' => 'select',
				'choices' => array(
					'' => esc_html__('Varsayılan','geoit'),
					'roboto' => 'Roboto',
					'roboto_condensed' => 'Roboto Condensed',
					'roboto_mono' => 'Roboto Mono',
					'roboto_slab' => 'Roboto Slab',
					'pt_sans' => 'PT Sans',
					'pt_serif' => 'PT Serif',
					'noto_sans' => 'Noto Sans',
					'noto_serif' => 'Noto Serif',
					'open_sans' => 'Open Sans',
					'open_sans_condensed' => 'Open Sans Condensed',
					'rubik' => 'Rubik',
					'montserrat' => 'Montserrat',
					'fira_sans' => 'Fira Sans',
					'work_sans' => 'Work Sans',
					'cabin' => 'Cabin',
					'cabin_condensed' => 'Cabin Condensed',
					'lexend_deca' => 'Lexend Deca',
					'karla' => 'Karla',
					'alata' => 'Alata',
					'alatsi' => 'Alatsi',
					'josefin_sans' => 'Josefin Sans',
					'hind' => 'Hind',
					'tomorrow' => 'Tomorrow',
					'source_sans_pro' => 'Source Sans Pro',
					'play' => 'Play',
					'oswald' => 'Oswald',
					'raleway' => 'Raleway',
					'niramit' => 'Niramit',
					'ubuntu' => 'Ubuntu',
					'k2d' => 'K2D',
					'exo_2' => 'Exo 2',
					'scada' => 'Scada',
					'lora' => 'Lora',
					'muli' => 'Muli',
					'quicksand' => 'Quicksand',
					'work_sans' => 'Work Sans',
					'titillium_web' => 'Titillium Web',
					'monda' => 'Monda',
					'oxygen' => 'Oxygen',
					'barlow' => 'Barlow',
					'reem_kufi' => 'Reem Kufi',
					'merriweather_sans' => 'Merriweather Sans',
					'russo_one' => 'Russo One',
					'righteous' => 'Righteous',
					'benchnine' => 'BenchNine',
					'playfair_display' => 'Playfair Display',
					'vidaloka' => 'Vidaloka',
					'prata' => 'Prata',
					'didact_gothic' => 'Didact Gothic',
					'calistoga' => 'Calistoga',
					'monoton' => 'Monoton',
					'bebas_neue' => 'Bebas Neue',
					'staatliches' => 'Staatliches',
					'jost' => 'Jost',
					'dm_sans' => 'Dm Sans',
					'inter' => 'Inter',
					'syne' => 'Syne',
					'sora' => 'Sora',
					'oxanium' => 'Oxanium',
					'spartan' => 'Spartan',
					'gelasio' => 'Gelasio',
					'alatsi' => 'Alatsi',
					'mulish' => 'Mulish',
				)
			)
    );  
		
		###
		###### Header Ayarları
		###
		if (ot_get_option('head-layout-select') != 'head-layout-2') {
			$wp_customize->add_section( 'header', array(
				'priority'       => 20,
				'capability'     => 'edit_theme_options',
				'theme_supports' => '',
				'title'          => __('Header', 'geo-admin'),
				'panel'  				 => $prefix.'customizer',
			) );

			
			if (ot_get_option('header-top-status') != 'off') {
				// Header Ayarları - Header Üst
				$wp_customize->add_setting( $prefix.'header_top_color', array() );
				$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $prefix.'header_top_bg', array(
					'label' => __('Üst Arkaplan', 'geo-admin'),
					'section' => 'header',
					'sanitize_callback' => 'sanitize_hex_color',
					'settings' => $prefix.'header_top_color',
				) ) );		
				
				// Header Ayarları - Header Üst Border
				$wp_customize->add_setting( $prefix.'header_top_border_color', array() );
				$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $prefix.'header_top_border_color', array(
					'label' => __('Üst Border Rengi', 'geo-admin'),
					'section' => 'header',
					'sanitize_callback' => 'sanitize_hex_color',
					'settings' => $prefix.'header_top_border_color',
				) ) );		
				
				// Header Ayarları - Header Üst Renk
				$wp_customize->add_setting( $prefix.'header_top_item_color', array() );
				$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $prefix.'header_top_item_color', array(
					'label' => __('Üst Yazı Rengi', 'geo-admin'),
					'section' => 'header',
					'sanitize_callback' => 'sanitize_hex_color',
					'settings' => $prefix.'header_top_item_color',
				) ) );
			}
			
			// Header Ayarları - Header Orta
			if (ot_get_option('head-layout-select') == 'head-layout-0') {
				$wp_customize->add_setting( $prefix.'header_middle_color', array() );
				$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $prefix.'header_middle_color', array(
					'label' => __('Orta Arkaplan', 'geo-admin'),
					'section' => 'header',
					'sanitize_callback' => 'sanitize_hex_color',
					'settings' => $prefix.'header_middle_color',
				) ) );
				$wp_customize->add_setting( $prefix.'header_middle_text_color', array() );
				$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $prefix.'header_middle_text_color', array(
					'label' => __('Orta Yazı Rengi', 'geo-admin'),
					'section' => 'header',
					'sanitize_callback' => 'sanitize_hex_color',
					'settings' => $prefix.'header_middle_text_color',
				) ) );
			}
		}
		
		###
		###### Navbar Ayarları
		###
		$wp_customize->add_section( 'navbar', array(
			'priority'       => 20,
			'capability'     => 'edit_theme_options',
			'theme_supports' => '',
			'title'          => __('Navbar', 'geo-admin'),
			'panel'  				 => $prefix.'customizer',
		) );
		
		// Navbar Ayarları - Navbar Bg
		$wp_customize->add_setting( $prefix.'navbar_bg_color', array() );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $prefix.'navbar_bg_color', array(
			'label' => __('Arkaplan', 'geo-admin'),
			'section' => 'navbar',
			'sanitize_callback' => 'sanitize_hex_color',
			'settings' => $prefix.'navbar_bg_color',
		) ) );
		
		// Navbar Ayarları - Navbar Color
		$wp_customize->add_setting( $prefix.'navbar_color', array() );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $prefix.'navbar_color', array(
			'label' => __('Link Rengi', 'geo-admin'),
			'section' => 'navbar',
			'sanitize_callback' => 'sanitize_hex_color',
			'settings' => $prefix.'navbar_color',
		) ) );		
		
		// Navbar Ayarları - Navbar Color:Current
		$wp_customize->add_setting( $prefix.'navbar_current_color', array() );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $prefix.'navbar_current_color', array(
			'label' => __('Link Rengi (Bulunduğun Sayfa)', 'geo-admin'),
			'section' => 'navbar',
			'sanitize_callback' => 'sanitize_hex_color',
			'settings' => $prefix.'navbar_current_color',
		) ) );		
		// Navbar Ayarları - Navbar Color:Current
		$wp_customize->add_setting( $prefix.'navbar_hover_color', array() );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $prefix.'navbar_hover_color', array(
			'label' => __('Link Rengi (Hover)', 'geo-admin'),
			'section' => 'navbar',
			'sanitize_callback' => 'sanitize_hex_color',
			'settings' => $prefix.'navbar_hover_color',
		) ) );
		
		// Navbar Ayarları - Navbar Border Color
		$wp_customize->add_setting( $prefix.'navbar_border_color', array() );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $prefix.'navbar_border_color', array(
			'label' => __('Border Rengi', 'geo-admin'),
			'section' => 'navbar',
			'sanitize_callback' => 'sanitize_hex_color',
			'settings' => $prefix.'navbar_border_color',
		) ) );
		
		// Navbar Ayarları - Navbar Sub Menu Bg
		$wp_customize->add_setting( $prefix.'navbar_submenu_bg_color', array() );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $prefix.'navbar_submenu_bg_color', array(
			'label' => __('Sub Menu Arkaplan', 'geo-admin'),
			'section' => 'navbar',
			'sanitize_callback' => 'sanitize_hex_color',
			'settings' => $prefix.'navbar_submenu_bg_color',
		) ) );
		
		// Navbar Ayarları - Navbar Sub Menu Link Color
		$wp_customize->add_setting( $prefix.'navbar_submenu_link_color', array() );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $prefix.'navbar_submenu_link_color', array(
			'label' => __('Sub Menu Link Rengi', 'geo-admin'),
			'section' => 'navbar',
			'sanitize_callback' => 'sanitize_hex_color',
			'settings' => $prefix.'navbar_submenu_link_color',
		) ) );
		
		// Navbar Ayarları - Font Size
		$wp_customize->add_setting($prefix.'navbar_font_size', array('sanitize_callback' => 'sanitize_float'));
		$wp_customize->add_control(
				$prefix.'navbar_font_size',
				array(
					'label' => __('Font Size (px)', 'geo-admin'),
					'section' => 'navbar',
					'type' => 'number',
					'input_attrs' => array(
						'min' => '12', 'step' => '1', 'max' => '22',
					),
				)
		);
		
		// Navbar Ayarları - Sub Menu Font Size
		$wp_customize->add_setting($prefix.'navbar_submenu_font_size', array('sanitize_callback' => 'sanitize_float'));
		$wp_customize->add_control(
				$prefix.'navbar_submenu_font_size',
				array(
					'label' => __('Sub Menu Font Size (px)', 'geo-admin'),
					'section' => 'navbar',
					'type' => 'number',
					'input_attrs' => array(
						'min' => '10', 'step' => '1', 'max' => '16',
					),
				)
		);
		
		###
		###### Öne Çıkarılan Yazılar
		###
		$wp_customize->add_section( 'featured_posts', array(
			'priority'       => 20,
			'capability'     => 'edit_theme_options',
			'theme_supports' => '',
			'title'          => __('Öne Çıkan Yazılar', 'geo-admin'),
			'panel'  				 => $prefix.'customizer',
		) );
		
		// Öne Çıkarılan Yazılar - Büyük Yazı Font Size
		$wp_customize->add_setting($prefix.'featured_posts_big_font_size', array('sanitize_callback' => 'sanitize_float'));
		$wp_customize->add_control(
				$prefix.'featured_posts_big_font_size',
				array(
					'label' => __('Büyük Yazı Font Size (px)', 'geo-admin'),
					'section' => 'featured_posts',
					'type' => 'number',
					'input_attrs' => array(
						'min' => '12', 'step' => '1', 'max' => '40',
					),
				)
		);
		
		// Öne Çıkarılan Yazılar - Font Size
		$wp_customize->add_setting($prefix.'featured_posts_font_size', array('sanitize_callback' => 'sanitize_float'));
		$wp_customize->add_control(
				$prefix.'featured_posts_font_size',
				array(
					'label' => __('Font Size (px)', 'geo-admin'),
					'section' => 'featured_posts',
					'type' => 'number',
					'input_attrs' => array(
						'min' => '12', 'step' => '1', 'max' => '32',
					),
				)
		);
		
		###
		###### Yazı Listeleme
		###
		$wp_customize->add_section( 'posts_list', array(
			'priority'       => 20,
			'capability'     => 'edit_theme_options',
			'theme_supports' => '',
			'title'          => __('Yazı Listeleme Bileşenleri', 'geo-admin'),
			'panel'  				 => $prefix.'customizer',
		) );
		
		// Yazı Listeleme - Yazı Başlık Font Size
		$wp_customize->add_setting($prefix.'posts_list_headline_fsize', array('sanitize_callback' => 'sanitize_float'));
		$wp_customize->add_control(
				$prefix.'posts_list_headline_fsize',
				array(
					'label' => __('Yazı Başlığı Font Size (px)', 'geo-admin'),
					'section' => 'posts_list',
					'type' => 'number',
					'input_attrs' => array(
						'min' => '12', 'step' => '1', 'max' => '40',
					),
				)
		);
		
		// Yazı Listeleme - Yazı Başlık Rengi
		$wp_customize->add_setting( $prefix.'posts_list_headline_color', array() );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $prefix.'posts_list_headline_color', array(
			'label' => __('Yazı Başlığı Rengi', 'geo-admin'),
			'section' => 'posts_list',
			'sanitize_callback' => 'sanitize_hex_color',
			'settings' => $prefix.'posts_list_headline_color',
		) ) );
		
		// Yazı Listeleme - Yazı Font Size (Sidebar)
		$wp_customize->add_setting($prefix.'posts_list_headline_fsize_sidebar', array('sanitize_callback' => 'sanitize_float'));
		$wp_customize->add_control(
				$prefix.'posts_list_headline_fsize_sidebar',
				array(
					'label' => __('Yazı Başlığı Font Size (px)', 'geo-admin').' #Sidebar',
					'section' => 'posts_list',
					'type' => 'number',
					'input_attrs' => array(
						'min' => '12', 'step' => '1', 'max' => '20',
					),
				)
		);
		
		
		###
		###### Yazı Sayfası
		###
		$wp_customize->add_section( 'single_page', array(
			'priority'       => 20,
			'capability'     => 'edit_theme_options',
			'theme_supports' => '',
			'title'          => __('Yazı Sayfası', 'geo-admin'),
			'panel'  				 => $prefix.'customizer',
		) );
		
		// Yazı Sayfası - Yazı Başlık Font Size
		$wp_customize->add_setting($prefix.'single_page_headline_fsize', array('sanitize_callback' => 'sanitize_float'));
		$wp_customize->add_control(
				$prefix.'single_page_headline_fsize',
				array(
					'label' => __('Yazı Başlığı Font Size (px)', 'geo-admin'),
					'section' => 'single_page',
					'type' => 'number',
					'input_attrs' => array(
						'min' => '12', 'step' => '1', 'max' => '40',
					),
				)
		);
		
		// Yazı Listeleme - Yazı Başlık Rengi
		$wp_customize->add_setting( $prefix.'single_page_headline_color', array() );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $prefix.'single_page_headline_color', array(
			'label' => __('Yazı Başlığı Rengi', 'geo-admin'),
			'section' => 'single_page',
			'sanitize_callback' => 'sanitize_hex_color',
			'settings' => $prefix.'single_page_headline_color',
		) ) );
		
		// Yazı Sayfası - Yazı İçerik Font Size
		$wp_customize->add_setting($prefix.'single_page_content_fsize', array('sanitize_callback' => 'sanitize_float'));
		$wp_customize->add_control(
				$prefix.'single_page_content_fsize',
				array(
					'label' => __('Yazı İçeriği Font Size (px)', 'geo-admin'),
					'section' => 'single_page',
					'type' => 'number',
					'input_attrs' => array(
						'min' => '12', 'step' => '1', 'max' => '32',
					),
				)
		);	
		
		// Yazı Link Rengi
		$wp_customize->add_setting( $prefix.'single_page_link_color', array() );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $prefix.'single_page_link_color', array(
			'label' => __('Yazı Link Rengi', 'geo-admin'),
			'section' => 'single_page',
			'sanitize_callback' => 'sanitize_hex_color',
			'settings' => $prefix.'single_page_link_color',
		) ) );
		
		// Yazı Ziyaret Edilmiş Link Rengi
		$wp_customize->add_setting( $prefix.'single_page_link_color_visited', array() );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $prefix.'single_page_link_color_visited', array(
			'label' => __('Yazı Link Rengi (Ziyaret Edilmiş)', 'geo-admin'),
			'section' => 'single_page',
			'sanitize_callback' => 'sanitize_hex_color',
			'settings' => $prefix.'single_page_link_color_visited',
		) ) );

		
		// Yazı Hover Link Rengi
		$wp_customize->add_setting( $prefix.'single_page_link_color_hover', array() );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $prefix.'single_page_link_color_hover', array(
			'label' => __('Yazı Link Rengi(Üzerine Gelince)', 'geo-admin'),
			'section' => 'single_page',
			'sanitize_callback' => 'sanitize_hex_color',
			'settings' => $prefix.'single_page_link_color_hover',
		) ) );

	}
	
	
}
add_action( 'customize_register', 'saye_customize_register' );


function sanitize_float( $input ) {
   return filter_var($input, FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
}

function geoit_sanitize_select( $input, $setting ){
	
		//input must be a slug: lowercase alphanumeric characters, dashes and underscores are allowed only
		$input = sanitize_key($input);

		//get the list of possible select options 
		$choices = $setting->manager->get_control( $setting->id )->choices;
											
		//return input if valid or return default option
		return ( array_key_exists( $input, $choices ) ? $input : $setting->default );                
			
	}