<?php
/* Dynamic Styles
/* ------------------------------------ */
add_action('wp_head', 'theme_color_geoit');
if ( ! function_exists( 'theme_color_geoit' ) ) {
	function theme_color_geoit() {
		$color = (!empty(get_theme_mod('geoit_primary_color'))) ? get_theme_mod('geoit_primary_color') : '#e62f2f';
		if ( $color != '#e62f2f' ) {
			echo '<meta name="theme-color" content="'.$color.'" />';
		} else {
			echo '<meta name="theme-color" content="#e62f2f" />';
		}
	}
}


add_action('wp_footer', 'dynamic_scripts');
if ( ! function_exists( 'dynamic_scripts' ) ) {
	function dynamic_scripts() {
		$font = get_theme_mod('geoit_theme_font');
		$first_big = ucwords(strtolower($font));
		$first_word2 = ucwords(strtolower($first_big), '_');
		$bul = '_';
		$degistir = '+';
		$font_final = str_replace($bul, $degistir, $first_word2);
		if ($font_final == '') {
			$font_final = 'Poppins';
		}?>
		<script>
		var connection = navigator.connection || navigator.mozConnection || navigator.webkitConnection;
		if ( typeof connection != 'undefined' && (/\slow-2g|2g/.test(connection.effectiveType))) {
			console.warn( 'Slow Connection Google Fonts Disabled' );
		}
		else {
			WebFontConfig ={
				google:{
					families: ['<?php echo $font_final; ?>:regular,500,600,700:latin&display=swap']
				}
				// custom: {
					// families: ['geoit-font'],
					// urls: ['<?php echo get_template_directory_uri(); ?>/assets/css/geoit-font.css']
				// }
			};

			(function(){
				var wf   = document.createElement('script');
				wf.src   = '//ajax.googleapis.com/ajax/libs/webfont/1/webfont.js';
				wf.type  = 'text/javascript';
				wf.defer = 'true';
				var s = document.getElementsByTagName('script')[0];
				s.parentNode.insertBefore(wf, s);
			})();
	
		}

		</script>
		<?php
	}
}


if ( ! function_exists( 'dynamic_styles' ) ) {

	function dynamic_styles() {	
		
			// begin
			$styles = '<style>'."\n";
			
			// Container
			if (ot_get_option('geoit-site-container') == 'container-fluid' )
			$styles .= '.container {width: 100% !important}';
		
			// Cat Color
				$terms = get_terms( 'category' );
				foreach ( $terms as $term ) {
					$control_term = get_term_meta( $term->term_id, '_category_color', true );
					if ($control_term != '') {
						$control_term_id = $term->term_id;
						$styles .= '
						.geo_first_category.geoit-cat-item-'.$control_term_id.', .category-'.$control_term_id.' .uck-card:hover .uck-card--right a, .category-'.$control_term_id.':not(.dark-mode).content .uck-card-timeline-icon i {background-color: #'.$control_term.' !important}
						.geoit-cat-item-'.$control_term_id.' .geo_first_category_dropcap {background-color: #'.$control_term.' !important}
						.geo_first_category_style-2.geoit-cat-item-'.$control_term_id.' {border-color: #'.$control_term.' !important}
						.geo_first_category_style-2.geoit-cat-item-'.$control_term_id.' {color: #'.$control_term.' !important}
						.category-'.$control_term_id.':not(.dark-mode) .content .uckan-btn:after, .category-'.$control_term_id.':not(.dark-mode) .content .uckan-btn:before {background-color: #'.$control_term.' !important}
						.category-'.$control_term_id.':not(.dark-mode) .content .uck-card--right a {border-color: #'.$control_term.' !important}
						.category-'.$control_term_id.':not(.dark-mode) .content .uck-card:not(:hover) .uck-card--right a {color: #'.$control_term.' !important}
						';
					}
				}
			
			// Box Styles
			$box = empty(ot_get_option('site-box-style')) ? 'shadow' : ot_get_option('site-box-style');
			
			if ($box == 'bordered') {
				$styles .= '
					.widget, #tab-menu .tabs, .tab_menu_comments, .register-frontend, .blog-big-group, .box-sd, .post-list-group, .masonry, .content__post,
					.geo_homepage_1col .col-1,.page_description, #footer, .navigation.pagination, .geo_post-submit-left,.geo_post-submit-right,.geo_post-submit-full, .geo_users_list, .twPc-div, .geoit_author_box, .content_post_add,
					.content__title .uckan-btn, #load-more-posts-button-wrapper
					{
						border: 1px solid #ececec;
						box-shadow: none !important;
					}
					.content__title .uckan-btn {
						border:0
					}
					.content__recent-posts--group .content__title .uckan-btn  {
						border: 1px solid #ececec;
						border-bottom: 0px;
					}
					 .navigation.pagination, #load-more-posts-button-wrapper {
						 border-top: 0px
					 }
					 #tab-menu .tabs {
						 border-top: 0;
						 border-left:0;
						 border-right: 0
					 }
					 .widget .content__title .uckan-btn {
						 border-bottom-color: #ececec;
					 }
				';
		
			}
			elseif ($box == 'flat') {
				$styles .= '
					 .widget, #tab-menu .tabs, .tab_menu_comments, .register-frontend, .blog-big-group, .carousel__item, .carousel__image, .box-sd, .post-list-group, .masonry, .content__post,
					.geo_homepage_1col .col-1,.page_description, #footer, .navigation.pagination, .geo_post-submit-left,.geo_post-submit-right,.geo_post-submit-full, .geo_users_list, .twPc-div, .geoit_author_box, .content_post_add,
					.manset_slider .owl-dots {
						box-shadow: none;
					}
					.content__title .uckan-btn {
						box-shadow: none;
					}
				';
		
			}
			
			// Fonts
			$font = get_theme_mod('geoit_theme_font');
			$first_big = ucwords(strtolower($font));
			$first_word2 = ucwords(strtolower($first_big), '_');
			$bul = '_';
			$degistir = ' ';
			$font_final = str_replace($bul, $degistir, $first_word2);
	
			if ($font_final != '') {

				$styles .= '* {font-family: "'.$font_final.'", sans-serif !important;}
				code,kbd,pre,samp {
					font-family: Menlo, Monaco, Consolas, "Courier New", monospace !important
				}
				.dashicons {font-family: dashicons!important}
				.fa{font-family:geoit-font !important}'."\n";

			}
			
			// All Settings
			$customizer = [
				'bg' => (!empty(get_theme_mod('geoit_bg_color'))) ? get_theme_mod('geoit_bg_color') : '',
				'primary' => (!empty(get_theme_mod('geoit_primary_color'))) ? get_theme_mod('geoit_primary_color') : '',
				'header-top' => (!empty(get_theme_mod('geoit_header_top_color'))) ? get_theme_mod('geoit_header_top_color') : '',
				'header-top-border' => (!empty(get_theme_mod('geoit_header_top_border_color'))) ? get_theme_mod('geoit_header_top_border_color') : '',
				'header-top-color' => (!empty(get_theme_mod('geoit_header_top_item_color'))) ? get_theme_mod('geoit_header_top_item_color') : '',
				'header-middle' => (!empty(get_theme_mod('geoit_header_middle_color'))) ? get_theme_mod('geoit_header_middle_color') : '',
				'header-middle-color' => (!empty(get_theme_mod('geoit_header_middle_text_color'))) ? get_theme_mod('geoit_header_middle_text_color') : '',
				'navbar-bg' => (!empty(get_theme_mod('geoit_navbar_bg_color'))) ? get_theme_mod('geoit_navbar_bg_color') : '',
				'navbar-color' => (!empty(get_theme_mod('geoit_navbar_color'))) ? get_theme_mod('geoit_navbar_color') : '',
				'navbar-hover-color' => (!empty(get_theme_mod('geoit_navbar_hover_color'))) ? get_theme_mod('geoit_navbar_hover_color') : '',
				'navbar-current-color' => (!empty(get_theme_mod('geoit_navbar_current_color'))) ? get_theme_mod('geoit_navbar_current_color') : '',
				'navbar-border-color' => (!empty(get_theme_mod('geoit_navbar_border_color'))) ? get_theme_mod('geoit_navbar_border_color') : '',
				'navbar-sub-menu' => (!empty(get_theme_mod('geoit_navbar_submenu_bg_color'))) ? get_theme_mod('geoit_navbar_submenu_bg_color') : '',
				'navbar-sub-menu-color' => (!empty(get_theme_mod('geoit_navbar_submenu_link_color'))) ? get_theme_mod('geoit_navbar_submenu_link_color') : '',
				'navbar-font-size' => (!empty(get_theme_mod('geoit_navbar_font_size'))) ? get_theme_mod('geoit_navbar_font_size') : '',
				'navbar-sub-menu-font-size' => (!empty(get_theme_mod('geoit_navbar_submenu_font_size'))) ? get_theme_mod('geoit_navbar_submenu_font_size') : '',
				'featured-posts-big-font-size' => (!empty(get_theme_mod('geoit_featured_posts_big_font_size'))) ? get_theme_mod('geoit_featured_posts_big_font_size') : '',
				'featured-posts-font-size' => (!empty(get_theme_mod('geoit_featured_posts_font_size'))) ? get_theme_mod('geoit_featured_posts_font_size') : '',
				'posts-list-headline-font-size' => (!empty(get_theme_mod('geoit_posts_list_headline_fsize'))) ? get_theme_mod('geoit_posts_list_headline_fsize') : '',
				'posts-list-headline-font-size-sidebar' => (!empty(get_theme_mod('geoit_posts_list_headline_fsize_sidebar'))) ? get_theme_mod('geoit_posts_list_headline_fsize_sidebar') : '',
				'posts-list-headline-color' => (!empty(get_theme_mod('geoit_posts_list_headline_color'))) ? get_theme_mod('geoit_posts_list_headline_color') : '',
				'single-page-headline-font-size' => (!empty(get_theme_mod('geoit_single_page_headline_fsize'))) ? get_theme_mod('geoit_single_page_headline_fsize') : '',
				'single-page-headline-color' => (!empty(get_theme_mod('geoit_single_page_headline_color'))) ? get_theme_mod('geoit_single_page_headline_color') : '',
				'single-page-content-font-size' => (!empty(get_theme_mod('geoit_single_page_content_fsize'))) ? get_theme_mod('geoit_single_page_content_fsize') : '',
				'single-page-content-link-color' => (!empty(get_theme_mod('geoit_single_page_link_color'))) ? get_theme_mod('geoit_single_page_link_color') : '',
				'single-page-content-link-color-visited' => (!empty(get_theme_mod('geoit_single_page_link_color_visited'))) ? get_theme_mod('geoit_single_page_link_color_visited') : '',
				'single-page-content-link-color-hover' => (!empty(get_theme_mod('geoit_single_page_link_color_hover'))) ? get_theme_mod('geoit_single_page_link_color_hover') : '',
				'mobil-menu-primary' => (!empty(get_theme_mod('geoit_mobil_menu_primary_color'))) ? get_theme_mod('geoit_mobil_menu_primary_color') : '',
				'mobil-menu-secondary' => (!empty(get_theme_mod('geoit_mobil_menu_secondary_color'))) ? get_theme_mod('geoit_mobil_menu_secondary_color') : '',
			];
			
			##### Primary
			if (!empty($customizer['bg']) && $customizer['bg'] != '#f8f8f8') {
				$styles .= '
					body {background: '.$customizer['bg'].'}
				';
			}
			
			##### Mobil Menü
			if ((!empty($customizer['mobil-menu-primary']) && $customizer['bg'] != 'mobil-menu-primary') && !empty($customizer['mobil-menu-secondary']) && $customizer['bg'] != 'mobil-menu-secondary') {
				$styles .= '
					#geo_mobil_menu {background-image: linear-gradient(-20deg, '.$customizer['mobil-menu-primary'].' 0%, '.$customizer['mobil-menu-secondary'].' 100%);}
				';
			}
			
			##### Primary
			if (!empty($customizer['primary'])) {
				// Bg
				$styles .= '.recipe-title,.geo_first_category_dropcap,.header__bottom--menu .sub-menu .current-menu-item,.lazyload-enable .carousel__item,.uck-card-timeline-icon i,.geoit-nutritions-title,.geoit-ingredients-item:before,.geoit-recipe-instructions-counter,.geoit-popular-post-item .post-counter-label,.geoit-sc-headline .oajısdn2,.header__search--form input:focus + button,.uckan-btn.colored,.header__top,.widget_search input.search-submit,.header__hamburger--menu .circle,.mobil-menu-button, .carousel__image,.owl-carousel.w-slider .item  .w-slider_image, .geo-thumbnail,.uck__up-voted, .uck__up-vote.liked,.content__title .uckan-btn:before,.footer__title .headline:before,.uck-card--category:before,.comment.bypostauthor .comment-bottom--avatar:after,.comment.comment-author-admin .comment-bottom--avatar:after,#review-box .overall-score,#review-box ul li .review-criteria-bar,.comment-submit,.geo_dropcap.geo_dropcap-circle,.geo_dropcap.geo_dropcap-square,.geoit_login-wrapper input#wp-submit, .geoit_login-wrapper #wp-submit_widget, .geoit-mega-menu-block .widgettitle:after,.geo_first_category,.geo_login-widget input.button,.geo-post-submit,#geo_viral_reactions li.clicked em,#geoit__demos .dms, .header-two .header__bottom,  .content__gallery_nav .current, .content__post--meta li.geoprevv a,.mailchimp-subscribe__submit,.geo-review-badge,.search-submit,.wpcf7-submit,.stories.snapgram .story > .item-link > .item-preview, .login-close, .manset_slider .owl-dot.active,#geo_viral_reactions li[data-reacted="yes"] em, .block_title_style-3 .uckan-btn:after, .lazyload-active .carousel__item, .content__post--meta li.geoprevv+li a
					{ background-color: '.$customizer['primary'].'; }
					.uck-card:hover .uck-card--right a { background-color: '.$customizer['primary'].'; }
					#geo_viral_reactions .animated:hover em { background-color: '.$customizer['primary'].'; }
					.content__gallery_nav>:hover { background-color: '.$customizer['primary'].'; }
					input[type="checkbox"]:checked:after { background-color: '.$customizer['primary'].'; }
					.post-page-numbers.current
					{ background-color: '.$customizer['primary'].'; }
					.post-page-numbers:hover { background-color: '.$customizer['primary'].'; } 
					.owl-theme .owl-nav [class*=owl-]:hover { background-color: '.$customizer['primary'].'; }
					.load-more-posts-button:hover
					{ background-color: '.$customizer['primary'].' !important; }
					.read-bar,.read-text
					{ background-color: '.$customizer['primary'].' !important; }
					.content__post--article_tags a:hover
					{ background-color: '.$customizer['primary'].' !important; }
					.geoit_comment_footer>a:hover
					{ background-color: '.$customizer['primary'].' !important; }
					.uckan-card:hover .type
					{ background-color: '.$customizer['primary'].' !important; }
					.geo-notification-content li a:before
					{ background-color: '.$customizer['primary'].' !important; }
				';
				// Color
				$styles .= '
					.header__bottom--menu .current-menu-item,.geo_first_category_style-2, .geo-notification i, .header__bottom--menu .current-menu-parent, .content__post--article_meta a, .more-in-heading a,.author-page-info span,.uck-card--right a
					{ color: '.$customizer['primary'].'; }
					.geo_breadcrumb>li:first-child>a
					{ color: '.$customizer['primary'].'; }
					blockquote:after
					{ color: '.$customizer['primary'].'; }
					.geoit_login_232 a,.navigation.pagination .page-numbers.current
					{ color: '.$customizer['primary'].'; }
					.uck-accordion--title:before
					{ color: '.$customizer['primary'].'; }
					.form-label-group>*:not(label):not(:placeholder-shown) ~ label
					{ color: '.$customizer['primary'].'; }
					.form-label-group>:not(label):hover + label
					{ color: '.$customizer['primary'].'; }
					.form-label-group>:not(label):not(:placeholder-shown) + label
					{ color: '.$customizer['primary'].'; }
					.form__wrapper .form__input:focus + label:before
					{ color: '.$customizer['primary'].'; }
					.header__bottom--menu li:hover>.header__bottom--link
					{ color: '.$customizer['primary'].'; }
					.headline a:hover
					{ color: '.$customizer['primary'].'; }
					.gotop:hover
					{ color: '.$customizer['primary'].'; }
					.navigation.pagination .page-numbers:hover
					{ color: '.$customizer['primary'].'; }
					.menu-footer a:hover
					{ color: '.$customizer['primary'].'; }
					.geoit_recent_comments a:hover
					{ color: '.$customizer['primary'].'; }
					.geoit-sc-headline span.bordered:not(:hover)
					{ color: '.$customizer['primary'].'; }
					
				';
				// Border Color
				$styles .= '
					.geoit-recipe, .geoit-sc-headline span.bordered,.geoit-nutritions-table,.geo_first_category_style-2,.geo-post-source-title,.navigation.pagination .page-numbers.current,.header__search--form input:focus,.header__search--form,.geo_create_post .geo_posting-item input:focus,.geo_create_post select:focus,.input-file:focus + .js-labelFile, .register-frontend input:not(#wp-submit):focus,.register-frontend select:focus, .mailchimp-subscribe__email-input:focus, .geoit_login-wrapper input:focus,
					.content__recent-posts--group .post.sticky:before, .geo_create_post input:focus, .geo_login-widget input:focus, .input-file + .js-labelFile:focus, .geo_login-widget textarea:focus, .geo-review-badge:after, input[type="checkbox"]:checked:after, .content__gallery_nav .current, .wpcf7 input:focus, .wpcf7 select:focus, .wpcf7 textarea:focus, .uck-card--right a, .more-in-category.active, .form__wrapper .form__input:focus, .form-control:focus, .form-table input:focus, .login-close, blockquote, .mailchimp_subsribe, .header__search--form input:focus
					{ border-color: '.$customizer['primary'].'; }
					.load-more-posts-button:hover
					{ border-color: '.$customizer['primary'].'; }
					.content__gallery_nav>:hover
					{ border-color: '.$customizer['primary'].'; }
					.navigation.pagination .page-numbers:hover
					{ border-color: '.$customizer['primary'].'; }
					.content__post--article_tags a:hover
					{ border-color: '.$customizer['primary'].'; }
					.geoit_comment_footer>a:hover
					{ border-color: '.$customizer['primary'].'; }
					.uckan-card:hover .type
					{ border-color: '.$customizer['primary'].'; }
				';
				// Box Shadow
				$styles .= '
					.header__bottom--menu .current-menu-item, .header__bottom--menu .current-menu-parent { box-shadow: inset 0px -2px 0 0 '.$customizer['primary'].'; }
					.header__bottom--menu li:hover>.header__bottom--link { box-shadow: inset 0px -2px 0 0 '.$customizer['primary'].'; }
					ul.tabs li.active { box-shadow: inset 0px -2px 0 '.$customizer['primary'].'; }
					.form-control:focus, .form-table input:focus { box-shadow:  0 0 0 1px '.$customizer['primary'].'; }
				';
			}
			
			if (ot_get_option('head-layout-select') != 'head-layout-2') {
				#### Header Top
				if (!empty($customizer['header-top'])) {
					$styles .= '
						.header__top {background: '.$customizer['header-top'].'}
					';
				}						
				
				#### Header Top Border
				if (!empty($customizer['header-top-border'])) {
					$styles .= '
						.header__top {border-bottom: 1px solid '.$customizer['header-top-border'].'}
						.header__search,.header__trending, .header__top--social, .header__top--right {border-color: '.$customizer['header-top-border'].'}
					';
				}					
				
				#### Header Top Color
				if (!empty($customizer['header-top-color'])) {
					$styles .= '
						.ticker a, #header .header__top--right>div>button,.header__top--social li a, .ticker-title  {color: '.$customizer['header-top-color'].'}
						.ticker-title {background: transparent;padding: 0}
					';
				}			
				
				#### Header Middle
				if (!empty($customizer['header-middle'])) {
					$styles .= '
						.header__middle {background: '.$customizer['header-middle'].'}
					';
				}		
				
				#### Header Middle Color
				if (!empty($customizer['header-middle-color'])) {
					$styles .= '
						@media screen and (min-width: 768px) {
							.header__middle, .header__middle a {color: '.$customizer['header-middle-color'].'}
						}
					';
				}
			}
			
			#### Navbar 
			if (!empty($customizer['navbar-bg'])) {
				$styles .= '
					.header__bottom, .header-two .header__bottom {background: '.$customizer['navbar-bg'].'}
				';
			}			
			
			#### Navbar Link Color
			if (!empty($customizer['navbar-color'])) {
				$styles .= '
					.header__bottom--link,#header button>i {color: '.$customizer['navbar-color'].' !important}
					.header__bottom--menu .menu-item-has-children:after, .header__bottom--menu .geoit-mega-menu:after {color: '.$customizer['navbar-color'].'; opacity:0.75}
				';
			}			
			
			#### Navbar Link Color - Current
			if (!empty($customizer['navbar-current-color'])) {
				$styles .= '
					.header__bottom--menu .current-menu-item {color: '.$customizer['navbar-current-color'].' !important}
					.header__bottom--menu .current-menu-item {box-shadow: inset 0px -2px 0 0 '.$customizer['navbar-current-color'].' !important}
				';
			}		
			
			#### Navbar Link Color - Hover
			if (!empty($customizer['navbar-hover-color'])) {
				$styles .= '
					.header__bottom--menu li:hover>.header__bottom--link {color: '.$customizer['navbar-hover-color'].' !important}
					.header__bottom--menu li:hover>.header__bottom--link {box-shadow: inset 0px -2px 0 0 '.$customizer['navbar-hover-color'].' !important}
				';
			}
			
			#### Navbar Border Color
			if (!empty($customizer['navbar-border-color'])) {		
				if (ot_get_option('head-layout-select') == 'head-layout-2') {
					$styles .= '
						.header__search, .header__top--social, .header__trending, .header__top--right {border-color: '.$customizer['navbar-border-color'].' !important}
					';
				} else {
					$styles .= '
					.header__bottom {border-color: '.$customizer['navbar-border-color'].' !important}
				';
				}
			}
			
			#### Navbar Sub Menu
			if (!empty($customizer['navbar-sub-menu'])) {
				$styles .= '
					.header__bottom .sub-menu, .header__bottom .sub-menu li a {background: '.$customizer['navbar-sub-menu'].' !important}
				';
			}
			
			#### Navbar Sub Menu Color
			if (!empty($customizer['navbar-sub-menu-color'])) {
				$styles .= '
					.header__bottom--menu .sub-menu li a {color: '.$customizer['navbar-sub-menu-color'].' !important}
				';
			}
			
			#### Navbar Font Size
			if (!empty($customizer['navbar-font-size'])) {
				$styles .= '
					.header__bottom--link {font-size: '.$customizer['navbar-font-size'].'px !important}
				';
			}
			
			#### Navbar SubMenu Font Size
			if (!empty($customizer['navbar-sub-menu-font-size'])) {
				$styles .= '
					.header__bottom--menu .sub-menu li a {font-size: '.$customizer['navbar-sub-menu-font-size'].'px !important}
				';
			}
			
			### Featured Post Big Item Headline Font Size
			if (!empty($customizer['featured-posts-big-font-size'])) {
				$styles .= '
				@media screen and (min-width: 768px) {
					.carousel__big--item .carousel__content .headline, .slider-style-2 .carousel__content .headline {font-size: '.$customizer['featured-posts-big-font-size'].'px !important; line-height: calc(1.54 * '.$customizer['featured-posts-big-font-size'].'px) !important;}
				}
				';
			}
			
			### Featured Post Item Headline Font Size
			if (!empty($customizer['featured-posts-font-size'])) {
				$styles .= '
				@media screen and (min-width: 768px) {
					.carousel__content .headline {font-size: '.$customizer['featured-posts-font-size'].'px; line-height: calc(1.54 * '.$customizer['featured-posts-font-size'].'px);}
				}
				';
			}
			
			### Post List Item Headline Font Size
			if (!empty($customizer['posts-list-headline-font-size'])) {
				$styles .= '
				@media screen and (min-width: 768px) {
					.uck-card .headline, .uck-card-big .headline, .uck-card-list.uck-card .headline {font-size: '.$customizer['posts-list-headline-font-size'].'px; line-height: calc(1.54 * '.$customizer['posts-list-headline-font-size'].'px);}
				}
				';
			}
			
			
			### Post List Item Headline Color
			if (!empty($customizer['posts-list-headline-color']) && $customizer['posts-list-headline-color'] != '#222222') {
				$styles .= '
					.uck-card .headline a, .geoit-popular-post-content .headline a {color: '.$customizer['posts-list-headline-color'].';}
				';
			}
			
			### Post List Item Headline Font Size
			if (!empty($customizer['posts-list-headline-font-size-sidebar'])) {
				$styles .= '
				@media screen and (min-width: 768px) {
					.sidebar .headline, .widget-homepage .uck-card--col_right .headline, .uck-card--col_right .headline, .geoit-popular-post-content .headline {font-size: '.$customizer['posts-list-headline-font-size-sidebar'].'px; line-height: calc(1.54 * '.$customizer['posts-list-headline-font-size-sidebar'].'px);}
				}
				';
			}
			
			### Single Page Headline Font Size
			if (!empty($customizer['single-page-headline-font-size'])) {
				$styles .= '
				@media screen and (min-width: 768px) {
					.content__post--article .headline, .content-header-meta .headline, .content__gallery .content__post--article .headline {font-size: '.$customizer['single-page-headline-font-size'].'px !important; line-height: calc(1.54 * '.$customizer['single-page-headline-font-size'].'px);}
				}
				';
			}
			
			### Single Page Headline Color
			if (!empty($customizer['single-page-headline-color']) && $customizer['single-page-headline-color'] != '#222222') {
				$styles .= '
					.content__post--article .headline, .content-header-meta .headline {color: '.$customizer['single-page-headline-color'].';}
				';
			}
			
			### Single Page Content Font Size
			if (!empty($customizer['single-page-content-font-size'])) {
				$styles .= '
				@media screen and (min-width: 768px) {
					.content__post--article p, .content__post--article li, .content__post--article ul, .content__post--article ol, .uckan-card--right>.headline {font-size: '.$customizer['single-page-content-font-size'].'px; line-height: calc(1.54 * '.$customizer['single-page-content-font-size'].'px);}
				}
				';
			}
			
			### Single Page Link Colors
			if (!empty($customizer['single-page-content-link-color'])) {
				$styles .= '
					.geoit_entry-content a {color: '.$customizer['single-page-content-link-color'].';}
				';
			}
			if (!empty($customizer['single-page-content-link-color-hover'])) {
				$styles .= '
					.geoit_entry-content a:hover {color: '.$customizer['single-page-content-link-color-hover'].';}
				';
			}
			if (!empty($customizer['single-page-content-link-color-visited'])) {
				$styles .= '
					.geoit_entry-content a:visited {color: '.$customizer['single-page-content-link-color-visited'].';}
				';
			}

			
			$sidebar_position = ot_get_option('h-layout-select');
			if ($sidebar_position == 'h-layout-2') {
				$styles .= '@media (min-width: 992px) {.page__content>.container>.row>.content {float:right}}'."\n";
			}
			
			$header_top = ot_get_option('header-top-status-mobil');
			if ($header_top == 'on') {
				$styles .= '@media (max-width: 992px) {.header__top{display:none!important}}'."\n";
			}
			
			$dark_logo = (!empty(get_theme_mod('geoit_logo_dark'))) ? get_theme_mod('geoit_logo_dark') : '';
			
			if ($dark_logo != '') {
				$styles .= '.dark-mode .header__logo img { content: url('.$dark_logo.');}'."\n";
			}
			
				$styles .= '
				i.mce-i-aligncenter, i.mce-i-alignjustify, i.mce-i-alignleft, 
				i.mce-i-alignright, i.mce-i-backcolor, i.mce-i-blockquote, i.mce-i-bold, 
				i.mce-i-bullist, i.mce-i-charmap, i.mce-i-dashicon, i.mce-i-dfw, 
				i.mce-i-forecolor, i.mce-i-fullscreen, i.mce-i-help, i.mce-i-hr, 
				i.mce-i-indent, i.mce-i-italic, i.mce-i-link, i.mce-i-ltr, 
				i.mce-i-numlist, i.mce-i-outdent, i.mce-i-pastetext, i.mce-i-pasteword, 
				i.mce-i-redo, i.mce-i-remove, i.mce-i-removeformat, 
				i.mce-i-spellchecker, i.mce-i-strikethrough, i.mce-i-underline, 
				i.mce-i-undo, i.mce-i-unlink, i.mce-i-wp-media-library, i.mce-i-wp_adv, 
				i.mce-i-wp_code, i.mce-i-wp_fullscreen, i.mce-i-wp_help, 
				i.mce-i-wp_more, i.mce-i-wp_page {
					 font: normal 20px/1 dashicons !important;
				}
				';
				$styles .= '
				.dark-mode .cookie, .dark-mode .widget>ul:not(.instagram-pics)>li:before {background: rgba(103, 103, 103, 0.95)}
				.dark-mode .cookie {color:rgba(255,255,255,.7)}
				.dark-mode .geo-notification-content,.dark-mode #header .header__top,.dark-mode .header__search--form,.dark-mode .mobil_login_button:after, body.dark-mode,.dark-mode #toc_container li a span, .dark-mode .geo_posting-item input:focus, .dark-mode .mailchimp-subscribe__email-input {
					background: #232323 !important
				}
				.dark-mode #toc_container a:hover, .dark-mode .widget .or-div span {
					background: #232323 !important
				}
				.dark-mode .geo-notification-header,.dark-mode .geo-notification-footer, .dark-mode #load-more-posts-button-wrapper,.dark-mode .header__bottom .sub-menu,.dark-mode .widget .or-div:after,.dark-mode .widget input[type="checkbox"]:after,.dark-mode .search-field, .dark-mode .header__bottom .sub-menu li a,.dark-mode #demo_r_ekla_m,.dark-mode #cookie-box, .dark-mode #geo_mobil_menu, .dark-mode .wq-results, .dark-mode .q-results, .dark-mode .content__title .uckan-btn,.dark-mode .manset_slider .owl-dots,.dark-mode .content_post_add,.dark-mode .twPc-bg-empty,.dark-mode #geo_mobil_menu .header__top--social li a,.dark-mode select,.dark-mode .geo_puan,.dark-mode,.dark-mode .widget .geoit_login-wrapper input, .dark-mode .wpuc-coin-list-row, .dark-mode .content__gallery_nav>:first-child,.dark-mode .content__gallery_nav>:last-child, .dark-mode #tab-menu .tabs, .dark-mode .uck-accordion--box, .dark-mode .sub-menu .current-menu-item, .dark-mode .comment-bottom, .dark-mode .geo_create_post .geo_posting-item input, .dark-mode .geo_create_post select, .dark-mode .input-file + .js-labelFile,.dark-mode .geo_login-widget input, .dark-mode .geo_login-widget textarea, .dark-mode .author-page-info li {
					background: #313131 !important;
					color: rgba(255,255,255,.7) !important
				}
				.dark-mode .wq_quizCtr .wq_singleAnswerCtr,.dark-mode .dropdown-content,.dark-mode .widget_search input.search-submit, .dark-mode .mailchimp-subscribe__submit, .dark-mode .uckan-card, .dark-mode pre, .dark-mode #geoit-video-box .current_video, .dark-mode .geoit-recipe {
					background: #313131 !important;
					color: rgba(255,255,255,.7) !important
				}
				.dark-mode .carousel__content--meta .readmore,.dark-mode .mailchimp_subsribe{
					border-color: #313131
				}
				.dark-mode .dropdown-content:before{
					border-color: #313131 transparent
				}
				.dark-mode .carousel__content--meta .readmore,.dark-mode .widget .widget-social-accounts>*,.dark-mode .form-control, .dark-mode .form-table input,.dark-mode .geoit_user_ranking .user_count,.dark-mode #toc_container,.dark-mode #toc_container li:nth-child(2n) a, .dark-mode .page-users .geoit_user_ranking.birinci_uye, .dark-mode .alert, .dark-mode .uckan-btn {
					background: #313131 !important;
					color: rgba(255,255,255,.7) !important
				}
				.dark-mode .twPc-ArrangeSizeFit:hover {
					background: #313131 !important;
					color: rgba(255,255,255,.7) !important
				}
				.dark-mode .geoit_user_ranking:hover {
					background: #313131 !important;
					color: rgba(255,255,255,.7) !important
				}
				.dark-mode #geoit-video-box .current_video .uck-card--col_right,.dark-mode .geo_trending_post, .dark-mode #geoit-video-box .uck-card--col_right:hover,.dark-mode .dropdown-content ul > li > a:hover,.dark-mode #popup-box-content {
					background: #313131 !important;
					color: rgba(255,255,255,.7) !important
				}
				.dark-mode .geoit-popular-post-item-style2:before {
					background: rgba(0,0,0,.75)
				}
				.dark-mode .fixed-nav {
					background: rgba(60,60,60,.95)
				}
				.dark-mode .header__bottom--menu a:before, .dark-mode .geo-review-badge, .dark-mode .uckan-btn:after, .dark-mode .uckan-btn:before {
					background: rgba(255,255,255,.25)
				}
				.dark-mode ul.tabs li.active {
						box-shadow: inset 0px -2px 0 rgba(255,255,255,.1);
				}
				.dark-mode .uck-card-timeline-icon,.dark-mode .geoit-popular-post-item .post-counter-label,.dark-mode.lazyload-enable .carousel__item,.dark-mode .geo_first_category, .dark-mode .load-more-posts-button,.dark-mode .navigation.pagination, .dark-mode #cookie-box button,.dark-mode .header__search--form button, .dark-mode .uck-card, .dark-mode ul.tabs li.active,.dark-mode .uck-card-big .uck-card--content,.dark-mode .twPc-div,.dark-mode .form__wrapper label:before,.dark-mode .form__wrapper .form__input:valid + label:before,.dark-mode .form__wrapper .form__input:focus + label::before,.dark-mode .form__wrapper .form__input, .dark-mode .widget .geoit_login-wrapper, .dark-mode .wpuc-grid-item-inner, .dark-mode #commentform, .dark-mode .input-area,.dark-mode table, .dark-mode .geo_post-submit-left, .dark-mode .geo_post-submit-right, .dark-mode .geo_post-submit-full,.dark-mode .geoit-mega-menu-block,.dark-mode .header__middle,.dark-mode .header-one .header__bottom, .dark-mode .author-box,.dark-mode .gotop,.dark-mode .more-in-category,.dark-mode #geo_viral_reactions ul,.dark-mode #comments .comment-list .comment-bottom, .dark-mode .content__post--article,.dark-mode .tab_container,.dark-mode #footer,.dark-mode .masonry,.dark-mode .subs-content,.dark-mode .geo_submit_post, .dark-mode .geo_login-widget, .dark-mode .widget, .dark-mode .tab_menu_comments,.dark-mode #tab-menu .uck-card--col_right .uck-card--image:before, .dark-mode .register-frontend, .dark-mode .header-one .header__bottom, .dark-mode .header-default .header__bottom {
					background: #3c3c3c !important;
					color: rgba(255,255,255,.7) !important
				}
				.dark-mode .geo-notification-header, .dark-mode .geo-notification-footer, .dark-mode .geo-notification-content li,.dark-mode .geoit-popular-post-item-style2,.dark-mode .load-more-posts-button,.dark-mode .uckan-card--right>.type,.dark-mode .widget .or-div span, .dark-mode .wq-results, .dark-mode .q-results,.dark-mode .search-field,.dark-mode pre,.dark-mode .stories.snapgram .story > a > .img > *,.dark-mode #tab-menu .uck-card--col_right .uck-card--image:before,.dark-mode .uckan-card,.dark-mode .form-control, .dark-mode .form-table input, .dark-mode .widget .widget-social-accounts>*,.dark-mode .widget .geoit_login-wrapper input,.dark-mode #commentform .comment-bottom_recaptcha .gglcptch,.dark-mode #toc_container li a span,.dark-mode #toc_container,.dark-mode #toc_container li a span.dark-mode #geo_mobil_menu .header__top--social li a,.dark-mode #geo_mobil_menu .menu-mobil li,.dark-mode .mailchimp-subscribe__email-input, .dark-mode .gotop, .dark-mode .alert {
					border-color: #3c3c3c !important
				}
				.dark-mode .load-more-posts-button, .dark-mode .comment-reply-link i,.dark-mode .content__post--article ul li,.dark-mode #mobile-menu-icon, .dark-mode .content__post--article ol li,.dark-mode .uckan-card--right>.type, .dark-mode .comment-edit-link i,.dark-mode ul.tabs li, .dark-mode .textwidget, .dark-mode .widget p, .dark-mode .footer__bottom p, .dark-mode .uck-card p, .dark-mode .register-header div, .dark-mode .author-box p,.dark-mode .content__post-meta span, .dark-mode.content__post--article ul li, .dark-mode .content__post--article ol li {
					color: rgba(255,255,255,.5) !important
				}
				.dark-mode .subs-content:before, .dark-mode .geo_submit_post:after  {
					color: rgba(255,255,255,.1) !important
				}
				.dark-mode .geoit_authors_widget,.dark-mode .content__post-size span,.dark-mode .recentcomments .comment-author-link,.dark-mode .geo-post-source,.dark-mode #geo-post-source-links, .dark-mode .recipe-meta-inline,.dark-mode .geoit-nutrition-item,.dark-mode .geoit-recipe, .dark-mode .tagcloud a,.dark-mode .geoit_comment_footer>a, .dark-mode .geo_puan,.dark-mode .header-default .geo-menu>li,.dark-mode .header__search--form input, .dark-mode .post-page-numbers, .dark-mode .content__post--article_tags a,.dark-mode .header-default .header__bottom, .dark-mode .form__wrapper .form__input,.dark-mode .sidebar .widget>ul>li,.dark-mode .masonry,.dark-mode .uck-card-big,.dark-mode .masonry-grid,.dark-mode select,.dark-mode .twPc-bg,.dark-mode .no-comments,.dark-mode .comment-navigation,.dark-mode .geoit_user_ranking .user_count,.dark-mode .wq_questionsCtr>.wq_singleQuestionWrapper,.dark-mode .wq_quizCtr .wq_singleAnswerCtr,.dark-mode #toc_container a,.dark-mode .form-table+h3,.dark-mode .geoit_user_ranking,.dark-mode blockquote,.dark-mode .twPc-ArrangeSizeFit,.dark-mode .twPc-divStats,.dark-mode .comment-input,.dark-mode .uck-card-list .uck-card--meta,.dark-mode .uck-card--right a,.dark-mode .comment-input-group, .dark-mode .wpuc-coin-list-row, .dark-mode .comment-subscription-form, .dark-mode ul.tab-clone li, .dark-mode .geo_users-list, .dark-mode .user-card>*, .dark-mode .user-card, .dark-mode hr,.dark-mode #tab-menu.tabs-shortcode .tab_container,.dark-mode .uck-accordion--box.collapsible-active .uck-accordion--title,.dark-mode .uck-accordion--box,.dark-mode .uck-card-list,.dark-mode ul.tabs,.dark-mode .sidebar .uck-card--col_left,.dark-mode .sidebar .uck-card--col_left, .dark-mode #comments .comment,.dark-mode .content__post--article_tags,.dark-mode table,.dark-mode .col-1 .uck-card--col_top,.dark-mode .tab_menu_comments li,.dark-mode .geo_create_post .geo_posting-item input, .dark-mode .geo_create_post select, .dark-mode .input-file + .js-labelFile, .dark-mode .author-page-info li,.dark-mode .geo_login-widget input, .dark-mode .geo_login-widget textarea,.dark-mode #adduser h3,.dark-mode .register-frontend .register-header,.dark-mode .geoit-mega-menu-block .widgettitle,.dark-mode .geoit-mega-menu-block ul>li>a,.dark-mode .geoit-mega-menu-block,.dark-mode .content-header-meta,.dark-mode #geo_viral_reactions em,.dark-mode .geo_breadcrumb,.dark-mode #review-box .review-top,.dark-mode .geo-reaction-title,.dark-mode .reading-time,.dark-mode #review-box,.dark-mode .comment-bottom,.dark-mode .footer-sidebar:nth-child(2),.dark-mode .content__post--meta ul, .dark-mode .more-in-heading,.dark-mode .content__gallery_nav,.dark-mode .content__gallery .geo_breadcrumb,.dark-mode .content__gallery_nav>*,.dark-mode .subs-content,.dark-mode .footer__bottom,.dark-mode .geo_submit_post, .dark-mode .uckan-card-big .geo__item, .dark-mode .uck-card-list:after, .dark-mode .uck-card--col_right, .dark-mode .masonry .uck-card, .dark-mode .widget .content__title .uckan-btn, .dark-mode .geoit_has-login li {
					border-color: rgba(255, 255, 255, 0.05)!important
				}
				.dark-mode .widget, .dark-mode #tab-menu .tabs, .dark-mode .tab_menu_comments, .dark-mode .register-frontend, .dark-mode .blog-big-group, .dark-mode .box-sd, .dark-mode .post-list-group, .dark-mode .masonry, .dark-mode .content__post,
					.dark-mode .geo_homepage_1col .col-1,.dark-mode .page_description, .dark-mode #footer, .dark-mode .navigation.pagination, .dark-mode .geo_post-submit-left,.dark-mode .geo_post-submit-right,.dark-mode .geo_post-submit-full, .dark-mode .geo_users_list, .dark-mode .twPc-div, .dark-mode .geoit_author_box, .dark-mode .content_post_add,
					.dark-mode .content__title .uckan-btn {
						border-color: rgba(255, 255, 255, 0.05)!important
					}
				.dark-mode .wpuc-coin-grid-item {
					box-shadow: 1px -1px 0 rgba(255,255,255,.1) !important
				}
				.dark-mode .header__bottom--menu .current-menu-item,.dark-mode .header__bottom--menu li:hover>.header__bottom--link {
					box-shadow: inset 0 -2px 0 0 rgba(255,255,255,.25)
				}
				.dark-mode .header__bottom--menu .header__bottom--link,.dark-mode #toc_container a,.dark-mode .geo-post-source-title, .dark-mode .geoit-post-meta, .dark-mode .widget .or-div,.dark-mode .recentcomments,.dark-mode .widget .geoit_login_232,.dark-mode .widget .geoit_login-wrapper label,.dark-mode .content__title .uckan-btn,.dark-mode #review-box ul li .review-criteria-bar-container span.right,.dark-mode #comments textarea,.dark-mode .form__label, .dark-mode .uck-card, .dark-mode .uck-card .headline,.dark-mode #geo_viral_reactions li a span, .dark-mode .geo_login-widget p,.dark-mode .geoit-mega-menu-block .widgettitle,.dark-mode ul.tabs li.active,.dark-mode .geo-reaction-title, body.dark-mode,.dark-mode #review-box .review-top .review-text .review-title, .dark-mode #footer .footer__title .headline, .dark-mode .sidebar .headline{
					color: rgba(255,255,255,.7) !important
				}
				.dark-mode .trending-post>div, .dark-mode a, .dark-mode .input-area,.dark-mode .uck-card--content span, .dark-mode .uck-card--col_left .date,.dark-mode .more-in-content span,.dark-mode #geo_mobil_menu .login-close, .dark-mode .comment-bottom--account, .dark-mode .register-header h3,.dark-mode #header:not(.header-two) .mobil_login_button button, .dark-mode #header:not(.header-two) #mobile-menu-icon {
					color: rgba(255,255,255,.7) !important
				}
				.dark-mode .header__logo_wrapper, .dark-mode blockquote:before {
						background: #3c3c3c !important
				}
				.dark-mode #geo_viral_reactions em, .dark-mode .geoit-category-image-content h5, .dark-mode .header__bottom--menu.mobil-active .geo-menu a,.dark-mode .header__search--form input,.dark-mode .mobil-close,.dark-mode .form-label-group > label,.dark-mode .twPc-StatLabel, .dark-mode .wq_quizCtr .wq_singleAnswerCtr, .dark-mode .wq_questionTextCtr h4 {
					color: rgba(255,255,255,.7) !important
				}
				.dark-mode .uck-card-timeline-left:before, .dark-mode .uck-card-timeline-left:after {
					background: rgba(255, 255, 255, 0.05)!important
				}
				
				.dark-mode .navigation.pagination .page-numbers {border-color:#3c3c3c}
				.dark-mode .manset_slider .owl-dot{box-shadow: 1px 0px 0 #444}
				.dark-mode .stories.snapgram .story.seen > a > .img:before {border-color:#777}
				.dark-mode #geoit-video-box .col-md-4:after {    background-image: linear-gradient(to bottom, rgba(0,0,0,0) 50%, #000 100%);}
			'."\n";
			
			$styles .= '</style>'."\n";
			// end
		
			echo $styles;		
	}
}
add_action( 'wp_head', 'dynamic_styles', 100 );