<?php
if ( ! defined( 'ABSPATH' ) ) exit; # Exit if accessed directly

/*
 * Works with PHP 5.3 or Later
 */
if ( version_compare( phpversion(), '7.1', '<' ) ) {
	wp_die(__('Geoit Wordpress Temasının çalışması için lütfen sunucu php sürümünü 7.1 veya daha üstü bir sürüm ile güncelleyin.', 'geo'));
}

/*-----------------------------------------------------------------------------------*/
# Theme Setup
/*-----------------------------------------------------------------------------------*/
define ('THEME_VER',	"5.3" );
require_once('update-notifier.php');

/*-----------------------------------------------------------------------------------*/
# Included
/*-----------------------------------------------------------------------------------*/
require_once get_template_directory() . '/amp/functions.php';
require_once get_template_directory() . '/theme-options/tgm/plugin.php';
require_once get_template_directory() . '/frameworks/mailchimp.php';
require_once get_template_directory() . '/theme-options/template-functions.php';
require_once get_template_directory() . '/theme-options/template-tags.php';
require_once get_template_directory() . '/theme-options/helpers.php';
require_once get_template_directory() . '/frameworks/stories.php';

/*-----------------------------------------------------------------------------------*/
# Setup
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geo_setup2' ) ) {
  function geo_setup2() {
		add_theme_support( 'editor-font-sizes', array(
			array(
				'name'      => __( 'Kü.ük', 'geo-admin' ),
				'shortName' => __( 'S', 'geo-admin' ),
				'size'      => 14,
				'slug'      => 'small'
			),
			array(
				'name'      => __( 'Normal', 'geo-admin' ),
				'shortName' => __( 'M', 'geo-admin' ),
				'size'      => 16,
				'slug'      => 'regular'
			),
			array(
				'name'      => __( 'Büyük', 'geo-admin' ),
				'shortName' => __( 'L', 'geo-admin' ),
				'size'      => 24,
				'slug'      => 'large'
			),
			array(
				'name'      => __( 'Büyük 2', 'geo-admin' ),
				'shortName' => __( 'XL', 'geo-admin' ),
				'size'      => 28,
				'slug'      => 'larger'
			),
			array(
				'name'      => __( 'Büyük 3', 'geo-admin' ),
				'shortName' => __( 'XXL', 'geo-admin' ),
				'size'      => 32,
				'slug'      => 'larger-2'
			)
		) );
		if ( function_exists( 'add_image_size' ) ){
			add_image_size( 'geo-carousel2', 475, 249, true );
			add_image_size( 'geo-carousel3', 430, 500, true );
			add_image_size( 'geo-small', 150, 90, true );
			add_image_size( 'geo-medium', 335, 195, true );
			add_image_size( 'geo-big', 850, 9999, false );
			add_image_size( 'geo-big2', 466, 250, true );
			add_image_size( 'geo-carousel', 950, 500, true );
			add_image_size( 'geo-slider', 1290, 500, true );
			add_image_size( 'geo-cat-image', 410, 250, true );
			
			add_theme_support( 'html5', [ 'script', 'style' ] );
			current_theme_supports('amp');
			
			$content_width = 794;
			$GLOBALS['content_width'] = apply_filters( 'geoit_content_width', $content_width );
		}
	}
}
add_action( 'after_setup_theme', 'geo_setup2' );

/*-----------------------------------------------------------------------------------*/
# Menu
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_register_nav_menu' ) ) {
 
	function geoit_register_nav_menu(){
		register_nav_menus( array('geo-mobil'  => __( 'Mobil Menü', 'geo' ), 'geo-header-top'  => __( 'Header Üst Menü', 'geo' )) );
		if ( function_exists( 'is_amp_endpoint' ) ) {
			register_nav_menus( array('geo-header-amp'  => __( 'AMP Menu', 'geo' )) );
		}
	}
	add_action( 'after_setup_theme', 'geoit_register_nav_menu', 0 );
}


/*-----------------------------------------------------------------------------------*/
# Sidebarlar
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_widgets_init' ) ) {
	function geoit_widgets_init() {
		$style = ot_get_option('block_title_style');
		$class = 'block_title_'.$style;
		register_sidebar(array(
			'name' => 'Sidebar',
			'id' => 'Sidebar',
			'before_widget' => '<aside id="%1$s" class="widget widget-0 %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<div class="content__title '.$class.'"><h4 class="uckan-btn">',
			'after_title' => '</h4></div>',
		));
		
		register_sidebar(array(
			'name' => 'Anasayfa: Sol Bölme',
			'id' => 'homepage_content',
			'before_widget' => '<aside class="widget widget-homepage widget-0 %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<div class="content__title '.$class.'"><h3 class="uckan-btn">',
			'after_title' => '</h3></div>',
		));
		register_sidebar(array(
			'name' => 'Anasayfa: Tam Genişlik Alt',
			'id' => 'home-full-width',
			'before_widget' => '<aside class="widget widget-homepage widget-full-width %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<div class="content__title '.$class.'"><h3 class="uckan-btn">',
			'after_title' => '</h3></div>',
		));
		if (ot_get_option('geo-footerwidgets') != 'off' && ot_get_option('footer-layout-select') != '2') {
			register_sidebar(array(
				'name' => 'Footer 1',
				'id' => 'Footer-1',
				'before_widget' => '<aside class="widget widget-footer %2$s">',
				'after_widget' => '</aside>',
				'before_title' => '<div class="footer__title"><h4 class="headline">',
				'after_title' => '</h4></div>',
			));
			register_sidebar(array(
				'name' => 'Footer 2',
				'id' => 'Footer-2',
				'before_widget' => '<aside class="widget widget-footer %2$s">',
				'after_widget' => '</aside>',
				'before_title' => '<div class="footer__title"><h4 class="headline">',
				'after_title' => '</h4></div>',
			));
			register_sidebar(array(
				'name' => 'Footer 3',
				'id' => 'Footer-3',
				'before_widget' => '<aside class="widget widget-footer widget-last %2$s">',
				'after_widget' => '</aside>',
				'before_title' => '<div class="footer__title"><h4 class="headline">',
				'after_title' => '</h4></div>',
			));
		}
		register_sidebar(array(
			'name' => 'Anasayfa: Tam Genişlik Üst',
			'id' => 'homepage_top',
			'before_widget' => '<aside class="widget widget-homepage widget-0 %2$s">',
			'after_widget' => '</aside>',
			'before_title' => '<div class="content__title '.$class.'"><h3 class="uckan-btn">',
			'after_title' => '</h3></div>',
		));
		if ($cookie = ot_get_option('geo_popup_box') == 'on') {
		register_sidebar(array(
			'name' => 'Popup',
			'id' => 'popup',
			'before_widget' => '<aside id="%1$s">',
			'after_widget' => '</aside>',
			'before_title' => '<div class="popup__title">',
			'after_title' => '</div>',
		));
		}
	}
}
add_action( 'widgets_init', 'geoit_widgets_init' );

	

/*-----------------------------------------------------------------------------------*/
# Kullanıcılar için Sosyal Medya Hesapları
/*-----------------------------------------------------------------------------------*/
add_action( 'show_user_profile', 'add_extra_social_links', 10, 2 );
add_action( 'edit_user_profile', 'add_extra_social_links', 10, 2 );
if ( ! function_exists( 'add_extra_social_links' ) ) {
function add_extra_social_links( $user, $false = 'on' )
{ 
 ?>
<?php if(is_admin()): ?><h3><?php _e('Sosyal Medya','geo'); ?></h3>
<?php else: ?>
<div class="widget">
	<div class="content__title block_title_style-3"><h4 class="uckan-btn"><?php _e('Sosyal Medya', 'geo'); ?></h4></div>
	<div class="col-md-12" style="padding: 30px;">	
<?php endif; ?>
<table class="form-table">
<?php if ( (is_admin() && current_user_can('administrator')) && $false != 'off' ) : ?>
<tr class="show-admin-bar user-admin-bar-front-wrap">
<th scope="row"><?php _e('Onaylanmış Hesap', 'geo'); ?></th>
<td><fieldset><legend class="screen-reader-text"><span><?php _e('Onaylanmış Hesap', 'geo'); ?></span></legend>
<label for="verified_user">
<input name="verified_user" type="checkbox" id="verified_user" value="yes" <?php if (esc_attr( get_the_author_meta( "verified_user", $user->ID )) == "yes") echo "checked";?>>
</label><br>
</fieldset>
</td>
</tr>
<?php endif; ?>
<?php if ( (is_admin() && current_user_can('administrator')) && (ot_get_option('geo_puan_sistem') == 'on')) : ?>
<tr class="show-admin-bar user-admin-bar-front-wrap">
<th scope="row"><?php _e('Kullanıcının Puanı', 'geo'); ?></th>
<td><fieldset><legend class="screen-reader-text"><span><?php _e('Puanınız', 'geo'); ?></span></legend>
<label for="geo_user_points">
<input name="geo_user_points" type="number" id="geo_user_points" value="<?php echo get_the_author_meta( 'geo_user_points', $user->ID ); ?>">
</label><br>
</fieldset>
</td>
</tr>
<?php endif; ?>
 <tr>
 <th><label for="facebook_profile"><?php _e('Facebook Kullanıcı Adınız','geo'); ?></label></th>
 <td><input type="text" name="facebook_profile" value="<?php echo esc_attr(get_the_author_meta( 'facebook_profile', $user->ID )); ?>" class="regular-text" />
</td>
 </tr>
<tr>
 <th><label for="twitter_profile"><?php _e('Twitter Kullanıcı Adınız','geo'); ?></label></th>
 <td><input type="text" name="twitter_profile" value="<?php echo esc_attr(get_the_author_meta( 'twitter_profile', $user->ID )); ?>" class="regular-text" />
</td>
 </tr>
<tr>
 <th><label for="instagram_profile"><?php _e('Instagram Kullanıcı Adınız','geo'); ?></label></th>
 <td><input type="text" name="instagram_profile" value="<?php echo esc_attr(get_the_author_meta( 'instagram_profile', $user->ID )); ?>" class="regular-text" /></td>
 </tr>
<tr>
 <th><label for="linkedin_profile"><?php _e('Linkedin Kullanıcı Adınız','geo'); ?></label></th>
 <td><input type="text" name="linkedin_profile" value="<?php echo esc_attr(get_the_author_meta( 'linkedin_profile', $user->ID )); ?>" class="regular-text" /></td>
 </tr>
 </table>
 <?php if(!is_admin()): ?></div></div><?php endif; ?>
 <?php
}
}
add_action( 'personal_options_update', 'save_extra_social_links' );
add_action( 'edit_user_profile_update', 'save_extra_social_links' );
if ( ! function_exists( 'save_extra_social_links' ) ) {
	function save_extra_social_links( $user_id )
	{
	update_user_meta( $user_id,'facebook_profile', sanitize_text_field( $_POST['facebook_profile'] ) );
	update_user_meta( $user_id,'twitter_profile', sanitize_text_field( $_POST['twitter_profile'] ) );
	update_user_meta( $user_id,'instagram_profile', sanitize_text_field( $_POST['instagram_profile'] ) );
	update_user_meta( $user_id,'linkedin_profile', sanitize_text_field( $_POST['linkedin_profile'] ) );
	if(is_admin()) {
		update_user_meta( $user_id, 'verified_user',  sanitize_text_field($_POST['verified_user']) );
		update_user_meta( $user_id, 'geo_user_points',  sanitize_text_field($_POST['geo_user_points']) );	 
	}
	}
}

/*-----------------------------------------------------------------------------------*/
# Stil Dosyaları
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geo_styles' ) ) {
	function geo_styles() {
		// geoit
		wp_enqueue_style('geoit-css', get_template_directory_uri() . '/assets/css/geoit.css', array(), THEME_VER);
		// remove dashicons
		$option = ot_get_option('geo-dashicons');
		if ($option == 'on' && !is_page())
		wp_deregister_style( 'dashicons' );
	  // if not singular page remove wp block css 
		if (!is_singular()) {
			wp_deregister_style( 'wp-block-library' );
			wp_deregister_style( 'wp-block-library-theme' );
		}
	}
}
add_action( 'wp_enqueue_scripts', 'geo_styles' );

/*-----------------------------------------------------------------------------------*/
# JS Dosyaları
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geo_scripts' ) ) {
	function geo_scripts() {
	
		$localize = array(
			'loading' => get_template_directory_uri().'/assets/img/ajax.svg',
			'ajax' => admin_url( 'admin-ajax.php' ),
			'nonce' => wp_create_nonce( 'ajax-nonce' ),
			'geo_path' => get_template_directory_uri(),
			'geoit_lazy' => (ot_get_option('geoit_lazy_images') != 'off') ? true : false,
			'pagination' => (!empty(ot_get_option('geot_posts_pagination'))) ? ot_get_option('geot_posts_pagination') : 'numbers',
			
			'sticky' => ot_get_option('geo-sticky'),
			'infinite' => ot_get_option('geo-infinite'),
			'popup' => ot_get_option('geo_popup_box'),
			'headroom' => (!empty(ot_get_option('navbar-sticky'))) ? ot_get_option('navbar-sticky') : false,
			'is_single' => is_single(),
			'post_format' => get_post_format(),
			'slider_autoplay' => (ot_get_option('geo_slider_autoplay') != 'off') ? true : false,
			'slider_pagination' => (ot_get_option('geo_slider_pagination') != 'off') ? true : false
		);
		
		// jQuery
		wp_enqueue_script( 'geo_jquery', get_template_directory_uri().'/assets/js/app.min.js', array('jquery'), THEME_VER, true );	
		
		// Popup
		if (ot_get_option('geo_popup_box') == 'on' || ot_get_option('geo_cookie_box') == 'on' || ot_get_option('geo-6-ads') != '' || ot_get_option('geo-6-ads-mobile') != '')
			wp_enqueue_script( 'geo_popup', get_template_directory_uri().'/assets/js/popup.min.js', array(), THEME_VER, true );


		// Stories
		if((ot_get_option('geoit_stories') == 'on') || (ot_get_option('geoit_story_cats') && ot_get_option('geoit_story_site')) ) {
			if (ot_get_option('geoit_stories_page')== 'on') {
				wp_enqueue_script( 'geo_zuck', get_template_directory_uri().'/assets/js/zuck.min.js', array(), THEME_VER, true );
			}
			else {
				if(is_front_page())
					wp_enqueue_script( 'geo_zuck', get_template_directory_uri().'/assets/js/zuck.min.js', array(), THEME_VER, true );
			}
		}
		
		if(!is_singular())
		wp_deregister_script( 'wp-embed' );
		
		// JS Vars
		wp_localize_script( 'geo_jquery', 'geo_vars', $localize);
		
		if ( is_singular() && comments_open() && get_option('thread_comments') ){
			wp_enqueue_script( 'comment-reply' );
		}
	}
}
add_action( 'wp_enqueue_scripts', 'geo_scripts', 10 );

function remove_head_scripts() {
	remove_action('wp_head', 'wp_print_scripts');
	remove_action('wp_head', 'wp_print_head_scripts', 9);
	remove_action('wp_head', 'wp_enqueue_scripts', 1);

	add_action('wp_footer', 'wp_print_scripts', 5);
	add_action('wp_footer', 'wp_enqueue_scripts', 5);
	add_action('wp_footer', 'wp_print_head_scripts', 5);
}
add_action( 'wp_enqueue_scripts', 'remove_head_scripts' );

function geoit_custom_customize_enqueue() {
	wp_enqueue_style( 'geoit-customizer-css', get_stylesheet_directory_uri() . '/assets/css/customizer.css' );
}
add_action( 'customize_controls_enqueue_scripts', 'geoit_custom_customize_enqueue' );

add_action( 'admin_enqueue_scripts', 'geoit_admin_scripts' );
function geoit_admin_scripts($hook) {
  wp_enqueue_script( 'geoit-admin-js', get_template_directory_uri() . '/assets/js/admin.js' );    
  wp_enqueue_style( 'geoit-admin-css', get_template_directory_uri() . '/assets/css/admin.css' );
}

/*-----------------------------------------------------------------------------------*/
# Yorumları Listele
/*-----------------------------------------------------------------------------------*/
function pressfore_comment_time_output($date, $d, $comment){
	return sprintf( _x( '%s önce', '%s = human-readable time difference', 'geo' ), human_time_diff( get_comment_time( 'U' ), current_time( 'timestamp' ) ) );
}
add_filter('get_comment_date', 'pressfore_comment_time_output', 10, 3);
if (!function_exists('geo_comment')) :
    function geo_comment($comment, $args, $depth)
    {
        $GLOBALS['comment'] = $comment;
        switch ($comment->comment_type) :
            case 'pingback' :
            case 'trackback' : ?>

                <?php
                break;
            default :
                # Proceed with normal comments.
                global $post; ?>

                <li <?php comment_class(); ?>  id="comment-<?php comment_ID(); ?>">
                  <div class="geoit_comment">
											<div class="geoit_comment_avatar">
                        <?php echo geoit_get_avatar($comment->user_id, 70); ?>
											</div>
											<div class="geoit_comment_detail vcard" itemtype="http://schema.org/Comment" itemscope="itemscope" itemprop="comment">
												<div class="geoit_comment_meta">
													<span class="geoit_comment_author comment-author vcard">
													<?php 
													 $comment_url = $comment->comment_author_url;
													 $comment_author = get_comment_author();
													 if ($comment_url != '') {
														 echo '<a itemprop="author" class="fn" href="'.$comment_url.'">'.$comment_author.'</a>';
													 }
													 else {
														 echo '<cite itemprop="author" class="fn">'.$comment_author.'</cite>';
													 }
													 $commentid_geo = $comment->user_id;
														$verified = get_the_author_meta('verified_user', $commentid_geo); 
														if( $verified == 'yes' && $commentid_geo != '0') {
															echo '<label class="verify-geo" data-balloon="'.__('Onaylanmış Hesap', 'geo').'" data-balloon-pos="right"><i class="fa fa-check"></i></label>';
														} 
													?>
													</span>
													<span  class="date"> 
														<a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ); ?>">
														<?php echo get_comment_date(); ?>
														</a>
													</span>
												</div>
												<div class="geoit_comment_text comment-content" itemprop="text">
												<?php if ('0' == $comment->comment_approved) : ?>
													<p class="comment-awaiting-moderation"><?php _e(
														'Yorumunuz editörümüz tarafından incelendikten sonra uygunsa yayına alınacaktır, teşekkürler.',
														'geo'
													); ?></p>
												<?php endif; ?>
												<?php comment_text(); ?>
												</div>
												<div class="geoit_comment_footer">
													<?php comment_reply_link( array_merge($args, array(
													'reply_text' => __('Cevapla <span>&darr;</span>', 'geo'),
													'respond_id' => 'respond',    
													'depth'      => $depth,
													'max_depth'  => $args['max_depth']
												)
											)); ?>
											<?php edit_comment_link(__('Düzenle', 'geo'), '', '') ?>
												</div>
											</div>
									
									</div>
                 </li>
                <?php
                break;
        endswitch;
    }
endif;

/*-----------------------------------------------------------------------------------*/
# Gutenberg
/*-----------------------------------------------------------------------------------*/
function geoit_gutenberg_editor_css() {
    wp_enqueue_style(
        'paul-editor-style',
        get_template_directory_uri() . "/editor-styles.css",
        array(),
        '1.0'
    );
}
add_action('enqueue_block_editor_assets', 'geoit_gutenberg_editor_css');

add_action('admin_init', 'geoit_gutenberg_editor_font_load');
function geoit_gutenberg_editor_font_load() {
	global $pagenow;
	if ( $pagenow == 'post.php' ) {
		add_action('admin_head', 'dynamic_scripts');
	}
}

add_action('admin_head', 'geoit_gutenberg_editor_font');
function geoit_gutenberg_editor_font() {
	$font = get_theme_mod('geoit_theme_font');
	$first_big = ucwords(strtolower($font));
	$first_word2 = ucwords(strtolower($first_big), '_');
	$bul = '_';
	$degistir = ' ';
	$h_font = str_replace($bul, $degistir, $first_word2);
	if ($h_font == '') {
		$h_font = 'Poppins';
		$p_font = '-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen,Oxygen-Sans,Ubuntu,Cantarell,"Helvetica Neue","Open Sans",sans-serif';
	} else {
	}
	$styles = '<style type="text/css">
		.editor-post-title__block .editor-post-title__input, .wp-block-heading , .block-editor-block-list__layout h1, .block-editor-block-list__layout h2, .block-editor-block-list__layout h3, .block-editor-block-list__layout h4, .block-editor-block-list__layout h5, .block-editor-block-list__layout h6{
			font-family: "'.$h_font.'","Noto Serif", serif !important
		}
		
	</style>';
	echo $styles;
}

/*-----------------------------------------------------------------------------------*/
# DNS Prefetch
/*-----------------------------------------------------------------------------------*/
add_action('wp_head', 'geoit_dns_prefetch');
function geoit_dns_prefetch() {
	$option = ot_get_option('geo-dns-prefetch');
	$logo = [
		'logo'  => ot_get_option('geo-logo'),
		'logo-dark'  => ot_get_option('geo-dark-logo'),
		'logo-mobil'  => ot_get_option('geo-logo-mobil'),
		'logo-mobil-dark'  => ot_get_option('geo-dark-logo-mobil'),
	];
	if ($option != 'off') {

		echo "\n<meta http-equiv='x-dns-prefetch-control' content='on'>\n";

		$dns_domains = array(
			"//ajax.googleapis.com",
			"//fonts.googleapis.com",
			"//fonts.gstatic.com",
			"//s.gravatar.com",
			"//www.google-analytics.com"
		);

		foreach ( $dns_domains as $domain ) {
			if ( ! empty( $domain ) ){
				echo "<link rel='dns-prefetch' href='$domain' />\n";
			}
		}
	}
	
	if(ot_get_option('geoit_lazy_images') != 'off')
		return; 
	foreach ( $logo as $logo_img ) {
		if( ! empty( $logo_img ) ){
		$file_type = wp_check_filetype( $logo_img );
			if( ! empty( $ext = $file_type['ext'] ) ){
				echo "<link rel='preload' as='image' href='$logo_img' type='image/$ext'>\n";
			}
		}
	}
}

/*-----------------------------------------------------------------------------------*/
# Disable Srcset
/*-----------------------------------------------------------------------------------*/
function meks_disable_srcset( $sources ) {
    return false;
}

/*-----------------------------------------------------------------------------------*/
# Eski Yorumlar için Yazar İsimlerini Güncelle
/*-----------------------------------------------------------------------------------*/
add_filter( 'wp_calculate_image_srcset', 'meks_disable_srcset' );
add_filter('get_comment_author', 'wpse31694_comment_author_display_name');
function wpse31694_comment_author_display_name($author) {
    global $comment;
    if (!empty($comment->user_id)){
        $user=get_userdata($comment->user_id);
        $author=$user->display_name;    
    }

    return $author;
}

/*-----------------------------------------------------------------------------------*/
# Kategori Renk Seçici
/*-----------------------------------------------------------------------------------*/
function geoit_category_color_picker_field( $term ) {
	$color = get_term_meta( $term->term_id, '_category_color', true );
	$color = ( ! empty( $color ) ) ? "#{$color}" : '';
?>
	<tr class="form-field term-colorpicker-wrap">
		<th scope="row"><label for="term-colorpicker"><?php _e('Kategori Rengi', 'geoit-admin'); ?></label></th>
		<td>
			<input name="_category_color" value="<?php echo $color; ?>" class="colorpicker" id="term-colorpicker" />
		</td>
	</tr>
<?php
}
add_action( 'category_edit_form_fields', 'geoit_category_color_picker_field' );

# Kategori Renk Seçici - Kayıt
/*-----------------------------------------------------------------------------------*/
function geoit_category_color_picker_save( $term_id ) {
	if( isset( $_POST['_category_color'] ) && ! empty( $_POST['_category_color'] ) ) {
		update_term_meta( $term_id, '_category_color', sanitize_hex_color_no_hash( $_POST['_category_color'] ) );
	} else {
		delete_term_meta( $term_id, '_category_color' );
	}
}
add_action( 'created_category', 'geoit_category_color_picker_save' ); 
add_action( 'edited_category',  'geoit_category_color_picker_save' );

# Kategori Renk Seçici - Seçim Aracı
/*-----------------------------------------------------------------------------------*/
function geoit_category_color_picker_enqueue( $taxonomy ) {
	if( null !== ( $screen = get_current_screen() ) && 'edit-category' !== $screen->id ) {
			return;
	}
	wp_enqueue_script( 'wp-color-picker' );
	wp_enqueue_style( 'wp-color-picker' );
}
add_action( 'admin_enqueue_scripts', 'geoit_category_color_picker_enqueue' );

# Kategori Renk Seçici - Seçim Aracını Aktif Et
/*-----------------------------------------------------------------------------------*/
function geoit_category_color_picker_init_inline() {
	if( null !== ( $screen = get_current_screen() ) && 'edit-category' !== $screen->id ) {
			return;
	}
?>
	<script>
		jQuery( document ).ready( function( $ ) {
			$( '.colorpicker' ).wpColorPicker();
		} );
	</script>
<?php
}
add_action( 'admin_print_scripts', 'geoit_category_color_picker_init_inline', 20 );
function ntz_fix_syntax_highlighter($content)
{
	$content = str_replace('&amp;&amp;', '&&', $content);
	$content = preg_replace('/&amp;([^;]+;)/', '&$1', $content);

	return $content;
}
add_filter('syntaxhighlighter_htmlresult', function($html) {
    return preg_replace('/&amp;([^;]+;)/', '&$1', $html);
});