<?php 

/*-----------------------------------------------------------------------------------*/
# WP Head Codes
/*-----------------------------------------------------------------------------------*/
function geoit_wp_head() {
	$kod = ot_get_option('geo-wp-head');
	$out = '';
	if (!empty($kod))
		$out = $kod;
	echo $out;
}
add_action('wp_head', 'geoit_wp_head');

/*-----------------------------------------------------------------------------------*/
# AMP Head Codes
/*-----------------------------------------------------------------------------------*/
function geoit_amp_wp_head() {
	$kod = ot_get_option('geo-amp-wp-head');
	$out = '';
	if (!empty($kod))
		$out = $kod;
	echo $out;
}
add_action('amp_post_template_head', 'geoit_amp_wp_head');

/*-----------------------------------------------------------------------------------*/
# AMP Footer Codes
/*-----------------------------------------------------------------------------------*/
function geoit_amp_footer_codes() {
	$kod = ot_get_option('geo-amp-footer-codes');
	$out = '';
	if (!empty($kod))
		$out = $kod;
	echo $out;
}
add_action('amp_post_template_footer', 'geoit_amp_footer_codes');


/*-----------------------------------------------------------------------------------*/
# Share on Telegram
/*-----------------------------------------------------------------------------------*/
function telegramForwardButton($url, $text = '') {
  $share_url = 'https://t.me/share/url?url='.rawurlencode($url).'&text='.rawurlencode($text);
  return "<a href=\"{$share_url}\">Share</a>";
}

/*-----------------------------------------------------------------------------------*/
# Puanları Sıfırla
/*-----------------------------------------------------------------------------------*/
add_action('admin_init', 'geo_points_reset');
function geo_points_reset() {
	$kontrol = ot_get_option('geo_puan_reset');

    //check if admin, if not, lets get out of here - don't run remainder of function 
    if ( current_user_can('administrator') && $kontrol == 'on') 
    {
			//check that $_POST is not empty & that correct wp_nonce is supplied
			//checl that $_POST['delete_credit'] is also set and passed with $_POST variables
			if ( !empty($_POST) )
			 {
					 //set your role to apply this action to
					 // $role = 'subscriber';

					 //get all users of this role (i.e. Subcribers)
					 // $users = get_users('role='.$role);
					 $users = get_users();

					 //iterate of each user returned applying our delete_user_meta function
					 foreach ($users as $user) {
						delete_user_meta($user->ID, 'cover_puan');
						delete_user_meta($user->ID, 'avatar_puan');
						delete_user_meta($user->ID, 'geo_user_points');
					 }

			 }
     }
}

/*-----------------------------------------------------------------------------------*/
# Galeri Sayfalama
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'tp_link_pages' ) ) {
	function tp_link_pages() {
			global $page, $numpages;

			echo paginate_links( array(
					'base' => get_permalink() . '/%#%/',
					'format' => get_permalink() . '/%#%/',
					'current' => $page,
					'total' => $numpages,
					'next_text' => '<i class="fa fa-long-arrow-right"></i>',
					'prev_text' => '<i class="fa fa-long-arrow-left"></i>',
			) );
	}
}

/*-----------------------------------------------------------------------------------*/
# Body class
/*-----------------------------------------------------------------------------------*/
add_filter( 'body_class','my_body_classes' );
if ( ! function_exists( 'my_body_classes' ) ) {
	function my_body_classes( $classes ) {
		$classes[] = (ot_get_option('dark_theme') == 'on') ? 'dark-mode' : 'light-mode';
		$classes[] = (ot_get_option('geo-infinite') == 'on') ? 'infinite-enable' : 'infinite-disable';
		$classes[] = (ot_get_option('geoit_sidebar_mobile') == 'on') ? 'sidebar-mobile-enable' : 'sidebar-mobile-disable';
		$classes[] = (ot_get_option('geo_slider_overlay') == 'off') ? 'overlay-disable' : 'overlay-enable';
		$classes[] = (ot_get_option('geoit_lazy_images') == 'on') ? 'lazyload-enable' : 'lazyload-disable';
		$classes[] = (ot_get_option('head-layout-select') == 'head-layout-2') ? 'header-style-2' : '';
		
		if (ot_get_option('geo_slider_position_content') == 'top') {
			$classes[] = 'slider-content-position-t';
		} elseif (ot_get_option('geo_slider_position_content') == 'middle') {
			$classes[] = 'slider-content-position-m';
		} elseif(ot_get_option('geo_slider_position_content') == 'bottom') {
			$classes[] = 'slider-content-position-b';
		}
		
		if (ot_get_option('geo_slider_position_align') == 'left') {
			$classes[] = 'slider-content-h-position-l';
		} elseif (ot_get_option('geo_slider_position_align') == 'right') {
			$classes[] = 'slider-content-h-position-r';
		} elseif(ot_get_option('geo_slider_position_align') == 'center') {
			$classes[] = 'slider-content-h-position-c';
		}
		
		return $classes;
			 
	}
}

/*-----------------------------------------------------------------------------------*/
# Post Format
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geo_post_formats' ) ) {
	function geo_post_formats() {
		$format = get_post_format(); if (false === $format) $format = 'standard';
		if ($format == 'gallery') : ?>
			<div class="geo-post-format"><svg xmlns="http://www.w3.org/2000/svg" height="512pt" viewBox="0 0 512 512" width="512pt"><path d="m452 70h-40v-10c0-33.085938-26.914062-60-60-60h-192c-33.085938 0-60 26.914062-60 60v10h-40c-33.085938 0-60 26.914062-60 60v251c0 33.085938 26.914062 60 60 60h40v11c0 33.085938 26.914062 60 60 60h192c33.085938 0 60-26.914062 60-60v-11h40c33.085938 0 60-26.914062 60-60v-251c0-33.085938-26.914062-60-60-60zm-392 331c-11.027344 0-20-8.972656-20-20v-251c0-11.027344 8.972656-20 20-20h40v291zm312 51c0 11.027344-8.972656 20-20 20h-192c-11.027344 0-20-8.972656-20-20v-392c0-11.027344 8.972656-20 20-20h192c11.027344 0 20 8.972656 20 20zm100-71c0 11.027344-8.972656 20-20 20h-40v-291h40c11.027344 0 20 8.972656 20 20zm0 0"/></svg></div>
		<?php elseif ($format == 'video') : ?>
			<div class="geo-post-format">
<svg enable-background="new 0 0 407.51 407.51" version="1.1" viewBox="0 0 407.51 407.51" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
			<path d="m260.18 252.34l-99.788-58.514c-3-2.022-6.926-2.022-9.927 0-2.95 1.941-4.565 5.371-4.18 8.882v117.03c-0.385 3.51 1.229 6.941 4.18 8.882l4.702 1.567c1.863 0.038 3.691-0.51 5.224-1.567l99.788-58.514c4.905-2.448 6.897-8.41 4.448-13.315-0.96-1.928-2.522-3.489-4.447-4.45zm-92.996 49.11v-80.457l68.441 40.229-68.441 40.228z"/>
			<path d="m360.49 112.33h-313.47c-25.969 0-47.02 21.052-47.02 47.02v198.53c0 25.969 21.052 47.02 47.02 47.02h313.47c25.969 0 47.02-21.052 47.02-47.02v-198.53c0-25.969-21.052-47.02-47.02-47.02zm26.122 245.55c0 14.427-11.695 26.122-26.122 26.122h-313.47c-14.427 0-26.122-11.695-26.122-26.122v-198.53c0-14.427 11.695-26.122 26.122-26.122h313.47c14.427 0 26.122 11.695 26.122 26.122v198.53z"/>
			<path d="m53.812 80.98h300.41c5.771 0 10.449-4.678 10.449-10.449s-4.678-10.449-10.449-10.449h-300.41c-5.771 0-10.449 4.678-10.449 10.449s4.678 10.449 10.449 10.449z"/>
			<path d="M98.22,23.51H309.29c5.771,0,10.449-4.678,10.449-10.449S315.061,2.612,309.29,2.612H98.22     c-5.771,0-10.449,4.678-10.449,10.449S92.45,23.51,98.22,23.51z"/>
</svg>
</div>
		<?php elseif ($format == 'audio') : ?>
			<div class="geo-post-format"><i class="fa fa-music"></i></div>
		<?php else:
		endif;
	}
}

/*-----------------------------------------------------------------------------------*/
# Avatar
/*-----------------------------------------------------------------------------------*/
class basic_user_avatars {

	/**
	 * User ID
	 *
	 * @since 1.0.0
	 * @var int
	 */
	private $user_id_being_edited;

	/**
	 * Initialize all the things
	 *
	 * @since 1.0.0
	 */
	public function __construct() {


		// Actions
		add_action( 'admin_init',                array( $this, 'admin_init'               )        );
		add_action( 'show_user_profile',         array( $this, 'edit_user_profile'        )        );
		add_action( 'edit_user_profile',         array( $this, 'edit_user_profile'        )        );
		add_action( 'personal_options_update',   array( $this, 'edit_user_profile_update' )        );
		add_action( 'edit_user_profile_update',  array( $this, 'edit_user_profile_update' )        );
		add_action( 'bbp_user_edit_after_about', array( $this, 'bbpress_user_profile'     )        );

		// Filters
		add_filter( 'get_avatar',                array( $this, 'get_avatar'               ), 10, 5 );
		add_filter( 'avatar_defaults',           array( $this, 'avatar_defaults'          )        );
	}

	/**
	 * Start the admin engine.
	 *
	 * @since 1.0.0
	 */
	public function admin_init() {

		// Register/add the Discussion setting to restrict avatar upload capabilites
		register_setting( 'discussion', 'basic_user_avatars_caps', array( $this, 'sanitize_options' ) );
		add_settings_field( 'basic-user-avatars-caps', __( 'Local Avatar Permissions', 'geo' ), array( $this, 'avatar_settings_field' ), 'discussion', 'avatars' );
	}

	/**
	 * Discussion settings option
	 *
	 * @since 1.0.0
	 * @param array $args [description]
	 */
	public function avatar_settings_field( $args ) {
		$options = get_option( 'basic_user_avatars_caps' );
		?>
		<label for="basic_user_avatars_caps">
			<input type="checkbox" name="basic_user_avatars_caps" id="basic_user_avatars_caps" value="1" <?php checked( $options['basic_user_avatars_caps'], 1 ); ?>/>
			<?php _e( 'Only allow users with file upload capabilities to upload local avatars (Authors and above)', 'geo' ); ?>
		</label>
		<?php
	}

	/**
	 * Sanitize the Discussion settings option
	 *
	 * @since 1.0.0
	 * @param array $input
	 * @return array
	 */
	public function sanitize_options( $input ) {
		$new_input['basic_user_avatars_caps'] = empty( $input['basic_user_avatars_caps'] ) ? 0 : 1;
		return $new_input;
	}

	/**
	 * Filter the avatar WordPress returns
	 *
	 * @since 1.0.0
	 * @param string $avatar 
	 * @param int/string/object $id_or_email
	 * @param int $size 
	 * @param string $default
	 * @param boolean $alt 
	 * @return string
	 */
	public function get_avatar( $avatar = '', $id_or_email, $size = 96, $default = '', $alt = false ) {

		// Determine if we recive an ID or string
		if ( is_numeric( $id_or_email ) )
			$user_id = (int) $id_or_email;
		elseif ( is_string( $id_or_email ) && ( $user = get_user_by( 'email', $id_or_email ) ) )
			$user_id = $user->ID;
		elseif ( is_object( $id_or_email ) && ! empty( $id_or_email->user_id ) )
			$user_id = (int) $id_or_email->user_id;

		if ( empty( $user_id ) )
			return $avatar;

		$local_avatars = get_user_meta( $user_id, 'basic_user_avatar', true );

		if ( empty( $local_avatars ) || empty( $local_avatars['full'] ) )
			return $avatar;

		$size = (int) $size;

		if ( empty( $alt ) )
			$alt = get_the_author_meta( 'display_name', $user_id );

		// Generate a new size
		if ( empty( $local_avatars[$size] ) ) {

			$upload_path      = wp_upload_dir();
			$avatar_full_path = str_replace( $upload_path['baseurl'], $upload_path['basedir'], $local_avatars['full'] );
			$image            = wp_get_image_editor( $avatar_full_path );
			$image_sized      = null;

			if ( ! is_wp_error( $image ) ) {
				$image->resize( $size, $size, true );
				$image_sized = $image->save();
			}

			// Deal with original being >= to original image (or lack of sizing ability).
			if ( empty( $image_sized ) || is_wp_error( $image_sized ) ) {
				$local_avatars[ $size ] = $local_avatars['full'];
			} else {
				$local_avatars[ $size ] = str_replace( $upload_path['basedir'], $upload_path['baseurl'], $image_sized['path'] );
			}

			// Save updated avatar sizes
			update_user_meta( $user_id, 'basic_user_avatar', $local_avatars );

		} elseif ( substr( $local_avatars[$size], 0, 4 ) != 'http' ) {
			$local_avatars[$size] = home_url( $local_avatars[$size] );
		}

		$author_class = is_author( $user_id ) ? ' current-author' : '' ;
		$avatar       = "<img alt='" . esc_attr( $alt ) . "' src='" . $local_avatars[$size] . "' class='avatar avatar-{$size}{$author_class} photo' height='{$size}' width='{$size}' />";

		return apply_filters( 'basic_user_avatar', $avatar );
	}

	/**
	 * Form to display on the user profile edit screen
	 *
	 * @since 1.0.0
	 * @param object $profileuser
	 * @return
	 */
	public function edit_user_profile( $profileuser ) {

		// bbPress will try to auto-add this to user profiles - don't let it.
		// Instead we hook our own proper function that displays cleaner.
		if ( function_exists( 'is_bbpress') && is_bbpress() )
			return;
		?>

<?php if(is_admin()): ?><h3><?php _e('Profil Fotoğrafı','geo'); ?></h3>
<?php else: ?>
<div class="widget">
	<div class="content__title block_title_style-3"><h4 class="uckan-btn"><?php _e('Profil Fotoğrafı', 'geo'); ?></h4></div>
	<div class="col-md-12" style="padding: 30px;">	
<?php endif; ?>
		<table class="form-table form-avatar">
			<tr>

				<td style="width: 100px;" valign="top">
					<?php echo get_avatar( $profileuser->ID ); ?>
				</td>
				<td>
				<?php
				$options = get_option( 'basic_user_avatars_caps' );
				if ( empty( $options['basic_user_avatars_caps'] ) || current_user_can( 'upload_files' ) ) {
					// Nonce security ftw
					wp_nonce_field( 'basic_user_avatar_nonce', '_basic_user_avatar_nonce', false );
					
					// File upload input
					echo '<input type="file" name="basic-user-avatar" id="basic-local-avatar" /><br />';

					if ( empty( $profileuser->basic_user_avatar ) ) {
						echo '<span class="description">' . __( 'Profil fotoğrafı yüklemek için yükleme alanını kullanabilirsiniz.', 'geo' ) . '</span>';
						echo '<span class="description"><br>' . __( 'Önerilen boyut 250x250px.', 'geo' ) . '</span>';
					} else {
						echo '<input type="checkbox" name="basic-user-avatar-erase" value="1" /> ' . __( 'Avatarımı Kaldır', 'geo' ) . '<br />';
					}

				} else {
					if ( empty( $profileuser->basic_user_avatar ) ) {
						echo '<span class="description">' . __( 'No local avatar is set. Set up your avatar at Gravatar.com.', 'geo' ) . '</span>';
					} else {
						echo '<span class="description">' . __( 'You do not have media management permissions. To change your local avatar, contact the site administrator.', 'geo' ) . '</span>';
					}	
				}
				?>
				</td>
			</tr>
		</table>
		<?php if(!is_admin()): ?></div></div><?php endif; ?>
		<script type="text/javascript">var form = document.getElementById('your-profile');form.encoding = 'multipart/form-data';form.setAttribute('enctype', 'multipart/form-data');</script>
		<?php
	}

	/**
	 * Update the user's avatar setting
	 *
	 * @since 1.0.0
	 * @param int $user_id
	 */
	public function edit_user_profile_update( $user_id ) {

		// Check for nonce otherwise bail
		if ( ! isset( $_POST['_basic_user_avatar_nonce'] ) || ! wp_verify_nonce( $_POST['_basic_user_avatar_nonce'], 'basic_user_avatar_nonce' ) )
			return;

		if ( ! empty( $_FILES['basic-user-avatar']['name'] ) ) {
			
			$filename = $_FILES['basic-user-avatar']['name'];
			$ext = pathinfo($filename, PATHINFO_EXTENSION);
			$allowed = array('jpg', 'png', 'jpeg');
			if( in_array( $ext, $allowed ) ){
				

				// Allowed file extensions/types
				$mimes = array(
					'jpg|jpeg|jpe' => 'image/jpeg',
					'png'          => 'image/png',
				);

				// Front end support - shortcode, bbPress, etc
				if ( ! function_exists( 'wp_handle_upload' ) )
					require_once ABSPATH . 'wp-admin/includes/file.php';

			

				// Make user_id known to unique_filename_callback function
				$this->user_id_being_edited = $user_id; 
				$avatar = wp_handle_upload( $_FILES['basic-user-avatar'], array( 'mimes' => $mimes, 'test_form' => false, 'unique_filename_callback' => array( $this, 'unique_filename_callback' ) ) );

				// Handle failures
				if ( empty( $avatar['file'] ) ) {
					switch ( $avatar['error'] ) {
					case 'File type does not meet security guidelines. Try another.' :
						add_action( 'user_profile_update_errors', create_function( '$a', '$a->add("avatar_error",__("Please upload a valid image file for the avatar.","basic-user-avatars"));' ) );
						break;
					default :
						add_action( 'user_profile_update_errors', create_function( '$a', '$a->add("avatar_error","<strong>".__("There was an error uploading the avatar:","basic-user-avatars")."</strong> ' . esc_attr( $avatar['error'] ) . '");' ) );
					}
					return;
				}
				
				$imagedetails = $imagedetails = getimagesize($avatar['url']);
				$width = $imagedetails[0];
				$height = $imagedetails[1]; 
				if ($width > 250 && $height > 250 ) {
					wp_die(__('Yüklediğiniz görselin boyutu maksimum 250px genişiğinde ve maksimum 250px yüksekliğinde olmalıdır.', 'geo'));
					return;
				}
				
				// Delete old images if successful
				$this->avatar_delete( $user_id );
				
				update_user_meta( $user_id, 'basic_user_avatar', array( 'full' => $avatar['url'] ) );
			
				}
				else {
					wp_die(__('Yüklemeye çalıştığınız dosya uzantısı kabul edilmemektedir. Sadece jpg, jpeg ve png uzantılı dosya yükleyebilirsiniz.', 'geo'));
				}
			} elseif ( ! empty( $_POST['basic-user-avatar-erase'] ) ) {
				
			// Nuke the current avatar
			$this->avatar_delete( $user_id );
			
			
			
			}
	}

	/**
	 * Enable avatar management on the frontend via this shortocde.
	 *
	 * @since 1.0.0
	 */
	function shortcode() {

		// Don't bother if the user isn't logged in
		if ( ! is_user_logged_in() )
			return;

		$user_id     = get_current_user_id();
		$profileuser = get_userdata( $user_id );

		if ( isset( $_POST['manage_avatar_submit'] ) ){
			$this->edit_user_profile_update( $user_id );
		}

		ob_start();
		?>
		<form id="basic-user-avatar-form" action="<?php the_permalink(); ?>" method="post" enctype="multipart/form-data">
			<?php
			echo get_avatar( $profileuser->ID );

			$options = get_option( 'basic_user_avatars_caps' );
			if ( empty( $options['basic_user_avatars_caps'] ) || current_user_can( 'upload_files' ) ) {
				// Nonce security ftw
				wp_nonce_field( 'basic_user_avatar_nonce', '_basic_user_avatar_nonce', false );
				
				// File upload input
				echo '<p><input type="file" name="basic-user-avatar" id="basic-local-avatar" /></p>';

				if ( empty( $profileuser->basic_user_avatar ) ) {
					echo '<p class="description">' . __( 'No local avatar is set. Use the upload field to add a local avatar.', 'geo' ) . '</p>';
				} else {
					echo '<input type="checkbox" name="basic-user-avatar-erase" value="1" /> ' . __( 'Delete local avatar', 'geo' ) . '<br />';
					echo '<p class="description">' . __( 'Replace the local avatar by uploading a new avatar, or erase the local avatar (falling back to a gravatar) by checking the delete option.', 'geo' ) . '</p>';
				}

			} else {
				if ( empty( $profileuser->basic_user_avatar ) ) {
					echo '<p class="description">' . __( 'No local avatar is set. Set up your avatar at Gravatar.com.', 'geo' ) . '</p>';
				} else {
					echo '<p class="description">' . __( 'You do not have media management permissions. To change your local avatar, contact the site administrator.', 'geo' ) . '</p>';
				}	
			}
			?>
			<input type="submit" name="manage_avatar_submit" value="<?php _e( 'Update Avatar', 'geo' ); ?>" />
		</form>
		<?php
		return ob_get_clean();
	}

	/**
	 * Form to display on the bbPress user profile edit screen
	 *
	 * @since 1.0.0
	 */
	public function bbpress_user_profile() {

		if ( !bbp_is_user_home_edit() )
			return;

		$user_id     = get_current_user_id();
		$profileuser = get_userdata( $user_id );

		echo '<div>';
			echo '<label for="basic-local-avatar">' . __( 'Avatar', 'geo' ) . '</label>';
 			echo '<fieldset class="bbp-form avatar">';

	 			echo get_avatar( $profileuser->ID );
				$options = get_option( 'basic_user_avatars_caps' );
				if ( empty( $options['basic_user_avatars_caps'] ) || current_user_can( 'upload_files' ) ) {
					// Nonce security ftw
					wp_nonce_field( 'basic_user_avatar_nonce', '_basic_user_avatar_nonce', false );
					
					// File upload input
					echo '<br /><input type="file" name="basic-user-avatar" id="basic-local-avatar" /><br />';

					if ( empty( $profileuser->basic_user_avatar ) ) {
						echo '<span class="description" style="margin-left:0;">' . __( 'No local avatar is set. Use the upload field to add a local avatar.', 'geo' ) . '</span>';
					} else {
						echo '<input type="checkbox" name="basic-user-avatar-erase" value="1" style="width:auto" /> ' . __( 'Delete local avatar', 'geo' ) . '<br />';
						echo '<span class="description" style="margin-left:0;">' . __( 'Replace the local avatar by uploading a new avatar, or erase the local avatar (falling back to a gravatar) by checking the delete option.', 'geo' ) . '</span>';
					}

				} else {
					if ( empty( $profileuser->basic_user_avatar ) ) {
						echo '<span class="description" style="margin-left:0;">' . __( 'No local avatar is set. Set up your avatar at Gravatar.com.', 'geo' ) . '</span>';
					} else {
						echo '<span class="description" style="margin-left:0;">' . __( 'You do not have media management permissions. To change your local avatar, contact the site administrator.', 'geo' ) . '</span>';
					}	
				}

			echo '</fieldset>';
		echo '</div>';
		?>
		<script type="text/javascript">var form = document.getElementById('bbp-your-profile');form.encoding = 'multipart/form-data';form.setAttribute('enctype', 'multipart/form-data');</script>
		<?php
	}

	/**
	 * Remove the custom get_avatar hook for the default avatar list output on 
	 * the Discussion Settings page.
	 *
	 * @since 1.0.0
	 * @param array $avatar_defaults
	 * @return array
	 */
	public function avatar_defaults( $avatar_defaults ) {
		remove_action( 'get_avatar', array( $this, 'get_avatar' ) );
		return $avatar_defaults;
	}

	/**
	 * Delete avatars based on user_id
	 *
	 * @since 1.0.0
	 * @param int $user_id
	 */
	public function avatar_delete( $user_id ) {
		$old_avatars = get_user_meta( $user_id, 'basic_user_avatar', true );
		$upload_path = wp_upload_dir();

		if ( is_array( $old_avatars ) ) {
			foreach ( $old_avatars as $old_avatar ) {
				$old_avatar_path = str_replace( $upload_path['baseurl'], $upload_path['basedir'], $old_avatar );
				@unlink( $old_avatar_path );
			}
		}

		delete_user_meta( $user_id, 'basic_user_avatar' );
	}

	/**
	 * File names are magic
	 *
	 * @since 1.0.0
	 * @param string $dir
	 * @param string $name
	 * @param string $ext
	 * @return string
	 */
	public function unique_filename_callback( $dir, $name, $ext ) {
		$user = get_user_by( 'id', (int) $this->user_id_being_edited );
		$name = $base_name = sanitize_file_name( $user->display_name . '_avatar' );
		$number = 1;

		while ( file_exists( $dir . "/$name$ext" ) ) {
			$name = $base_name . '_' . $number;
			$number++;
		}

		return $name . $ext;
	}
}
$basic_user_avatars = new basic_user_avatars;

/**
 * During uninstallation, remove the custom field from the users and delete the local avatars
 *
 * @since 1.0.0
 */
function basic_user_avatars_uninstall() {
	$basic_user_avatars = new basic_user_avatars;
	$users = get_users_of_blog();

	foreach ( $users as $user )
		$basic_user_avatars->avatar_delete( $user->user_id );

	delete_option( 'basic_user_avatars_caps' );
}
register_uninstall_hook( __FILE__, 'basic_user_avatars_uninstall' );



// Upload File
function upload_user_file( $file = array() ) {
	require_once( ABSPATH . 'wp-admin/includes/admin.php' );
			$mimes = array(
				'jpg|jpeg|jpe' => 'image/jpeg',
				'png'          => 'image/png',
			);
      $file_return = wp_handle_upload( $file, array('mimes' => $mimes, 'test_form' => false ) );
			
      if( isset( $file_return['error'] ) || isset( $file_return['upload_error_handler'] ) ) {
          return false;
      } else {
          $filename = $file_return['file'];
          $attachment = array(
              'post_mime_type' => $file_return['type'],
              'post_title' => preg_replace( '/\.[^.]+$/', '', basename( $filename ) ),
              'post_content' => '',
              'post_status' => 'inherit',
              'guid' => $file_return['url']
          );
          $attachment_id = wp_insert_attachment( $attachment, $file_return['file'] );
          require_once(ABSPATH . 'wp-admin/includes/image.php');
          $attachment_data = wp_generate_attachment_metadata( $attachment_id, $filename );
          wp_update_attachment_metadata( $attachment_id, $attachment_data );
          if( 0 < intval( $attachment_id ) ) {
          	return $attachment_id;
          }
      }
      return false;
}

/*-----------------------------------------------------------------------------------*/
# Emojileri Kaldır
/*-----------------------------------------------------------------------------------*/
function disable_emojis() {
	if(!is_singular()) {
		remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
	}
}
add_action( 'init', 'disable_emojis' );

/*-----------------------------------------------------------------------------------*/
# Filter: Navigation Markup Template
/*-----------------------------------------------------------------------------------*/
function change_reader_heading( $template, $class ) {

    $template = str_replace( 'h2', 'div', $template );

    return $template;
}
add_filter( 'navigation_markup_template', 'change_reader_heading', 10, 2 );

/*-----------------------------------------------------------------------------------*/
# Js Minifier
/*-----------------------------------------------------------------------------------*/
function geoit_minify_js($input) {
    if(trim($input) === "") return $input;
    return preg_replace(
        array(
            // Remove comment(s)
            '#\s*("(?:[^"\\\]++|\\\.)*+"|\'(?:[^\'\\\\]++|\\\.)*+\')\s*|\s*\/\*(?!\!|@cc_on)(?>[\s\S]*?\*\/)\s*|\s*(?<![\:\=])\/\/.*(?=[\n\r]|$)|^\s*|\s*$#',
            // Remove white-space(s) outside the string and regex
            '#("(?:[^"\\\]++|\\\.)*+"|\'(?:[^\'\\\\]++|\\\.)*+\'|\/\*(?>.*?\*\/)|\/(?!\/)[^\n\r]*?\/(?=[\s.,;]|[gimuy]|$))|\s*([!%&*\(\)\-=+\[\]\{\}|;:,.<>?\/])\s*#s',
            // Remove the last semicolon
            '#;+\}#',
            // Minify object attribute(s) except JSON attribute(s). From `{'foo':'bar'}` to `{foo:'bar'}`
            '#([\{,])([\'])(\d+|[a-z_][a-z0-9_]*)\2(?=\:)#i',
            // --ibid. From `foo['bar']` to `foo.bar`
            '#([a-z0-9_\)\]])\[([\'"])([a-z_][a-z0-9_]*)\2\]#i'
        ),
        array(
            '$1',
            '$1$2',
            '}',
            '$1$3',
            '$1.$3'
        ),
    $input);
}

/*-----------------------------------------------------------------------------------*/
# Panel Çubuğunun Durumu
/*-----------------------------------------------------------------------------------*/
add_action('after_setup_theme', 'remove_admin_bar');
if ( ! function_exists( 'remove_admin_bar' ) ) {
	function remove_admin_bar() {
		if (ot_get_option('geo_admin_bar') != 'off' ) {
			if (!current_user_can('administrator') && !is_admin()) {
				show_admin_bar(false);
			}
		}
		if (ot_get_option('geo_admin_bar_2') != 'off' ) {
			if (current_user_can('administrator') && !is_admin()) {
				show_admin_bar(false);
			}
		}
	}
}

/*-----------------------------------------------------------------------------------*/
# Recaptcha #bws_google_captcha
/*-----------------------------------------------------------------------------------*/
add_filter('login_form_middle','geoit_recaptcha_login');
function geoit_recaptcha_login(){
	$opt = get_option( 'gglcptch_options' );
	if ($opt['login_form'] == 1 && $opt['keys_verified'] == 1 ) {
		$shortcode = do_shortcode('[bws_google_captcha]');
		if ($shortcode != '[bws_google_captcha]') {
			return $shortcode;
		}
	}
}

function geoit_recaptcha($what){
	$opt = get_option( 'gglcptch_options' );
	// print_r($opt);
	if ($opt[$what] == 1 && $opt['keys_verified'] == 1 ) {
		$shortcode = do_shortcode('[bws_google_captcha]');
		if ($shortcode != '[bws_google_captcha]') {
			return $shortcode;
		}
	}
}

/*-----------------------------------------------------------------------------------*/
# Gizli İçerik
/*-----------------------------------------------------------------------------------*/
add_filter( 'the_content', 'geoit_private_post_content', 1 );
function geoit_private_post_content($content) {
	$meta = get_post_meta( get_the_ID(), 'geoit_private_post', true );
	$author = get_post_field ('post_author', get_the_ID());
	$user = get_current_user_id();
	
	if($author == $user)
	return $content;
	
	if( $meta != 'on' || get_the_author_meta('verified_user', $user) == 'yes' )
	return $content;

	$out = '...<div class="geo-private-read-more"></div><div class="geo-private-post"><div class="geo-private-post-inner">
	<h2>'. esc_html__( 'Bu yazı onaylı üyelerimiz için hazırlanmıştır.', 'geo' ) .'</h2>';
	if(!is_user_logged_in()) {
	$out .= '<p>'. esc_html__( 'İlgili içeriğin devamını okuyabilmek için onaylı üye olmalı veya zaten onaylı üye iseniz giriş yapmalısınız.', 'geo' ) .'</p>
	<button data-toggle="geoit-login" class="uckan-btn uckan-btn--red">'.esc_html__( 'Giriş Yap', 'geo' ).'</button>';
	if(ot_get_option('geo-onay') != '')
		$out .= '<a href="'.get_page_link(ot_get_option('geo-onay')).'" class="uckan-btn uckan-btn--green">'.esc_html__( 'Onaylı Üyelik Nedir?', 'geo' ).'</a>';
	} else {
		$out .= '<p>'. esc_html__( 'İlgili içeriğin devamını okuyabilmek için onaylı üye olmalısınız.', 'geo' ) .'</p>';
		if(ot_get_option('geo-onay') != '')
		$out .= '<a href="'.get_page_link(ot_get_option('geo-onay')).'" class="uckan-btn uckan-btn--colored">'.esc_html__( 'Onaylı Üyelik Nedir?', 'geo' ).'</a>';
	}
	$out .= '</div></div>';

	return wp_trim_words( get_the_content(), 40, $out);
}