<?php 
function custom_meta_boxes() { 
	
	// Page
	$geoit_page_metabox = array( 
		'id' => 'geoit_page_metabox',
		'title'       => __( 'Sayfa Ayarları', 'geo-admin' ),
		'pages'       => array( 'page' ),
		'context'     => 'normal',
		'priority'    => 'high',
		'fields'      => array(
			array(
				'label'       => __( 'Bu Sayfa İçin Özel Bileşen Alanı Oluşturun', 'geo-admin' ),
				'desc'       => __( 'Sayfa şablonu olarak "Özel Sidebar" şablonlarından bir tanesini seçmelisiniz. Daha sonra bu sayfa için görünüm>bileşenler sayfasında bu sayfa için oluşturulan sidebarlara bileşenleri ekleyebilirsiniz.', 'geo-admin' ),
				'id'          => 'page_sidebar_status',
				'std'					=> 'off',
				'type'				=> 'on-off',
			),
		),
	);
	
$my_meta_box = array( 
	'id' => 'my_meta_box',
    'title'       => __( 'Geoit Ayarları', 'geo' ),
    'pages'       => array( 'post' ),
    'context'     => 'normal',
    'priority'    => 'high',
    'fields'      => array(
			
			// General
			array(
        'label'       => __( 'Genel Ayarlar', 'geo' ),
        'id'          => 'post_general',
        'type'        => 'tab'
      ),
			array(
				'label'       => __( 'Sınırlandırılmış İçerik', 'geo-admin' ),
				'desc'        => 'On durumunda ilgili yazıyı sadece sahibi ve onaylı üyeler görüntüleyebilir.',
				'id'          => 'geoit_private_post',
				'std'					=> 'off',
				'type'				=> 'on-off',
			),
			array(
				'label'       => __( 'Trendlere Ekle', 'geo-admin' ),
				'id'          => 'geoit_post_trending',
				'std'					=> 'off',
				'type'				=> 'on-off',
			),
			array(
				'label'       => __( 'Öne Çıkarılan Görsel', 'geo-admin' ),
				'id'          => 'post_show_featured_image',
				'std'					=> 'on',
				'type'				=> 'on-off',
			),
			array(
				'label'       => __( 'Reaksiyon Butonları', 'geo-admin' ),
				'id'          => 'geo_reaction_enable',
				'std'					=> 'on',
				'type'				=> 'on-off',
			),
			array(
				'id'		=> 'post_meta_position',
				'label'		=>  __( 'Yazı Detaylarının Konumu', 'geo-admin' ),
				'std'		=> 'above',
				'type'		=> 'select',
				'choices'	=> array(
					array(
						'value'		=> 'above',
						'label'		=> __('Öne Çıkan Görselin Üstünde', 'geo-admin'),
					),
					array(
						'value'		=> 'under',
						'label'		=> __('Öne Çıkan Görselin Altında', 'geo-admin'),
					),
				)
			),
			array(
				'label' => __('Yazının Alt Başlığı', 'geo-admin'),
				'desc'	=> __('Yazı sayfasında başlığın hemen altında gözükür.', 'geo-admin'),
				'id'          => 'geo_post_desc',
				'type'        => 'textarea',
				'rows'        => '2',
			),
			array(
				'id'		=> 'geo_post_source',
				'label'		=> __( 'Yazı Kaynağı', 'geo-admin' ),
				'type'		=> 'list-item',
				'settings'	=> array(
					array(
						'id'		=> 'link',
						'label'		=>  __( 'Link', 'geo-admin' ),
						'type'        => 'textarea',
						'rows'        => '1',
						'choices'	=> array()
					),
					array(
						'label'       => __( 'Yeni Sekmede Aç', 'geo-admin' ),
						'id'          => 'new_tab',
						'std'					=> 'off',
						'type'				=> 'on-off',
					),
					array(
						'label'       => __( 'NoFollow', 'geo-admin' ),
						'id'          => 'nofollow',
						'std'					=> 'off',
						'type'				=> 'on-off',
					),
					array(
						'label'       => __( 'Sponsored', 'geo-admin' ),
						'id'          => 'sponsored',
						'std'					=> 'off',
						'type'				=> 'on-off',
					),
				)
			),
			
			// Video Gallary
			array(
        'label'       => __( 'Video Galeri', 'geo' ),
        'id'          => 'post_video',
        'type'        => 'tab'
      ),
			array(
				'label' => __('Video Embed Kodu', 'geo-admin'),
				'desc'	=> __('Videolara özel sayfayı kullanmak için sağ üst bölümden video formatını seçmeyi unutmayın.', 'geo-admin'),
				'id'          => 'geo_video_url',
				'type'        => 'textarea',
				'rows'        => '2',
			),
			
			// Image Gallary
			array(
        'label'       => __( 'Foto Galeri', 'geo' ),
        'id'          => 'post_image',
        'type'        => 'tab'
      ),
			array(
				'label' 			=> __('Galeri Sayfa Açıklaması', 'geo-admin'),
				'desc'				=> __('Eğer yazı formatı galeri olarak seçiliyse galeri hakkında kısa bir açıklama yapabilirsiniz.', 'geo-admin'),
				'id'          => 'geo_gallery_desc',
				'type'        => 'textarea',
				'rows'        => '2',
			),
			
			// Review
			array(
        'label'       => __( 'İnceleme', 'geo' ),
        'id'          => 'post_review',
        'type'        => 'tab'
      ),
			array(
				'label'       => __( 'İnceleme Sistemi', 'geo-admin' ),
				'id'          => 'geo_enable_review',
				'std'					=> 'off',
				'type'				=> 'on-off',
			),
			array(
				'id'		=> 'geo_review_position',
				'label'		=> __( 'İnceleme Kutusunun Pozisyonu', 'geo-admin' ),
				'desc'		=> __( 'Kutu içeriklerinin kenarlığını değiştirir. ', 'geo-admin' ),
				'std'		=> 'shadow',
				'type'		=> 'select',
				'section'	=> 'general',
				'choices'     => array(
				  array(
					'value'       => 'top',
					'label'       => __( 'Yazının Üstünde', 'geo-admin' ),
					'src'         => ''
				  ),
				  array(
					'value'       => 'bottom',
					'label'       => __( 'Yazının Altında', 'geo-admin' ),
					'src'         => ''
				  ),
				)
			),
			array(
				'label' 			=> __('İnceleme Görseli', 'geo-admin'),
				'id'          => 'geo_review_box_thumb',
				'type'        => 'upload'
			),
			array(
				'label' 			=> __('İnceleme Başlığı', 'geo-admin'),
				'id'          => 'geo_review_box_title',
				'type'        => 'text',
				'rows'        => '1',
			),
			array(
				'label' => __('İnceleme Açıklaması', 'geo-admin'),
				'id'    => 'geo_review_summary',
				'type'  => 'text',
				'rows'  => '4',
			),
			array(
				'id'		   => 'geo_rating_criteria',
				'label'		 => __( 'İnceleme Kriterleri', 'geo-admin' ),
				'type'		 => 'list-item',
				'settings' => array(
					array(
						'id'					 => 'score',
						'label'				 =>  __( 'Değer', 'geo-admin' ),
						'type'				 => 'numeric-slider',
						'min_max_step' => '1,10,0.1',
						'choices'	     => array()
					),
				)
			),
			
			
			
			// Recipe 
			array(
        'label'       => __( 'Yemek Tarifi', 'geo' ),
        'id'          => 'post_recipe',
        'type'        => 'tab'
      ),
			
			array(
				'label' => __('Başlık', 'geo-admin'),
				'id'          => 'geo_recipe_title',
				'type'        => 'text',
				'rows'        => '1',
			),
			array(
				'label' 			=> __('Açıklama', 'geo-admin'),
				'id'          => 'geo_recipe_esc',
				'type'        => 'textarea',
				'rows'        => '2',
			),
			array(
				'label' 			=> __('Anahtar Kelime', 'geo-admin'),
				'id'          => 'geo_recipe_keywords',
				'type'        => 'textarea',
				'desc'        => __('Virgül ile ayırın', 'geo'),
				'rows'        => '1',
			),
			array(
				'label' 			=> __('Kategori', 'geo-admin'),
				'id'          => 'geo_recipe_cat',
				'type'        => 'textarea',
				'desc'        => __('Virgül ile ayırın', 'geo'),
				'rows'        => '1',
			),
			array(
				'label' 			=> __('Yöre', 'geo-admin'),
				'id'          => 'geo_recipe_cuisine',
				'type'        => 'textarea',
				'desc'        => __('Virgül ile ayırın', 'geo'),
				'rows'        => '1',
			),
			array(
				'label' 			=> __('Kaç Kişilik', 'geo-admin'),
				'id'          => 'geo_recipe_servings',
				'type'        => 'text',
				'rows'        => '1',
			),
			array(
				'label' 			=> __('Hazırlık Süresi', 'geo-admin'),
				'id'          => 'geo_recipe_prep_time',
				'type'        => 'text',
				'rows'        => '1',
			),
			array(
				'label' 			=> __('Hazırlık Süresi (İşaretleme)', 'geo-admin'),
				'id'          => 'geo_recipe_prep_time_schema',
				'type'        => 'text',
				'desc'        => '1 saatse PT1H, 30 dakika ise PT30M yazın, 1 saat 30 dakika ise PT1H30M yazın yani PT sabit yanındaki rakam süre yanındaki harf ise süre cinsi. h(ours), m(inutes), s(econds)',
				'rows'        => '1',
			),
			array(
				'label' 			=> __('Pişirme Süresi', 'geo-admin'),
				'id'          => 'geo_recipe_cook_time',
				'type'        => 'text',
				'rows'        => '1',
			),
			array(
				'label' 			=> __('Pişirme Süresi (İşaretleme)', 'geo-admin'),
				'id'          => 'geo_recipe_cook_time_schema',
				'type'        => 'text',
				'desc'        => '1 saatse PT1H, 30 dakika ise PT30M yazın yani PT sabit yanındaki rakam süre yanındaki harf ise süre cinsi. h(ours), m(inutes), s(econds)',
				'rows'        => '1',
			),
			array(
				'label' 			=> __('Toplam Süre (İşaretleme)', 'geo-admin'),
				'id'          => 'geo_recipe_prep_totaltime',
				'type'        => 'text',
				'desc'        => '1 saatse PT1H, 30 dakika ise PT30M yazın yani PT sabit yanındaki rakam süre yanındaki harf ise süre cinsi. h(ours), m(inutes), s(econds)',
				'rows'        => '1',
			),
			array(
				'id'		=> 'geo_recipe_ingredients',
				'label'		=> __( 'Malzemeler', 'geo-admin' ),
				'type'		=> 'list-item',
				'settings'	=> array(
					array(
						'id'		=> 'ingredient',
						'type'		=> 'sdsds',
						'choices'	=> array()
					),
				),
				'choices'	=> array(),
			),
			array(
				'id'		=> 'geo_recipe_instructions',
				'label'		=> __( 'Hazırlanış', 'geo-admin' ),
				'type'		=> 'list-item',
				'settings'	=> array(
					array(
						'id'		=> 'desc',
						'label'		=>  __( 'Açıklama', 'geo-admin' ),
						'type'        => 'textarea',
						'rows'        => '2',
						'choices'	=> array()
					),
					array(
						'id'		=> 'image',
						'label'		=>  __( 'Görsel', 'geo-admin' ),
						'type'		=> 'upload',
						'choices'	=> array()
					),
				)
			),
			array(
				'id'		=> 'geo_recipe_nutritional_inf',
				'label'		=> __( 'Beslenme Bilgileri', 'geo-admin' ),
				'type'		=> 'list-item',
				'settings'	=> array(
					array(
						'id'		=> 'value',
						'label'		=>  __( 'Değer', 'geo-admin' ),
						'type'		=> 'text',
						'choices'	=> array()
					),
					array(
						'id'		=> 'type',
						'label'		=> __( 'Tip', 'geo-admin' ),
						'std'		=> '',
						'type'		=> 'select',
						'choices'     => array(
							array(
							'value'       => '',
							'label'       => __( 'Diğer', 'geo-admin' )
							),
							array(
							'value'       => 'calories',
							'label'       => __( 'Kalori Sayısı', 'geo-admin' )
							),
							array(
							'value'       => 'carbohydrateContent',
							'label'       => __( 'Gram Karbonhidrat Sayısı', 'geo-admin' )
							),
							array(
							'value'       => 'cholesterolContent',
							'label'       => __( 'Miligram Kolestrol Sayısı', 'geo-admin' )
							),
							array(
							'value'       => 'fatContent',
							'label'       => __( 'Gram Yağ Sayısı', 'geo-admin' )
							),
							array(
							'value'       => 'fiberContent',
							'label'       => __( 'Gram Lif Sayısı', 'geo-admin' )
							),
							array(
							'value'       => 'proteinContent',
							'label'       => __( 'Gram Protein Sayısı', 'geo-admin' )
							),
							array(
							'value'       => 'saturatedFatContent',
							'label'       => __( 'Doymuş Yağın Gram Sayısı', 'geo-admin' )
							),
							array(
							'value'       => 'servingSize',
							'label'       => __( 'Kütle Sayısı Cinsinden Porsiyon Büyüklüğü', 'geo-admin' )
							),
							array(
							'value'       => 'sodiumContent',
							'label'       => __( 'Miligram Sodyum Sayısı', 'geo-admin' )
							),
							array(
							'value'       => 'sugarContent',
							'label'       => __( 'Gram Şeker Sayısı', 'geo-admin' )
							),
							array(
							'value'       => 'transFatContent',
							'label'       => __( 'Gram Trans Yağ Sayısı', 'geo-admin' )
							),
							array(
							'value'       => 'unsaturatedFatContent',
							'label'       => __( 'Doymamış Yağların Gram Sayısı', 'geo-admin' )
							),
						)
					),
				)
			),
			
		)
	);
	

  if ( function_exists( 'ot_register_meta_box' ) ) {
    ot_register_meta_box( $geoit_page_metabox );
    ot_register_meta_box( $my_meta_box );
  }
}
add_action( 'admin_init', 'custom_meta_boxes' );