<?php

/*-----------------------------------------------------------------------------------*/
# Included
/*-----------------------------------------------------------------------------------*/
require_once(get_template_directory().'/frameworks/category-images.php');
require_once(get_template_directory().'/frameworks/recipe.php');

/*-----------------------------------------------------------------------------------*/
# Empty p remove
/*-----------------------------------------------------------------------------------*/
add_filter('the_content', 'remove_empty_p', 20, 1);
function remove_empty_p($content){
    $content = force_balance_tags($content);
    return preg_replace('#<p>\s*+(<br\s*/*>)?\s*</p>#i', '', $content);
}

/*-----------------------------------------------------------------------------------*/
# Lazy Load for entry images
/*-----------------------------------------------------------------------------------*/

function add_image_placeholders( $content ) {
	// Don't lazyload for feeds, previews, mobile
	if( is_feed() || is_preview() || !is_singular() || ot_get_option('geoit_lazy_images') != 'on' || (function_exists( 'is_amp_page' ) && is_amp_page()) || ( function_exists( 'is_amp_endpoint' ) && is_amp_endpoint()))
		return $content;

	// Don't lazy-load if the content has already been run through previously
	if ( false !== strpos( $content, 'data-src' ) )
		return $content;

	// In case you want to change the placeholder image
	$placeholder_image = apply_filters( 'lazyload_images_placeholder_image', 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAQAAAACCAQAAADVobXoAAAADklEQVR42mNkgAJGGAMAAC0AAyZYT1MAAAAASUVORK5CYII=' );

	// This is a pretty simple regex, but it works
	$content = preg_replace( '#<img([^>]+?)src=[\'"]?([^\'"\s>]+)[\'"]?([^>]*)>#', sprintf( '<img${1}src="%s" data-src="${2}"${3}><noscript><img${1}src="${2}"${3}></noscript>', $placeholder_image ), $content );
	$content = str_replace('srcset="', 'data-srcset="', $content); 
	
	return $content;
}
add_filter( 'the_content', 'add_image_placeholders', 99 );

/*-----------------------------------------------------------------------------------*/
# Lazy load for featured images
/*-----------------------------------------------------------------------------------*/
add_filter( 'wp_get_attachment_image_attributes', 'wpse8170_add_lazyload_to_attachment_image', 10, 2 );
function wpse8170_add_lazyload_to_attachment_image( $attr, $attachment ) {
	if( is_admin() || is_preview() || ot_get_option('geoit_lazy_images') != 'on' || (function_exists( 'is_amp_page' ) && is_amp_page()) || ( function_exists( 'is_amp_endpoint' ) && is_amp_endpoint())) {
		return $attr;
	}
	$attr['class'] .= ' geo-lazy';  
	$attr['data-src'] = $attr['src'];
	if (!empty($attr['srcset'])) {
		$attr['data-srcset'] = $attr['srcset'];
	}

	$attr['src'] = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAQAAAACCAQAAADVobXoAAAADklEQVR42mNkgAJGGAMAAC0AAyZYT1MAAAAASUVORK5CYII=';
	
	if (!empty($attr['data-srcset'])) {
		$attr['srcset'] = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAQAAAACCAQAAADVobXoAAAADklEQVR42mNkgAJGGAMAAC0AAyZYT1MAAAAASUVORK5CYII= 850w';
	}
  return $attr;
}

/*-----------------------------------------------------------------------------------*/
# The thumbnails add alt tag
/*-----------------------------------------------------------------------------------*/
function isa_add_img_title( $attr, $attachment = null ) {
	if (empty($attr['alt'])) {
		$img_title = trim( strip_tags( $attachment->post_title ) );
		$attr['alt'] = $img_title;
	}
    return $attr;
}
add_filter( 'wp_get_attachment_image_attributes','isa_add_img_title', 10, 2 );


/*-----------------------------------------------------------------------------------*/
# Page Sidebars
/*-----------------------------------------------------------------------------------*/
function geoit_add_sidebar() {
	
	$style = ot_get_option('block_title_style');
	$class = 'block_title_'.$style;
	
	// Page custom sidebar
	wp_reset_query();
	$query = new WP_Query( array(
		'post_type'  => 'any',
		'meta_key'   => '_wp_page_template',
		'meta_value' => 'temp/custom-sidebar.php'
	) );
	
	if ( $query->have_posts() ) {
		while ( $query->have_posts() ) : $query->the_post(); global $post;
			$sidebar = get_post_meta($post->ID, 'page_sidebar_status', true);
			if ($sidebar == 'on') {
				register_sidebar(array(
					'name' => $post->post_title.': Sağ Sidebar',
					'description' => $post->post_title.' sayfasının sağ sidebarı.',
					'id' => 'custom-sidebar-'.$post->ID,
					'before_widget' => '<aside id="%1$s" class="widget widget-0 %2$s">',
					'after_widget' => '</aside>',
					'before_title' => '<div class="content__title '.$class.'"><h4 class="uckan-btn">',
					'after_title' => '</h4></div>',
				));
			}
		endwhile;
	}
	wp_reset_query();
	
	// Homepage
	wp_reset_query();
	$query = new WP_Query( array(
		'post_type'  => 'any',
		'meta_key'   => '_wp_page_template',
		'meta_value' => array(
			'temp/custom-homepage.php',
		)
	) );
	
	if ( $query->have_posts() ) {
		while ( $query->have_posts() ) : $query->the_post(); global $post;
			$sidebar = get_post_meta($post->ID, 'page_sidebar_status', true);
			if ($sidebar == 'on') {
				register_sidebar(array(
					'name' => $post->post_title.': Sağ Sidebar',
					'description' => $post->post_title.' sayfasının sağ sidebarı.',
					'id' => 'custom-sidebar-'.$post->ID,
					'before_widget' => '<aside id="%1$s" class="widget widget-0 %2$s">',
					'after_widget' => '</aside>',
					'before_title' => '<div class="content__title '.$class.'"><h4 class="uckan-btn">',
					'after_title' => '</h4></div>',
				));
				register_sidebar(array(
					'name' => $post->post_title.': Homepage',
					'description' => $post->post_title.' sayfasının sol bileşen alanı.',
					'id' => 'custom-homepage-'.$post->ID,
					'before_widget' => '<aside class="widget widget-homepage %2$s">',
					'after_widget' => '</aside>',
					'before_title' => '<div class="content__title '.$class.'"><h3 class="uckan-btn">',
					'after_title' => '</h3></div>',
				));
				register_sidebar(array(
					'name' => $post->post_title.': Homepage Full Width',
					'description' => $post->post_title.' sayfasının tam genişlikli bileşen alanı.',
					'id' => 'custom-homepage-full-'.$post->ID,
					'before_widget' => '<aside class="widget widget-homepage widget-full-width %2$s">',
					'after_widget' => '</aside>',
					'before_title' => '<div class="content__title '.$class.'"><h3 class="uckan-btn">',
					'after_title' => '</h3></div>',
				));
			}
		endwhile;
	}
	wp_reset_query();

}
add_action( 'widgets_init', 'geoit_add_sidebar' );


/*-----------------------------------------------------------------------------------*/
# Popup
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_popup' ) ) {
	function geoit_popup() {
		$cookie = ot_get_option('geo_popup_box');
		$ad = ot_get_option('geo-6-ads');
		$ad2 = ot_get_option('geo-6-ads-mobile');
		if ($cookie == 'on'): ?>
			<?php if(is_active_sidebar('popup')):?>
			<div id="popup-box">
				<div id="popup-box-content">
					<i class="fa fa-close" id="popup-close"></i>
					<?php dynamic_sidebar( 'popup' ); ?>
				</div>
			</div>
		<?php endif;
		endif; 
		if(geo_is_mobile()) {
			if ($ad2 != '') {
				echo '<div class="geoit_popup_ade">';
					echo '<div class="geoit_popup_wrapper">';
						echo '<i class="fa fa-close" id="popup-close"></i>';
						echo $ad2;
					echo '</div>';
				echo '</div>';
			}
		} else {
			if ($ad != '') {
				echo '<div class="geoit_popup_ade">';
					echo '<div class="geoit_popup_wrapper">';
						echo '<i class="fa fa-close" id="popup-close"></i>';
						echo $ad;
					echo '</div>';
				echo '</div>';
			}
		}
	}
}

/*-----------------------------------------------------------------------------------*/
# Çerez Bildirimi
/*-----------------------------------------------------------------------------------*/
add_action('wp_footer', 'geoit_cookie');
if ( ! function_exists( 'geoit_cookie' ) ) {
	function geoit_cookie() {
		$cookie = ot_get_option('geo_cookie_box');
		if ($cookie == 'on'): ?>
		<div id="cookie-box">
        <div id="cookie-box-content">
            <p><?php _e('Bu web sitesinde en iyi deneyimi yaşamanızı sağlamak için çerezler kullanılmaktadır.', 'geo'); ?></p>
				<a href="<?php echo get_page_link(ot_get_option('geo_cookie_page')); ?>" style="text-decoration: underline;"><?php _e('Detaylar', 'geo'); ?></a>
				<a onClick="purecookieDismiss();" class="uckan-btn colored"><?php _e('Kabul Ediyorum', 'geo'); ?></a>
        </div>
      </div>
		<?php endif; 
	}
}

/*-----------------------------------------------------------------------------------*/
# Adblock Engelleyicisi
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_adblock' ) ) {
	function geoit_adblock() { ?>
		<?php if (ot_get_option('adblock_detecter') == 'on') : ?>
		<div class="adblockalert">
		  <div class="adblockalert-content">
				<img width="62" height="62" src="data:image/svg+xml;base64,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" />
				<h3 class="adblockalert-content-title"><?php _e('Adblock Kullanıyorsunuz', 'geo'); ?></h3>
				<?php echo do_shortcode(''.ot_get_option('adblock_text').''); ?>
				<a href="<?php home_url( $wp->request ); ?>" class="uckan-btn uckan-btn--block uckan-btn--red"><?php _e('Kapattım', 'geo'); ?></a>
		  </div>
		</div>
		<script>
		!function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t:e.adblock=t()}(this,function(){"use strict";var e={},t=function(){var e=document.createElement("div");return e.id="adcontent",document.body.appendChild(e),e};return e.check=function(e,n){var o=t();setTimeout(function(){var t=0===o.offsetLeft&&0===o.offsetTop;e(t)},n||1e3)},e});
		jQuery(function ($) {
		var enabled = document.querySelector('.adblockalert');

		adblock.check(function (active) {
			if (active) {
				$('body').addClass('ad_block_detected');
				enabled.style.display = 'block';
			}
		}, 1000);
		});
		</script>
		<?php else:
			return false;
		endif; ?>
	<?php }
}
add_action ('wp_footer', 'geoit_adblock');


/*-----------------------------------------------------------------------------------*/
# Çerez Bildirimi
/*-----------------------------------------------------------------------------------*/
// add_action('wp_footer', 'geo_cookie_bar');q
if ( ! function_exists( 'geo_cookie_bar' ) ) {
	function geo_cookie_bar() {
		$cookie = ot_get_option('footer-cookie');
			echo '<div id=""eu-cookie-law" class="cookie-wrapper cookie hidden widget_eu_cookie_law_widget">';
				echo '<div class="hide-on-button">';
				echo 'Denemeler cookie bildirimi.';
				echo '</div>';
				echo '<button id="closeCookie" class="cookie_close accept"><i class="fa fa-times"></i></button>';
			echo '</div>';
	}
}


/*-----------------------------------------------------------------------------------*/
# Slider&Carousel
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_featured' ) ) {
	function geoit_featured() {
		if(is_category())
			$select = ot_get_option( 'slider_select_cat' );
		else
			$select = ot_get_option( 'slider_select' );
		Switch ($select){
			case 'slider-style1':
				get_template_part('frameworks/template-parts/slider/carousel');
				break;
			case 'slider-style4':
				get_template_part('frameworks/template-parts/slider/carousel-2');
				break;
			case 'slider-style2':
				get_template_part('frameworks/template-parts/slider/slider');
				break;
			case 'slider-style3':
				get_template_part('frameworks/template-parts/slider/slider-2');
				break;
			case 'slider-style5':
				get_template_part('frameworks/template-parts/slider/slider-3');
				break;
			case 'slider-style6':
				get_template_part('frameworks/template-parts/slider/carousel-3');
				break;
			case 'slider-style7':
				get_template_part('frameworks/template-parts/slider/slider-4');
				break;
			case 'slider-style8':
				get_template_part('frameworks/template-parts/slider/carousel-4');
				break;
			case 'slider-style9':
				get_template_part('frameworks/template-parts/slider/carousel-5');
				break;
			case 'slider-style10':
				get_template_part('frameworks/template-parts/slider/carousel-6');
				break;
			case 'slider-style11':
				get_template_part('frameworks/template-parts/slider/carousel-7');
				break;
	 }
	}
}

/*-----------------------------------------------------------------------------------*/
# Yazıya Puan Ekle
/*-----------------------------------------------------------------------------------*/

add_action( 'transition_post_status', function ( $new_status, $old_status, $post )
{

    if( 'publish' == $new_status && 'publish' != $old_status ) {

      $author = $post->post_author;
			$points = get_user_meta( $author, 'geo_user_points', true );
			$points += ot_get_option('geo_puan_yazi');
			update_user_meta( $author, 'geo_user_points', $points); 

    }
}, 10, 3 );

/*-----------------------------------------------------------------------------------*/
# Yoruma Puan Ekle
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'comment_published_add_points' ) ) {
	function comment_published_add_points( $comment_ID, $comment_approved ) {
		$comment = get_comment( $comment_ID );
		$comment_author_id = $comment -> user_id;
		$points = get_user_meta( $comment_author_id, 'geo_user_points', true );
		$points += ot_get_option('geo_puan_yorum');
		update_user_meta( $comment_author_id, 'geo_user_points', $points); 
	}
}
add_action( 'comment_post', 'comment_published_add_points', 10, 2 );

/*-----------------------------------------------------------------------------------*/
# Paragraf Arasına Reklam
/*-----------------------------------------------------------------------------------*/
add_filter( 'the_content', 'geo_single_ad' );

if ( ! function_exists( 'geo_single_ad' ) ) {
	function geo_single_ad( $content ) {
		$ad_code = ot_get_option('ad_single_aut');
		$ad_position = ot_get_option('sp_ad_position');
		if ( is_single() && ! is_admin() ) {
			if ($ad_code != '')
			return geo_single_ad_insert( '<div class="ad ad-single">'.$ad_code.'</div>', $ad_position, $content );
		} 
		return $content;
	}
}

if ( ! function_exists( 'geo_single_ad_insert' ) ) { 
	function geo_single_ad_insert( $insertion, $paragraph_id, $content ) {
		$closing_p = '</p>';
		$paragraphs = explode( $closing_p, $content );
		foreach ($paragraphs as $index => $paragraph) {
			if ( trim( $paragraph ) ) {
				$paragraphs[$index] .= $closing_p;
			}
			if ( $paragraph_id == $index + 1 ) {
				$paragraphs[$index] .= $insertion;
			}
		} 
		return implode( '', $paragraphs );
	}
}

/*-----------------------------------------------------------------------------------*/
# Son Yazı Bileşeni
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geo_recent_entries_standart' ) ) {
	function geo_recent_entries_standart($geo_query){
		global $post;
		$original_post = $post;
	?>
		<div class="uck-card-group">
			<?php if ($geo_query->have_posts()) :
				while($geo_query->have_posts()): $geo_query->the_post();?>
					<div class="uck-card--col_right">
						<?php if(has_post_thumbnail()): ?>
							<div class="uck-card--image">
								<a href='<?php the_permalink(); ?>' title='<?php the_title(); ?>'>
									<?php the_post_thumbnail('geo-small'); ?>
								</a>
								<?php echo get_simple_likes_button( get_the_ID() ); ?>
							</div>
						<?php endif; ?>
						<div class="uck-card--content">
							<?php the_title( sprintf( '<h3 class="headline truncate"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
							<span class="date"><i class="fa fa-clock-o"></i> <?php the_time('j M, Y'); ?></span>
							<?php geoit_trending_post(get_the_ID()); ?>
						</div>
					</div>
				<?php endwhile;?>
			<?php else: ?>
				<div style="padding: 1em"><?php _e('Listelenecek herhangi bir yazı bulunamadı.', 'geo'); ?></div>
			<?php endif;?>
		</div>
		<?php $post = $original_post;
		wp_reset_query();
	}
}

/*-----------------------------------------------------------------------------------*/
# Paylaş Butonları
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_social_share' ) ) {
function geoit_social_share() {
	global $post;
	$entry_style = (ot_get_option('social_share')) ? ot_get_option('social_share') : 'style-1';
	$page_style = (ot_get_option('social_share_page')) ? ot_get_option('social_share_page') : $entry_style;
	$links = (ot_get_option('geo_post_share_links')) ? ot_get_option('geo_post_share_links') : array('facebook', 'twitter', 'pinterest', 'whatsapp', 'email');

	if (is_page()) {
		if ($page_style == 'off' )
			return;
		$style = $page_style;
	} else {
		if ($entry_style == 'off' )
			return;
		$style = $entry_style;
	}
	?>
	<div class="content__post--meta-social social_btn_<?php echo $style; ?>">
		<ul>
			<?php $image = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full'); ?>
			
			<?php foreach($links as $link ): ?>
			
				<?php if ($link == 'facebook'): ?>
					<li><a class="facebook" rel="external noopener" target="_blank" href="//www.facebook.com/sharer/sharer.php?u=<?php echo get_permalink(); ?>" data-balloon="<?php _e('Facebook\'ta Paylaş', 'geo');?>" data-balloon-pos="bottom"><div class="fa fa-facebook"></div></a></li>
				<?php endif;?>
				
				<?php if ($link == 'twitter'): ?>
					<li><a target="_blank" rel="external noopener" class="twitter" href="//www.twitter.com/intent/tweet?text=<?php echo get_the_title(); ?> via <?php echo get_permalink(); ?>" data-balloon="<?php _e('Twitter\'da Paylaş', 'geo');?>" data-balloon-pos="bottom"><div class="fa fa-twitter"></div></a></li>
				<?php endif;?>
			
				<?php if ($link == 'whatsapp'): ?>
					<li><a class="whatsapp" href="whatsapp://send?text=<?php echo get_permalink(); ?>" data-balloon="<?php _e("Whatsapp'ta Paylaş", 'geo');?>" data-balloon-pos="bottom"><div class="fa fa-whatsapp"></div></a></li>
				<?php endif; ?>
				
				<?php if ($link == 'linkedin'): ?>
					<li><a target="_blank" rel="external noopener" class="linkedin" href="//www.linkedin.com/shareArticle?mini=true&url=<?php echo get_permalink(); ?>&title=<?php echo get_the_title(); ?>" data-balloon="<?php _e("Linkedin'e Paylaş", 'geo');?>" data-balloon-pos="bottom"><div class="fa fa-linkedin"></div></a></li>
				<?php endif; ?>
				
				<?php if ($link == 'pinterest'): ?>
					<li><a target="_blank" rel="external noopener" class="pinterest" href="//pinterest.com/pin/create/button/?url=&media=<?php echo $image[0]; ?>&description=<?php echo get_the_title(); ?>&url=<?php echo get_permalink(); ?>" data-balloon="<?php _e("Pinterest'te Paylaş", 'geo');?>" data-balloon-pos="bottom"><div class="fa fa-pinterest"></div></a></li>
				<?php endif; ?>
				
				<?php if ($link == 'telegram'): ?>
					<li><a target="_blank" rel="external noopener" class="telegram" href="//t.me/share/url?url=<?php echo get_the_permalink(); ?>&text=<?php echo get_the_title(); ?>" data-balloon="<?php _e("Telegram'da Paylaş", 'geo');?>" data-balloon-pos="bottom"><div class="fa fa-telegram"></div></a></li>
				<?php endif; ?>
				
				<?php if ($link == 'email'): ?>
					<li><a class="mail" href="mailto:e-posta@domain.com?subject=<?php echo get_the_title(); ?>&body=<?php echo get_permalink(); ?>" data-balloon="<?php _e('E-Posta ile Paylaş', 'geo');?>" data-balloon-pos="bottom"><div class="fa fa-envelope"></div></a></li>
				<?php endif; ?>
				
			<?php endforeach; ?>
			

		</ul>
	</div>
<?php  }
}

/*-----------------------------------------------------------------------------------*/
# Sosyal Medya Hesapları
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geo_social_links' ) ) {

	function geo_social_links() {
		if ( !ot_get_option('social-links') =='' ) {
			$links = ot_get_option('social-links', array());
			if ( !empty( $links ) ) {
				echo '<div class="header__top--social"><ul>';
				foreach( $links as $item ) {
					
					# Build each separate html-section only if set
					if ( isset($item['title']) && !empty($item['title']) ) 
						{ $title = 'title="' .$item['title']. '"'; } else $title = '';
					if ( isset($item['social-link']) && !empty($item['social-link']) ) 
						{ $link = 'href="' .$item['social-link']. '"'; } else $link = '';
					if ( isset($item['social-target']) && !empty($item['social-target']) ) 
						{ $target = 'target="' .$item['social-target']. '"'; } else $target = '';
					if ( isset($item['social-icon']) && !empty($item['social-icon']) ) 
						{ $icon = 'class="fa ' .$item['social-icon']. '"'; } else $icon = '';
					if ( isset($item['social-color']) && !empty($item['social-color']) ) 
						{ $color = 'style="color: ' .$item['social-color']. ';"'; } else $color = '';
					
					# Put them together
					if ( isset($item['title']) && !empty($item['title']) && isset($item['social-icon']) && !empty($item['social-icon']) && ($item['social-icon'] !='fa-') ) {
						echo '<li><a rel="nofollow" '.$title.' '.$link.' '.$target.'><i '.$icon.' '.$color.'></i></a></li>';
					}
					
				}
				echo '</ul></div>';
			}
		}
	}
	
}

/*-----------------------------------------------------------------------------------*/
# Sidebar
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geo_xxx_sidebar' ) ) {
	function geo_xxx_sidebar() {
			if ( is_home() && ! is_paged() ) { ?>
			<div class="container">
				<div class="row">
					<div class="widget-area full-width col-md-12">
						<?php dynamic_sidebar( 'home-full-width' ); ?>
					</div>
				</div>
			</div>
	<?php } 
	}
}
add_action( 'geo_sidebar', 'geo_xxx_sidebar', 15 );


/*-----------------------------------------------------------------------------------*/
# Mobil için paylaşma butonları
/*-----------------------------------------------------------------------------------*/
function geo_mobile_share() { 
	global $post;
	$status = (!empty(ot_get_option('geo_post_share_mobile'))) ? ot_get_option('geo_post_share_mobile') : '';
	$links = (ot_get_option('geo_post_share_links_mobile')) ? ot_get_option('geo_post_share_links_mobile') : array('facebook', 'twitter', 'pinterest', 'whatsapp', 'email');
	if ($status != 'off'): ?>
	<div class="geo_mobile_share">
		<ul>
			<?php $image = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full'); ?>
			<?php foreach($links as $link ): ?>
			
				<?php if ($link == 'facebook'): ?>
					<li><a class="facebook" rel="external noopener" target="_blank" href="http://www.facebook.com/sharer/sharer.php?u=<?php echo get_permalink(); ?>" data-balloon="<?php _e('Facebook\'ta Paylaş', 'geo');?>" data-balloon-pos="bottom"><div class="fa fa-facebook"></div></a></li>
				<?php endif;?>
				
				<?php if ($link == 'twitter'): ?>
					<li><a target="_blank" rel="external noopener" class="twitter" href="http://www.twitter.com/intent/tweet?text=<?php echo get_the_title(); ?> via <?php echo get_permalink(); ?>" data-balloon="<?php _e('Twitter\'da Paylaş', 'geo');?>" data-balloon-pos="bottom"><div class="fa fa-twitter"></div></a></li>
				<?php endif;?>
			
				<?php if ($link == 'whatsapp'): ?>
					<?php if(geo_is_mobile()): ?>
						<li><a target="_blank" class="whatsapp" href="whatsapp://send?text=<?php echo get_permalink(); ?>" data-balloon="<?php _e("Whatsapp'ta Paylaş", 'geo');?>" data-balloon-pos="bottom"><div class="fa fa-whatsapp"></div></a></li>
					<?php endif; ?>
				<?php endif; ?>
				
				<?php if ($link == 'linkedin'): ?>
					<li><a target="_blank" rel="external noopener" class="linkedin" href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo get_permalink(); ?>&title=<?php echo get_the_title(); ?>" data-balloon="<?php _e("Linkedin'e Paylaş", 'geo');?>" data-balloon-pos="bottom"><div class="fa fa-linkedin"></div></a></li>
				<?php endif; ?>
				
				<?php if ($link == 'pinterest'): ?>
					<li><a target="_blank" rel="external noopener" class="pinterest" href="https://pinterest.com/pin/create/button/?url=&media=<?php echo $image[0]; ?>&description=<?php echo get_the_title(); ?>&url=<?php echo get_permalink(); ?>" data-balloon="<?php _e("Pinterest'te Paylaş", 'geo');?>" data-balloon-pos="bottom"><div class="fa fa-pinterest"></div></a></li>
				<?php endif; ?>
				
				<?php if ($link == 'telegram'): ?>
					<li><a target="_blank" rel="external noopener" class="telegram" href="https://t.me/share/url?url=<?php echo get_the_permalink(); ?>&text=<?php echo get_the_title(); ?>" data-balloon="<?php _e("Telegram'da Paylaş", 'geo');?>" data-balloon-pos="bottom"><div class="fa fa-telegram"></div></a></li>
				<?php endif; ?>
				
				<?php if ($link == 'email'): ?>
					<li><a class="mail" href="mailto:e-posta@domain.com?subject=<?php echo get_the_title(); ?>&body=<?php echo get_permalink(); ?>" data-balloon="<?php _e('E-Posta ile Paylaş', 'geo');?>" data-balloon-pos="bottom"><div class="fa fa-envelope "></div></a></li>
				<?php endif; ?>
				
			<?php endforeach;?>
		</ul>
	</div>
	<?php endif;
}

/*-----------------------------------------------------------------------------------*/
# Footer 
/*-----------------------------------------------------------------------------------*/
add_action('geoit_footer', 'geoit_popup', 10);
add_action('geoit_footer', 'geoit_login', 20);
add_action('geoit_footer', 'geoit_footer_temps', 999);

function geoit_footer_temps() {
	$footer = ot_get_option( 'footer-layout-select' );
	if ($footer == '2') {
		get_template_part('frameworks/template-parts/footer/footer-2' );
	} else {
		get_template_part('frameworks/template-parts/footer/footer-1' );
	}
}

/*-----------------------------------------------------------------------------------*/
# Custom Sidebar
/*-----------------------------------------------------------------------------------*/
function geoit_register_custom_sidebar() {
	$sidebars = ot_get_option('geoit_custom_sidebars');
	$style = ot_get_option('block_title_style');
	$class = 'block_title_'.$style;
	
	if ($sidebars) {
		foreach($sidebars as $sidebar) {
			register_sidebar(array(
				'name' => $sidebar['title'],
				'description' => 'Özel olarak oluşturulmuş sidebar.',
				'id' => $sidebar['id'],
				'before_widget' => '<aside id="%1$s" class="widget widget-0 %2$s">',
				'after_widget' => '</aside>',
				'before_title' => '<div class="content__title '.$class.'"><h4 class="uckan-btn">',
				'after_title' => '</h4></div>',
			));
		}
	}
		
}
add_action( 'widgets_init', 'geoit_register_custom_sidebar' );


/*-----------------------------------------------------------------------------------*/
# Öne Çıkan Yazıları Son Yazılardan Çıkart
/*-----------------------------------------------------------------------------------*/
add_action( 'pre_get_posts', 'geoit_exclude_posts_from_main_query' );
function geoit_exclude_posts_from_main_query( $query ) {
	if ( is_admin()
			 || ! is_home()
			 || ! $query->is_main_query()
			 || ( isset( $_GET['orderby'] ) && $_GET['orderby'] !== 'date' )
			 || ot_get_option('geoit_exclude_featured_posts_for_recent_posts') != 'on'  
	) {
		return;
	}
	$style     = ot_get_option( 'slider_select' );
	$count = ot_get_option('geo_slider_count');
	$cat = ot_get_option('geo-carousel-category');
	$exlude = ot_get_option('geo-carousel-post-not2');
	$exluded = explode(",", $exlude);
	
	if ($style == 'slider-style1' || $style == 'slider-style10' || $style == 'slider-style11')
		$count = 5;
	elseif ($style == 'slider-style8')
		$count = 4;
	elseif ($style == 'slider-style9')
		$count = 3;
	
	$args  = array(
		'order'          => 'DESC',
		'posts_per_page' => $count,
		'post__not_in'   => $exluded,
		'cat'						 => $cat,
		'fields'         => 'ids'
	);
	$custom_query   = new WP_Query( $args );
	$excluded_posts = $custom_query->posts;
	$query->set( 'post__not_in', $excluded_posts );
}

add_action( 'pre_get_posts', 'geoit_exclude_posts_from_cat_query' );
function geoit_exclude_posts_from_cat_query( $query ) {
	if ( is_admin()
			 || ! is_category()
			 || ! $query->is_main_query()
			 || ( isset( $_GET['orderby'] ) && $_GET['orderby'] !== 'date' )
			 || ot_get_option('geoit_exclude_featured_posts_for_recent_posts_cat') != 'on'  
	) {
		return;
	}
	$style = ot_get_option( 'slider_select_cat' );
	$count = ot_get_option('geo_slider_count');
	$cat = get_queried_object()->term_id;
	$exlude = ot_get_option('geo-carousel-post-not2');
	$exluded = explode(",", $exlude);
	
	if ($style == 'slider-style1' || $style == 'slider-style10' || $style == 'slider-style11')
		$count = 5;
	elseif ($style == 'slider-style8')
		$count = 4;
	elseif ($style == 'slider-style9')
		$count = 3;
	
	$args  = array(
		'order'          => 'DESC',
		'posts_per_page' => $count,
		'post__not_in'   => $exluded,
		'cat'						 => $cat,
		'fields'         => 'ids'
	);
	$custom_query   = new WP_Query( $args );
	$excluded_posts = $custom_query->posts;
	$query->set( 'post__not_in', $excluded_posts );
}