<?php

/*-----------------------------------------------------------------------------------*/
# Yazı Kaynağı
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'get_geo_post_source' ) ) {
	function get_geo_post_source($id) {
		$option = get_post_meta( $id, 'geo_post_source', true ) ? get_post_meta( $id, 'geo_post_source', true ) : '';
		if ($option == '')
			return;
		
		$out = '<div data-toggle="geo-post-source-links" class="geo-post-source">';
			$out .= '<div class="geo-post-source-title"><span>'.__('Yazı Kaynakları', 'geo').'</span></div>';
			$out .= '<div id="geo-post-source-links">';
			foreach ($option as $item) {
				$rel = 'noreferrer noopener';
				$rel .= ($item['sponsored'] == 'on') ? ' sponsored' : '';
				$rel .= ($item['nofollow'] == 'on') ? ' nofollow' : '';
				$target .= ($item['nofollow'] == 'on') ? 'target="_blank"' : '';
				if ($item['title'] != '' && $item['link'] != '')
					$out .= '<div class="geo-post-source-link"><a '.$target.' '.$rel.' href="'.$item['link'].'"><i class="fa fa-link"></i>  '.$item['title'].'</a></div>';
			}
			$out .= '</div>';
		$out .= '</div>';
		
		return $out;
	}
}
/*-----------------------------------------------------------------------------------*/
# Rankını Göster
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geo_get_rank' ) ) {
	function geo_get_rank($author) {
			$user = new WP_User( $author );
			$count = get_user_meta( $author, 'geo_user_points', true );
			$role = $user->roles;
			$rank = ot_get_option('geo_ranks', array());
			$rank2 = ot_get_option('geo_role_ranks', array());
			$out = '';
			if (!empty($rank2)){
				foreach($rank2 as $item) {
					if ( isset($item['title']) && !empty($item['title']) && !empty($item['role']) && isset($item['role'])) {
						if($role[0] == $item['role']){
							$out .= '<label style="background-color: '.$item['color'].'" class="user-rank-geo">'.$item['title'].'</label>';
						}
					}
				}
			}
			
			if (!empty($rank)){
				foreach($rank as $item) {
					if ( isset($item['title']) && !empty($item['title']) && !empty($item['rank-min']) && isset($item['rank-min']) && !empty($item['rank-max']) && isset($item['rank-max'])) {
						if($count>=$item['rank-min'] && $count<=$item['rank-max']){
							$out .= '<label style="background-color: '.$item['color'].'" class="user-rank-geo">'.$item['title'].'</label>';
						}
					}
				}
			}
			
			return $out;
	}
}

/*-----------------------------------------------------------------------------------*/
# Puanını Göster
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geo_get_points' ) ) {
	function geo_get_points($author) {
		$count = get_user_meta( $author, 'geo_user_points', true ); 
		if (!empty($count)) {
			$out = $count;
		}
		else {
			$out = '0';
		}
		return $out;
	}
}

/*-----------------------------------------------------------------------------------*/
# Okunma Sayısı
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_block_views' ) ) {
	function geoit_block_views() {
		$control = ot_get_option('geoit_post_views');
		$block = ot_get_option('geo_block_views');
		$return = '';
		if ($control == 'on' && function_exists("pvc_get_post_views")) {
			if ($block == 'on') {
				$return = pvc_get_post_views( get_the_ID());
				$return = '<span class="post-views"><i class="fa fa-bolt"></i> '.$return.'</span>';
			}
		}
		return $return;
	}
}
if ( ! function_exists( 'geoit_post_views' ) ) {
	function geoit_post_views() {
		$control = ot_get_option('geoit_post_views');
		$block = ot_get_option('geo_post_views');
		$return = '';
		if ($control == 'on' && function_exists("pvc_get_post_views")) {
			if ($block == 'on') {
				$return = pvc_get_post_views( get_the_ID());
				$return = '<span class="post-views"><i class="fa fa-bolt"></i> '.$return.'</span>';
			}
		}
		return $return;
	}
}


/*-----------------------------------------------------------------------------------*/
# Widget Title
/*-----------------------------------------------------------------------------------*/
function geoit_block_title($value, $tag) {
	$style = ot_get_option('block_title_style');
	$class = 'block_title_'.$style;
	return '<div class="content__title '.$class.'"><'.$tag.' class="uckan-btn">'.$value.'</'.$tag.'></div>';
}

/*-----------------------------------------------------------------------------------*/
# Yazar
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geo_entry_author' ) ) {
	function geo_entry_author () {
		$author = get_the_author();
		echo '<div class="entry-author">';
			echo geoit_get_avatar( 'email@example.com', 25 );
			echo ''.$author.'';
		echo '</div>';
	}
}

/*-----------------------------------------------------------------------------------*/
# Kategori
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geo_categories' ) ) {
	function geo_categories () {
		$category = get_the_category(); 
		$class = 'geo_first_category';
		$first = '';
	
		$cat_name = ''; // I have this set in some shortcodes

		if (!isset($cat_name) || $cat_name == '') {

			if ( class_exists('WPSEO_Primary_Term') ) {

				// Show the post's 'Primary' category, if this Yoast feature is available, & one is set. category can be replaced with custom terms

				$wpseo_primary_term = new WPSEO_Primary_Term( 'category', get_the_id() );

				$wpseo_primary_term = $wpseo_primary_term->get_primary_term();
				$term               = get_term( $wpseo_primary_term );

				if (is_wp_error($term)) {
						$categories = get_the_terms(get_the_ID(), 'category');
						$link = get_category_link( $categories[0]->term_id );
						if(ot_get_option('cat_link_style') == 'style-2') {
							$class = 'geo_first_category_'.ot_get_option('cat_link_style');
							$first = '<div class="geo_first_category_dropcap">'.substr($categories[0]->name , 0, 1).'</div>';
						}
						$cat_name = '<a class="	'.$class .' geoit-cat-item-'.$categories[0]->term_id.'" href="'. esc_url( $link ) .'">'.$first.' '. $categories[0]->name .'</a>';
				} else {
						$cat_name = $term->name;
						$link = get_category_link( $term->term_id );
						if(ot_get_option('cat_link_style') == 'style-2') {
							$class = 'geo_first_category_'.ot_get_option('cat_link_style');
							$first = '<div class="geo_first_category_dropcap">'.substr($term->name , 0, 1).'</div>';
						}
						$cat_name = '<a class="'.$class .' geoit-cat-item-'.$term->term_id.'" href="'. esc_url( $link ) .'">'.$first.' '. $term->name .'</a>';
				}

			} else {
				$categories = get_the_terms(get_the_ID(), 'category');
				$link = get_category_link( $categories[0]->term_id);
				if(ot_get_option('cat_link_style') == 'style-2') {
					$class = 'geo_first_category_'.ot_get_option('cat_link_style');
					$first = '<div class="geo_first_category_dropcap">'.substr($categories[0]->name , 0, 1).'</div>';
				}
				$cat_name = '<a class="'.$class .' geoit-cat-item-'.$categories[0]->term_id.'" href="'. esc_url( $link ) .'">'.$first.' '. $categories[0]->name .'</a>';
			}
		}

		echo $cat_name;

	}
}

/*-----------------------------------------------------------------------------------*/
# Trendlerdeki Yazılar
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geo_news_ticker' ) ) {
	function geo_news_ticker() {
		$page 	= ot_get_option('geo-trending');
		
		if (!empty($page)) {
			$page = array(
				'tag' => 'a href="'.get_page_link($page).'"',
				'tag_end' => 'a',
			);
		} else {
			$page = array(
				'tag' => 'div',
				'tag_end' => 'div',
			);
		}
		
		$args = array(
			'meta_query' => array(
				array(
					'key' => 'geoit_post_trending',
					'value' => 'on',
					'compare' => '='
				)
			),
		  'showposts' => 10
		);
		
		$geoit_query = new WP_Query( $args );

		if ($geoit_query->have_posts()) {
			echo '<div id="news-ticker" class="news--ticker">';
			echo '<'.$page['tag'].' class="ticker-title" title="'.__('Trendlerdeki Yazılar', 'geo').'"><i class="fa fa-bolt"></i></'.$page['tag_end'].'>';
			echo '<ul id="sample" class="ticker">';
				while($geoit_query->have_posts()): $geoit_query->the_post();
					echo '<li>';
						echo the_title( sprintf( '<a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a>' );
					echo '</li>';
				endwhile;
				echo '</ul>';
			echo '</div>';
		}
		
	}
}

/*-----------------------------------------------------------------------------------*/
# Trendlerdeki Yazılar
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geo_news_ticker_with_popup' ) ) {
	function geo_news_ticker_with_popup() {
		$page 	= ot_get_option('geo-trending');
		
		$args = array(
			'meta_query' => array(
				array(
					'key' => 'geoit_post_trending',
					'value' => 'on',
					'compare' => '='
				)
			),
		  'showposts' => 10
		);
		
		$geoit_query = new WP_Query( $args );

		if ($geoit_query->have_posts()) {
			echo '<div id="header__trending" class="geo-notification">';
				echo '<div class="geo-notification-header"><i class="fa fa-bolt"></i> '.__('Trendlerdeki Yazılar', 'geo').'</div>';
				echo '<ul class="geo-notification-content modern-scroll">';
				while($geoit_query->have_posts()): $geoit_query->the_post();
					echo '<li>';
						echo the_title( sprintf( '<a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a>' );
					echo '</li>';
				endwhile;
				echo '</ul>';
				if (!empty($page)) {
					echo '<div class="geo-notification-footer"><a href="'.get_page_link($page).'">'.__('Hepsini Göster', 'geo').' <i class="fa fa-arrow-right"></i></a></div>';
				}
			echo '</div>';
		}
		
	}
}

/*-----------------------------------------------------------------------------------*/
# Onaylanmış Hesap
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_verified_user' ) ) {
	function geoit_verified_user($curauth) {
		$verified = get_the_author_meta('verified_user', $curauth); 
		if( $verified == 'yes') {
			echo '<label class="verify-geo" data-balloon="'.__('Onaylanmış Hesap', 'geo').'" data-balloon-pos="top"><i class="fa fa-check"></i></label>';
		}
	}
}

/*-----------------------------------------------------------------------------------*/
# Trendlerdeki Yazı - İkon
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_trending_post' ) ) {
	function geoit_trending_post($post) {
		$trending = get_post_meta($post, 'geoit_post_trending', true);
		$status 	= ot_get_option('geo_trending_status');
		if ($status != 'off') {
			if ($trending == 'on' ) {
				echo '<div class="geo_trending_post" data-balloon="'.__('Trendlerdeki Yazı', 'geo').'" data-balloon-pos="top"><i class="fa fa-bolt"></i></div>';
			}
		}
	}
}

/*-----------------------------------------------------------------------------------*/
# Trendlerdeki Yazı - Text + İkon
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_trending_entry' ) ) {
	function geoit_trending_entry($post) {
		$trending = get_post_meta($post, 'geoit_post_trending', true);
		$status 	= ot_get_option('geo_trending_status');
		if ($status != 'off') {
			if ($trending == 'on' ) {
				echo '<div class="trending-post"><div><span class="geo_trending_post fa fa-bolt"></i></span> '.__('Trendlerdeki Yazı', 'geo').'</div></div>';
			}
		}
	}
}

/*-----------------------------------------------------------------------------------*/
# Okunma Süresi
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_reading_time' ) ) {
	function geoit_reading_time($post) {
		if (ot_get_option('reading-time') != 'off') {
			$uckicerik = $post->post_content; # yazı iceriğini çekiyor
			$word = str_word_count(strip_tags($uckicerik)); # içerikteki kelime sayısını hesaplıyor
			$m = floor($word / 200); # kelime sayısını 200'e bölerek dakika sayısını hesaplıyor
			$s = floor($word % 200 / (200 / 60)); # kelime sayısının %200'ünü alıp 3.33'e bölerek saniyeyi hesaplıyor
			echo '<span class="reading-time"><i class="fa fa-bookmark-o"></i> ';
			echo __('Okuma süresi:', 'geo');
			$uckokunma = ' '.$m . __('dk', 'geo') . ($m == 1 ? '' : '') . ', ' . $s . __('sn', 'geo') . ($s == 1 ? '' : '');
			echo $uckokunma;
			echo '</span>';
		}
	}
}


/*-----------------------------------------------------------------------------------*/
# Get Avatar
/*-----------------------------------------------------------------------------------*/
function geoit_get_avatar($author, $size) {
	$out = '';
	$nick = get_the_author_meta('user_nicename', $author);
	$avatar = get_user_meta( $author, 'basic_user_avatar', true );
	if (empty($avatar)) {
		$avatar = get_avatar_url($author, array("size" => $size));
	} else {
		if (!empty($avatar[$size])) {
			$avatar = $avatar[$size];
		} else {
			$avatar = $avatar['full'];
		}
	}
	if(ot_get_option('geoit_lazy_images') == 'on') {
		$out = '<img width="'.$size.'" height="'.$size.'" class="geo-lazy owl-lazy" alt="'.$nick.'_avatar" data-src="'.$avatar.'" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVR42mPk5ODkAQAAZAAoQWYOjQAAAABJRU5ErkJggg==">';
	} else {
		$out = get_avatar( $author, $size );
	}
	return $out;
}

/*-----------------------------------------------------------------------------------*/
# Get Post Thumbnail {background-image}
/*-----------------------------------------------------------------------------------*/
function geoit_thumbnail_background_image($thumbnail_id, $size, $class = 'w-slider_image') {
	if(ot_get_option('geoit_lazy_images') == 'on') {
		if ( $image_src = wp_get_attachment_image_src( $thumbnail_id, $size) ) {
			echo 'class="'.$class.' owl-lazy" data-src="'.$image_src[0].'"';
		}
		else {
		    echo 'class="'.$class.'"';
		}
	} else {
		if ( $image_src = wp_get_attachment_image_src( $thumbnail_id, $size) ) {
			echo 'class="'.$class.'" style="background-image: url('.$image_src[0].')"';
		}
		else {
		    echo 'class="'.$class.'"';
		}
	}
}

/*-----------------------------------------------------------------------------------*/
# Get Post Thumbnail2 {background-image}
/*-----------------------------------------------------------------------------------*/
function geoit_thumbnail_background_image2($thumbnail_id, $size, $class = 'w-slider_image') {
	if(ot_get_option('geoit_lazy_images') == 'on') {
		if ( $image_src = wp_get_attachment_image_src( $thumbnail_id, $size) ) {
			echo 'class="'.$class.' geo-lazy" data-src="'.$image_src[0].'"';
		} else {
			echo 'class="'.$class.'"';
		}
	} else {
		if ( $image_src = wp_get_attachment_image_src( $thumbnail_id, $size) ) {
			echo 'class="'.$class.'" style="background-image: url('.$image_src[0].')"';
		} else {
		    echo 'class="'.$class.'"';
		}
	}
}

/*-----------------------------------------------------------------------------------*/
# Kullanıcı Kayıt Tarihi
/*-----------------------------------------------------------------------------------*/
function add_custom_user_profile_fields( $user ){
	$udata = get_userdata( $user->ID );
	$registered = $udata->user_registered;
	return date_i18n( "j M Y", strtotime( $registered ));
}

/*-----------------------------------------------------------------------------------*/
# Logo
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_site_logo' ) ) {
	function geoit_site_logo() {
		$m = [
			'img'  => (!empty(get_theme_mod('geoit_logo'))) ? get_theme_mod('geoit_logo') : '',
			'text'  => (!empty(get_theme_mod('geoit_logo_text'))) ? get_theme_mod('geoit_logo_text') : get_bloginfo('name'),
			'width'  => (!empty(get_theme_mod('geoit_logo_width'))) ? get_theme_mod('geoit_logo_width') : '',
			'height'  => (!empty(get_theme_mod('geoit_logo_height'))) ? get_theme_mod('geoit_logo_height') : '',
			'name' => (!empty(get_theme_mod('geoit_logo_title'))) ? get_theme_mod('geoit_logo_title') : get_bloginfo('name'),
			'url'  => esc_url( get_home_url( '/' ))
		];
		$out = '';
		if ($m['img']) {
			if (is_home())
				$out .= '<h1 class="screen-reader-text">'.$m['text'].'</h1>';
			if($m['width'] != '' || $m['height'] != '')
				$out .= '<a href="'.$m['url'].'" title="'.$m['name'].'"><img style="width:'.$m['width'].'px; height:'.$m['height'].'px" width="'.$m['width'].'" height="'.$m['height'].'" src="'.$m['img'].'" alt="'.$m['name'].'" title="'.$m['name'].'" /></a>';
			else
				$out .= '<a href="'.$m['url'].'" title="'.$m['name'].'"><img src="'.$m['img'].'" alt="'.$m['name'].'" title="'.$m['name'].'" /></a>';
		} else {
			$tag = 'h1';
			if (!is_home())
			$tag = 'div';
			$out .= '<'.$tag.'><a class="logo-no" href="'.$m['url'].'" title="'.$m['name'].'">'.$m['text'].'</a></'.$tag.'>'; 
		}
		return $out;
	}
}

/*-----------------------------------------------------------------------------------*/
# Pagination
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'geoit_pagination' ) ) {
	function geoit_pagination() {
		$pagination_type = (!empty(ot_get_option('geot_posts_pagination'))) ? ot_get_option('geot_posts_pagination') : 'numbers';
		if ($pagination_type == 'load_more' || $pagination_type == 'infinite_scroll') : 
			$next_link = get_next_posts_link(__('Sonra'));
			if($next_link): ?>
			<div class="geoit_pagination_links">
				<div class="geoit_pagination_prev"><?php previous_posts_link( 'Önceki' ); ?></div>
				<div class="geoit_pagination_next"><?php next_posts_link( 'Sonraki'); ?></div>
			</div>
			<div id="load-more-posts-button-wrapper">
				<div style="display:none" class="page-load-status">
					<div class="loader-ellips infinite-scroll-request">
						<svg version="1.1" id="loader-1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="40px" height="40px" viewBox="0 0 40 40" enable-background="new 0 0 40 40" xml:space="preserve"> <path opacity="0.2" fill="#000" d="M20.201,5.169c-8.254,0-14.946,6.692-14.946,14.946c0,8.255,6.692,14.946,14.946,14.946 s14.946-6.691,14.946-14.946C35.146,11.861,28.455,5.169,20.201,5.169z M20.201,31.749c-6.425,0-11.634-5.208-11.634-11.634 c0-6.425,5.209-11.634,11.634-11.634c6.425,0,11.633,5.209,11.633,11.634C31.834,26.541,26.626,31.749,20.201,31.749z"/> <path fill="#000" d="M26.013,10.047l1.654-2.866c-2.198-1.272-4.743-2.012-7.466-2.012h0v3.312h0 C22.32,8.481,24.301,9.057,26.013,10.047z"> <animateTransform attributeType="xml" attributeName="transform" type="rotate" from="0 20 20" to="360 20 20" dur="0.5s" repeatCount="indefinite"/> </path> </svg>
					</div>
					<p class="infinite-scroll-last"><?php _e('Daha fazla gösterilecek yazı bulunamadı!', 'geo'); ?></p>
					<p class="infinite-scroll-error"><?php _e('Tekrar deneyiniz.', 'geo'); ?></p>
				</div>
				<button class="load-more-posts-button" geoit-data-load-more-button><?php _e('Daha Fazla Yükle', 'geo'); ?></button>
			</div>
			<?php endif;
		else:
			the_posts_pagination( array(
				'prev_text'          => '<i class="fa fa-long-arrow-left"></i>',
				'next_text'          => '<i class="fa fa-long-arrow-right"></i>',
				'mid_size' => 5,
			) );
		endif;
	}
}