<?php
/**
 * Initialize the custom Theme Options.
 */
add_action( 'init', 'custom_theme_options' );

/**
 * Build the custom settings & update OptionTree.
 *
 * @return    void
 * @since     2.3.0
 */
function custom_theme_options() {

  /* OptionTree is not loaded yet, or this is not an admin request */
  if ( ! function_exists( 'ot_settings_id' ) || ! is_admin() )
    return false;

  /**
   * Get a copy of the saved settings array. 
   */
  $saved_settings = get_option( ot_settings_id(), array() );
  
  /**
   * Custom settings array that will eventually be 
   * passes to the OptionTree Settings API Class.
   */
  $custom_settings = array( 
   'sections'        => array(
			array(
        'id'          => 'general',
        'title'       => __( 'Genel Ayarlar', 'geo-admin' )
      ),
			array(
        'id'          => 'amp',
        'title'       => __( 'AMP Ayarları', 'geo-admin' )
      ),
			array(
        'id'          => 'header',
        'title'       => __( 'Header Ayarları', 'geo-admin' )
      ),
			array(
        'id'          => 'footer',
        'title'       => __( 'Footer Ayarları', 'geo-admin' )
      ),
			array(
        'id'          => 'featured',
        'title'       => __( 'Öne Çıkan Yazılar', 'geo-admin' )
      ),
			array(
        'id'          => 'sidebar',
        'title'       => __( 'Sidebar Ayarları', 'geo-admin' )
      ),
			array(
        'id'          => 'blog',
        'title'       => __( 'Yazı Sayfası', 'geo-admin' )
      ),
			array(
        'id'          => 'blok',
        'title'       => __( 'Arşiv Sayfaları', 'geo-admin' )
      ),
			array(
        'id'          => 'slider',
        'title'       => __( 'Slider-Carousel Ayarları', 'geo-admin' )
      ),
			array(
        'id'          => 'comments',
        'title'       => __( 'Yorum Ayarları', 'geo-admin' )
      ),
			array(
        'id'          => 'members',
        'title'       => __( 'Üyelik Sistemi', 'geo-admin' )
      ),
			array(
        'id'          => 'stories',
        'title'       => __( 'Hikaye Sistemi', 'geo-admin' )
      ),
			array(
        'id'          => 'reaction',
        'title'       => __( 'Reaksiyon Sistemi', 'geo-admin' )
      ),
			array(
        'id'          => 'puan',
        'title'       => __( 'Puan ve Rank Sistemi', 'geo-admin' )
      ),
			array(
        'id'          => 'social',
        'title'       => __( 'Sosyal Medya', 'geo-admin' )
      ),
			array(
        'id'          => 'pages',
        'title'       => __( 'Geoit Sayfaları', 'geo-admin' )
      ),
			array(
        'id'          => 'ads',
        'title'       => __( 'Reklam Yönetimi', 'geo-admin' )
      ),
      array(
        'id'          => 'popup',
        'title'       => __( 'Popup ve Gizlilik', 'geo-admin' )
      ),
      array(
        'id'          => 'about',
        'title'       => __( 'Geoit Hakkında', 'geo-admin' )
      ),
    ),
    'settings'        => array(
			array(
			  'id'          => 'geo-about',
			  'label'       => __('Geoit Hakkında', 'geo-admin'),
			  'desc'         => '<img src="'.get_template_directory_uri().'/theme-options/assets/images/kanthemes_normal.png" style="margin-bottom:1em"/><p style="font-size: 26px; margin-bottom:5px !important;">Geoit, Kanthemes.com tarafından Haziran 2017\'den itibaren günümüze kadar geliştirilmeye devam ederek güncelliğini korumayı başaran ücretli bir wordpress temasıdır.</p>
					<p style="margin-bottom:1em; font-size: 18px;">Temamız hakkında deneyimlerinizi muhtemel alıcılarla paylaşmak isterseniz bekleriz, teşekkürler.</p>
					
					<a style="background:blue" href="https://www.r10.net/wordpress-tema-amp-eklenti-satisi/1730040-geoit-wordpress-temasi-viral-blog-teknoloji-magazine-reklamhiz-ve-seo-optimizasyonu-tr-en.html" target="_blank">R10.Net</a>
					<a style="background:red;"href="https://www.kanthemes.com/urun/geoit-wordpress-temasi#respond" target="_blank">Kanthemes.com</a>
					<a style="background:black;"href="https://www.kanthemes.com/destek" target="_blank">Destek</a>
					',
			  'type'        => 'textarea-simple',
					'class'				=> 'about-geo',
			  'section'     => 'about',
			  'operator'    => 'and'
			),
			array(
				'id'		=> 'geoit-site-container',
				'label'		=> __( 'Genel Site Genişliği', 'geo-admin' ),
				'std'		=> 'container',
				'type'		=> 'select',
				'section'	=> 'general',
				'choices'     => array(
				  array(
					'value'       => 'container',
					'label'       => __( 'Sınırlandırılmış Genişlik', 'geo-admin' ),
					'src'         => ''
				  ),
				  array(
					'value'       => 'container-fluid',
					'label'       => __( 'Tam Genişlik', 'geo-admin' ),
					'src'         => ''
				  ),
				)
			),
			array(
				'id'		=> 'h-layout-select',
				'label'		=>  __( 'Genel Site Düzeni', 'geo-admin' ),
				'std'		=> 'h-layout-0',
				'type'		=> 'radio-image',
				'section'	=> 'general',
				'class'		=> '',
				'choices'	=> array(
					array(
						'value'		=> 'h-layout-0',
						'label'		=> 'Sidebar Sağ',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/right-sidebar.png'
					),
					array(
						'value'		=> 'h-layout-1',
						'label'		=> 'Tam Genişlik',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/full-width.png'
					),
					array(
						'value'		=> 'h-layout-2',
						'label'		=> 'Sidebar Sol',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/left-sidebar.png'
					),
				)
			),
			
			array(
				'id'		=> 'site-box-style',
				'label'		=> __( 'Kutu Tasarımı', 'geo-admin' ),
				'desc'		=> __( 'Kutu içeriklerinin kenarlığını değiştirir. ', 'geo-admin' ),
				'std'		=> 'shadow',
				'type'		=> 'select',
				'section'	=> 'general',
				'choices'     => array(
				  array(
					'value'       => 'shadow',
					'label'       => __( 'Gölgeli', 'geo-admin' ),
					'src'         => ''
				  ),
				  array(
					'value'       => 'bordered',
					'label'       => __( 'Kenar Çizgili', 'geo-admin' ),
					'src'         => ''
				  ),
				  array(
					'value'       => 'flat',
					'label'       => __( 'Düz', 'geo-admin' ),
					'src'         => ''
				  ),
				)
			),
			array(
				'id'		=> 'dark_theme',
				'label'		=>  __( 'Koyu Tema' , 'geo-admin' ),
				'desc'		=>  __( 'Koyu temayı varsayılan olarak ayarlamak istiyorsanız anahtarı "on" durumuna getirin.' , 'geo-admin' ),
				'std'		=> 'off',
				'type'		=> 'on-off',
				'section'	=> 'general'
			),
			array(
				'id'		=> 'geo_open_graph',
				'label'		=>  __( 'Meta Verileri' , 'geo-admin' ),
				'desc'		=>  __( 'Siteniz hakkında arama motorlarına ve sosyal medya sitelerine bilgi verecek meta verilerinin eklenmesini istiyorsanız anahtarı "on" durumuna getirin.' , 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'general'
			),
			array(
				'id'		=> 'geo_schema',
				'label'		=>  __( 'Schema.org Yapısal Veri İşaretleme' , 'geo-admin' ),
				'desc'		=>  __( 'Siteniz hakkında ve yazılarınız hakkında arama motorlarına bilgi verecek mikro data verilerinin eklenmesini istiyorsanız anahtarı "on" durumuna getirin.' , 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'general'
			),
			
			array(
			'id'          => 'geo_schema_type',
			 'label'       => __( 'Schema.org Yapısal Veri İşaretleme Tipi', 'geo-admin' ),
			 'std'         => 'Article',
			 'type'        => 'select',
			 'section'     => 'general',
			 'operator'    => 'and',
				'choices'     => array(
					array(
						'value'       => 'Article',
						'label'       => 'Article',
						'src'         => ''
					),
					array(
						'value'       => 'NewsArticle',
						'label'       => 'NewsArticle',
						'src'         => ''
					),
				),
			),
			
			
			array(
				'id'		=> 'post-layout-select',
				'label'		=>  __( 'Yazı Sidebar Konumu', 'geo-admin' ),
				'std'		=> 'right',
				'type'		=> 'radio-image',
				'section'	=> 'blog',
				'choices'	=> array(
					array(
						'value'		=> 'right',
						'label'		=> 'Sidebar',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/right-sidebar.png'
					),
					array(
						'value'		=> 'full',
						'label'		=> 'Tam Genişlik',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/full-width.png'
					),
				)
			),
			
			array(
				'id'		=> 'geo-dns-prefetch',
				'label'		=> __( 'Dns Prefetch', 'geo-admin' ),
				'desc'		=> __( 'Google analiz, google font, gravatar gibi servisleri dns prefetch ile önceden çözümleyin ve site hızını attıın.', 'geo-admin' ),
				'type'		=> 'on-off',
				'std'       => 'on',
				'section'	=> 'general',
				'operator' => 'and'
			),
			
			array(
				'id'		=> 'geo-post-thumbnail',
				'label'		=> __( 'Öne Çıkan Görselin Durumu', 'geo-admin' ),
				'type'		=> 'on-off',
				'std'       => 'on',
				'section'	=> 'blog',
				'operator' => 'and'
			),
			array(
				'id'		=> 'geo-post-modified-date',
				'label'		=> __( 'Son Düzenlenme Tarihi', 'geo-admin' ),
				'desc'		=> __( 'Yazının son düzenleme tarihini gösterin.', 'geo-admin' ),
				'std'		=> 'off',
				'type'		=> 'on-off',
				'section'	=> 'blog'
			),
			array(
				'id'		=> 'geo-post-tags',
				'label'		=> __( 'Yazı Etiketleri', 'geo-admin' ),
				'std'		=> 'on',
				'class'		=> 'yeni',
				'type'		=> 'on-off',
				'section'	=> 'blog'
			),
			array(
				'id'		=> 'geo-post-sizes',
				'label'		=> __( 'Yazı Boyutu Butonları', 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'blog'
			),
			array(
				'id'		=> 'geo-infinite',
				'label'		=> __( 'Aşağı İndikçe Yazı Yükle', 'geo-admin' ),
				'desc'		=> __( 'Yazı içerisinde aşağıya indikçe bir önceki yazıyı yükler.', 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'blog'
			),
			array(
				'id'		=> 'geo-dashicons',
				'label'		=> __( 'Dashicons Kaldır', 'geo-admin' ),
				'desc'		=> __( 'Geoit wordpress temasında dashicons kullanılmamaktadır, dashicons wordpress ile gelmektedir ve bazı eklentiler bu ikonları kullanmaktadır dolayısıyla varsayılan olarak bu ikon dosyasını kaldıramıyoruz eğer dashicons kullanan bir eklenti kullanmıyorsanız bu ayarı off yaparak site hızınızı arttırabilirsiniz. (Sadece görünür yüzden kaldırır)', 'geo-admin' ),
				'std'		=> 'off',
				'type'		=> 'on-off',
				'section'	=> 'general'
			),
			array(
				'id'		=> 'geoit_post_views',
				'label'		=> __( 'Okunma Sayısı', 'geo-admin' ),
				'desc'		=>  sprintf(__('Bu özelliği kullanmak için <a href="%1$splugin-install.php?tab=plugin-information&plugin=post-views-counter&TB_iframe=true&width=772&height=596">Post Views Counter</a> eklentisini kurup gerekli ayarları yapmanız gerekmekte. <a href="%2$soptions-general.php?page=post-views-counter">Ayarları Yapın</a>' , 'geo-admin'),
					get_admin_url(),
					get_admin_url()
				),
				'std'		=> 'off',
				'type'		=> 'on-off',
				'section'	=> 'general'
			),
			array(
				'id'		=> 'geoit_lazy_images',
				'label'		=> __( 'Lazy Load Images', 'geo-admin' ),
				'desc'		=> __( 'Sadece ekranda gözüken görseller yüklenir böylelikle site hızında gözle görülür bir artış sağlar.', 'geo-admin' ),
				'std'		=> 'off',
				'type'		=> 'on-off',
				'section'	=> 'general'
			),
			array(
				'id'		=> 'geo-sticky',
				'label'		=> __( 'Yapışkan Sidebar', 'geo-admin' ),
				'desc'		=> __( 'Herhangi bir sayfada aşağıya indikçe sidebar alanının yapışkan olarak scroll hareketinizi takip etmesini sağlar.', 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'sidebar'
			),
			array(
			   'id'          => 'geo-onay',
				'desc'				=> 'Onaylı üyelikler için oluşturacağınız sayfayı seçin örneğin iletişim sayfası olabilir, onaylı üyelik tanıtımı tamamen size kalmış.',
			   'label'       => __('Onaylı Üyelik Sayfası', 'geo-admin'),
			   'std'         => '',
			   'type'        => 'page-select',
			   'section'     => 'pages',
			   'operator'    => 'and'
			),
			array(
			   'id'          => 'geo-trending',
				'desc'				=> '<a href="https://youtu.be/LRPy7v0GZ-M">Videoyu İzle</a>',
			   'label'       => __('Trendler Sayfası', 'geo-admin'),
			   'std'         => '',
			   'type'        => 'page-select',
			   'section'     => 'pages',
			   'operator'    => 'and'
			),
			array(
				'id'          => 'geo-trending-query',
			   'label'       => __( 'Trendler Sayfası - Sıralanma Şekli', 'geo-admin' ),
			   'std'         => 'default',
			   'type'        => 'select',
			   'section'     => 'pages',
			   'operator'    => 'and',
				'choices'     => array(
					array(
						'value'       => 'trend',
						'label'       => 'Trendlere Eklenen Yazılar',
						'src'         => ''
					),
					array(
						'value'       => 'views',
						'label'       => 'En Çok Okunan Yazılar',
						'src'         => ''
					),
				),
			),
			array(
			  'id'          => 'geo-favorites',
				'desc'				=> '<a href="https://youtu.be/LRPy7v0GZ-M">Videoyu İzle</a>',
			  'label'       => __('Favorimlerim Sayfası', 'geo-admin'),
			  'std'         => '',
			  'type'        => 'page-select',
			  'section'     => 'pages',
			  'operator'    => 'and'
			),
			array(
			   'id'          => 'geo-posting',
				'desc'				=> '<a href="https://youtu.be/LRPy7v0GZ-M">Videoyu İzle</a>',
				'label'       =>__('Yazı Gönder Sayfası', 'geo-admin'),
			   'std'         => '',
			   'type'        => 'page-select',
			   'section'     => 'pages',
			   'operator'    => 'and'
			),
			array(
			   'id'          => 'geo-register',
				'desc'				=> '<a href="https://youtu.be/LRPy7v0GZ-M">Videoyu İzle</a>',
				'label'       => __('Kayıt Ol Sayfası', 'geo-admin'),
			   'std'         => '',
			   'type'        => 'page-select',
			   'section'     => 'pages',
			   'operator'    => 'and'
			),
			array(
				'id'          => 'geo-forgot',
				'desc'				=> '<a href="https://youtu.be/LRPy7v0GZ-M">Videoyu İzle</a>',
				'label'       => __('Şifremi Unuttum Sayfası', 'geo-admin'),
			   'std'         => '',
			   'type'        => 'page-select',
			   'section'     => 'pages',
			   'operator'    => 'and'
			),
			array(
			   'id'          => 'geo_profile',
				'desc'				=> '<a href="https://youtu.be/LRPy7v0GZ-M">Videoyu İzle</a>',
				'label'       => __('Profilimi Düzenle Sayfası', 'geo-admin'),
			   'std'         => '',
			   'type'        => 'page-select',
			   'section'     => 'pages',
			   'operator'    => 'and'
			),
			array(
				'id'          => 'geo_user_ranking',
				'desc'				=> '<a href="https://youtu.be/LRPy7v0GZ-M">Videoyu İzle</a>',
				'label'       => __('Üye Puanları Sayfası', 'geo-admin'),
			   'std'         => '',
			   'type'        => 'page-select',
			   'section'     => 'pages',
			   'operator'    => 'and'
			),
			array(
				'id'		=> 'geo_user_ranking_role',
				'label'		=> __( 'Üye Puanları Sayfasında Listelenecek Kullanıcıların Rolü', 'geo-admin' ),
				'std'		=> -1,
				'type'		=> 'select',
				'section'	=> 'pages',
				'choices'     => array(
					array(
						'value'       => -1,
						'label'       => __( 'Hepsi', 'geo-admin' ),
						'src'         => ''
					),
					array(
						'value'       => 'subscriber',
						'label'       => __( 'Abone', 'geo-admin' ),
						'src'         => ''
					),
					array(
						'value'       => 'contributor',
						'label'       => __( 'İçerik Sağlayıcı', 'geo-admin' ),
						'src'         => ''
					),
					array(
						'value'       => 'editor',
						'label'       => __( 'Editör', 'geo-admin' ),
						'src'         => ''
					),
					array(
						'value'       => 'administrator',
						'label'       => __( 'Yönetici', 'geo-admin' ),
						'src'         => ''
					),
				),
			),
			array(
				'id'		=> 'geo-wp-head',
				'label'		=> __( 'Head Kodları', 'geo-admin' ),
				'desc'		=> __( 'Buraya eklenen kodlar < head > etiketi içerisine eklenir.', 'geo-admin' ),
				'type'		=> 'textarea-simple',
				'rows'       => '10',
				'section'	=> 'general',
				'operator' => 'and'
			),
			array(
				'id'		=> 'geo-google-analytics',
				'label'		=> __( 'Footer Kodları', 'geo-admin' ),
				'type'		=> 'textarea-simple',
				'rows'       => '10',
				'section'	=> 'general',
				'operator' => 'and'
			),
			array(
				'id'		=> 'block_title_style',
				'label'		=>  __( 'Blok Başlık Görünümü', 'geo-admin' ),
				'std'		=> 'default',
				'type'		=> 'select',
				'section'	=> 'blok',
				
				'choices'	=> array(
					array(
						'value'		=> 'default',
						'label'		=> __('Varsayılan', 'geo-admin')
					),
					array(
						'value'		=> 'style-2',
						'label'		=> __('Görünüm', 'geo-admin').' #2'
					),
					array(
						'value'		=> 'style-3',
						'label'		=> __('Görünüm', 'geo-admin').' #3'
					),
					array(
						'value'		=> 'style-4',
						'label'		=> __('Görünüm', 'geo-admin').' #4'
					),
					array(
						'value'		=> 'style-5',
						'label'		=> __('Görünüm', 'geo-admin').' #5'
					),
				)
			),
			array(
				'id'		=> 'recent_posts_title',
				'label'		=>  __( 'Son Yazılar Başlığı', 'geo-admin' ),
				'desc'		=>  __( 'Anasayfada son yazıların listelendiği kısmın başlığını belirleyin.', 'geo-admin' ),
				'type'		=> 'textarea-simple',
				'rows'		=> '1',
				'section'	=> 'blok',
			),
			array(
				'id'		=> 'blog_layout',
				'label'		=>  __( 'Son Yazıların Görünümü (Anasayfa)', 'geo-admin' ),
				'std'		=> 'blog-list',
				'type'		=> 'radio-image',
				'section'	=> 'blok',				
				'choices'	=> array(
					array(
						'value'		=> 'blog-list',
						'label'		=> 'Standart List',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/blog-list.png'
					),
					array(
						'value'		=> 'blog-masonry',
						'label'		=> 'İkili Grid',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/blog-masonry.png'
					),
					array(
						'value'		=> 'blog-masonry2',
						'label'		=> 'İkili Grid #2',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/blog-masonry2.png'
					),
					array(
						'value'		=> 'blog-grid',
						'label'		=> 'Üçlü Grid',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/blog-grid.png'
					),
					array(
						'value'		=> 'blog-big',
						'label'		=> 'Klasik',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/blog-big.png'
					),
					array(
						'value'		=> 'blog-timeline',
						'label'		=> 'Timeline',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/blog-timeline.png'
					),
					array(
						'value'		=> 'off',
						'label'		=> 'Off',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/off.png'
					),
				)
			),
			array(
				'id'		=> 'blog_archives_layout',
				'label'		=>  __( 'Son Yazıların Görünümü (Diğer Sayfalar)', 'geo-admin' ),
				'std'		=> 'blog-list',
				'type'		=> 'radio-image',
				'section'	=> 'blok',
				'choices'	=> array(
					array(
						'value'		=> 'blog-list',
						'label'		=> 'Standart List',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/blog-list.png'
					),
					array(
						'value'		=> 'blog-masonry',
						'label'		=> 'İkili Grid',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/blog-masonry.png'
					),
					array(
						'value'		=> 'blog-masonry2',
						'label'		=> 'İkili Grid #2',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/blog-masonry2.png'
					),
					array(
						'value'		=> 'blog-grid',
						'label'		=> 'Üçlü Grid',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/blog-grid.png'
					),
					array(
						'value'		=> 'blog-big',
						'label'		=> 'Klasik',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/blog-big.png'
					),
					array(
						'value'		=> 'blog-timeline',
						'label'		=> 'Timeline',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/blog-timeline.png'
					),
				)
			),
			array(
				'id'		=> 'slider_select',
				'label'		=>  __( 'Görünüm', 'geo-admin' ),
				'std'		=> 'head-layout-0',
				'type'		=> 'radio-image',
				'section'	=> 'featured',
				'choices'	=> array(
					array(
						'value'		=> 'off',
						'label'		=> 'Off',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/off.png'
					),
					array(
						'value'		=> 'slider-style1',
						'label'		=> 'Carousel',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/slider/carousel.png'
					),
					array(
						'value'		=> 'slider-style4',
						'label'		=> 'Carousel-2',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/slider/carousel-2.png'
					),
					array(
						'value'		=> 'slider-style6',
						'label'		=> 'Carousel-3',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/slider/carousel-3.png'
					),
					array(
						'value'		=> 'slider-style8',
						'label'		=> 'Carousel-4',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/slider/carousel-4.png'
					),
					array(
						'value'		=> 'slider-style9',
						'label'		=> 'Carousel-5',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/slider/carousel-5.png'
					),
					array(
						'value'		=> 'slider-style10',
						'label'		=> 'Carousel-6',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/slider/carousel-6.png'
					),
					array(
						'value'		=> 'slider-style11',
						'label'		=> 'Carousel-7',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/slider/carousel-7.png'
					),
					array(
						'value'		=> 'slider-style2',
						'label'		=> 'Right to Left',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/slider/slider.png'
					),
					array(
						'value'		=> 'slider-style3',
						'label'		=> 'Standart Slider',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/slider/slider-2.png'
					),
					array(
						'value'		=> 'slider-style5',
						'label'		=> 'Right to Left 2',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/slider/slider-3.png'
					),
					array(
						'value'		=> 'slider-style7',
						'label'		=> 'Standart Slider 2',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/slider/slider-4.png'
					)
				)
			),
			array(
				'id'		=> 'slider_select_cat',
				'label'		=>  __( 'Görünüm (Kategori Sayfası)', 'geo-admin' ),
				'std'		=> 'off',
				'class'		=> 'yeni',
				'type'		=> 'radio-image',
				'section'	=> 'featured',
				'choices'	=> array(
					array(
						'value'		=> 'off',
						'label'		=> 'Off',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/off.png'
					),
					array(
						'value'		=> 'slider-style1',
						'label'		=> 'Carousel',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/slider/carousel.png'
					),
					array(
						'value'		=> 'slider-style4',
						'label'		=> 'Carousel-2',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/slider/carousel-2.png'
					),
					array(
						'value'		=> 'slider-style6',
						'label'		=> 'Carousel-3',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/slider/carousel-3.png'
					),
					array(
						'value'		=> 'slider-style8',
						'label'		=> 'Carousel-4',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/slider/carousel-4.png'
					),
					array(
						'value'		=> 'slider-style9',
						'label'		=> 'Carousel-5',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/slider/carousel-5.png'
					),
					array(
						'value'		=> 'slider-style10',
						'label'		=> 'Carousel-6',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/slider/carousel-6.png'
					),
					array(
						'value'		=> 'slider-style11',
						'label'		=> 'Carousel-7',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/slider/carousel-7.png'
					),
					array(
						'value'		=> 'slider-style2',
						'label'		=> 'Right to Left',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/slider/slider.png'
					),
					array(
						'value'		=> 'slider-style3',
						'label'		=> 'Standart Slider',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/slider/slider-2.png'
					),
					array(
						'value'		=> 'slider-style5',
						'label'		=> 'Right to Left 2',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/slider/slider-3.png'
					),
					array(
						'value'		=> 'slider-style7',
						'label'		=> 'Standart Slider 2',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/slider/slider-4.png'
					)
				)
			),
			array(
				'id'		=> 'slider_container',
				'label'		=> __( 'Genişlik', 'geo-admin' ),
				'std'		=> 'wide',
				'type'		=> 'select',
				'section'	=> 'featured',
				'choices'     => array(
				  array(
					'value'       => 'wide',
					'label'       => __( 'Tam Genişlik', 'geo-admin' ),
					'src'         => ''
				  ),
				  array(
					'value'       => 'boxed',
					'label'       => __( 'Daraltılmış', 'geo-admin' ),
					'src'         => ''
				  ),
				)
			),
			array(
				'id'			=> 'geo_slider_count',
				'label'			=> __('Gösterilecek Yazı Sayısı', 'geo-admin'),
				'std'			=> '6',
				'condition'   => 'slider_select:is(slider-style2),slider_select:is(slider-style3),slider_select:is(slider-style4),slider_select:is(slider-style5),slider_select:is(slider-style6),slider_select:is(slider-style7)',
				'type'			=> 'numeric-slider',
				'section'		=> 'featured',
				'min_max_step'	=> '0,20,1',
				'operator'    => 'OR'
			),
			array(
				'id'		=> 'geoit_exclude_featured_posts_for_recent_posts',
				'label'		=> __( 'Öne Çıkan Yazıları Son Yazılardan Çıkart', 'geo-admin' ),
				'std'		=> 'off',
				'type'		=> 'on-off',
				'section'	=> 'featured'
			),
			array(
				'id'		=> 'geoit_exclude_featured_posts_for_recent_posts_cat',
				'label'		=> __( 'Öne Çıkan Yazıları Son Yazılardan Çıkart (Kategori Sayfası)', 'geo-admin' ),
				'std'		=> 'off',
				'class'		=> 'yeni',
				'type'		=> 'on-off',
				'section'	=> 'featured'
			),
			array(
				'id'		=> 'slider_mask',
				'label'		=> __( 'Renk Cümbüşü', 'geo-admin' ),
				'std'		=> 'off',
				'type'		=> 'on-off',
				'section'	=> 'featured'
			),
			array(
				'id'		=> 'slider_author',
				'label'		=> __( 'Yazar', 'geo-admin' ),
				'desc'		=> __( 'Slider&Carousel kısmında yazının yazarını göstermek istiyorsanız anahtarı "on" durumuna getirin.', 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'featured'
			),
			array(
				'id'		=> 'slider_cats',
				'label'		=> __( 'Kategori Butonu', 'geo-admin' ),
				'desc'		=> __( 'Slider&Carousel kısmında yazı başlığının üstünde bulunan kategori butonunu göstermek istiyorsanız anahtarı "on" durumuna getirin.', 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'featured'
			),
			array(
				'id'		=> 'slider_meta_items',
				'label'		=> __( 'Yazı Meta', 'geo-admin' ),
				'desc'		=> __( 'Slider&Carousel kısmında yazı başlığının altında bulunan yazar, yazı tarihi gibi bilgilerin yer aldığı kısımları göstermek istiyorsanız anahtarı "on" durumuna getirin.', 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'featured'
			),
			
			array(
				'id'          => 'geo-carousel-category',
				'label'       => __( 'Kategori Seç', 'geo-admin' ),
				'std'         => '',
				'type'        => 'category-checkbox',
				'section'     => 'featured',
				'operator'    => 'and'
			),
			
			array(
				'id'		=> 'geo-carousel-post-not2',
				'label'			=> __('Hariç Tutulan Yazılar', 'geo-admin'),
				'desc'			=> __('Sliderda gözükmesini istemediğiniz yazıların id\'sini girin. Numaraları virgül ile ayırın.<br> <strong>Yazının IDsi:</strong> (Yazıyı Düzenlerken tarayıcıdaki url): siteadresiniz.com/wp-admin/post.php?post=<strong style="color:red">58</strong>&action=edit', 'geo-admin'),
				'type'		=> 'textarea-simple',
				'section'	=> 'featured',
				'rows'		=> 1,
			),
			
			array(
				'id'		=> 'cat_link_style',
				'label'		=>  __( 'Kategori Buton Görünümü', 'geo-admin' ),
				'std'		=> 'default',
				'type'		=> 'select',
				'section'	=> 'blok',
				
				'choices'	=> array(
					array(
						'value'		=> 'default',
						'label'		=> __('Varsayılan', 'geo-admin')
					),
					array(
						'value'		=> 'style-2',
						'label'		=> __('Görünüm', 'geo-admin').' #2'
					)
				)
			),
			array(
				'id'			=> 'excerpt-length',
				'label'			=> __('Yazı özetinin kelime limitini belirleyin.', 'geo-admin'),
				'std'			=> '15',
				'type'			=> 'numeric-slider',
				'section'		=> 'blok',
				'min_max_step'	=> '0,40,1',
				'operator'    => 'and'
			),
			
			array(
			  'id'          => 'geot_posts_pagination',
			  'label'       => __( 'Yazı Sayfalama Şekli', 'geo-admin' ),
			  'std'         => 'numbers',
			  'type'        => 'select',
			  'section'     => 'blok',
			  'operator'    => 'and',
				'choices'     => array(
					array(
					'value'       => 'number',
					'label'       => __( 'Numaralı', 'geo-admin' ),
					'src'         => ''
					),
					array(
					'value'       => 'load_more',
					'label'       => __( 'Daha Fazla Yükle', 'geo-admin' ),
					'src'         => ''
					),
					array(
					'value'       => 'infinite_scroll',
					'label'       => __( 'Aşağı İndikçe Yükle', 'geo-admin' ),
					'src'         => ''
					),
				),
			),
			
			array(
				'id'		=> 'geoit_post_author',
				'label'		=> __( 'Yazar', 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'blok'
			),
			array(
				'id'		=> 'geoit_post_meta',
				'label'		=> __( 'Yazı Metaları', 'geo-admin' ),
				'desc'		=> __( 'Off durumunda son yazılarda sadece yazı görseli, başlığı ve açıklaması gözükür diğer detaylar kaldırılır.', 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'blok'
			),
			array(
				'id'		=> 'geo_trending_status',
				'label'		=> __( 'Trendlerdeki Yazı Yazısı', 'geo-admin' ),
				'desc'	=> __('Trendlere eklediğiniz yazıya "trend ikonunu" eklemek istiyorsanız anahtarı "on" durumuna getirin.', 'geo-admin'),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'blok'
			),
			array(
				'id'		=> 'geo_block_views',
				'label'		=> __( 'Yazıların Okunma Sayısı', 'geo-admin' ),
				'desc'		=> __( 'Yazının okunma sayısı yazı detaylarında gösterir.', 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'blok'
			),
			
			array(
				'id'		=> 'geo-breadcrumb',
				'label'		=> __( 'Breadcrumb', 'geo-admin' ),
				'desc'		=> __( 'Yazının en üstünde ziyaretçilerin hangi sayfada olduğunu gösteren alan.', 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'blog'
			),
			array(
				'id'		=> 'more-in-cat',
				'label'		=> __( 'İlginizi Çekebilir', 'geo-admin' ),
				'desc'		=> __( 'Ziyaretçinin okuduğu yazı ile en alakalı olan yazıyı sağ altta gösterir.', 'geo-admin' ),
				'std'		=> 'off',
				'type'		=> 'on-off',
				'section'	=> 'blog'
			),
			array(
				'id'		=> 'geo_post_views',
				'label'		=> __( 'Yazıların Okunma Sayısı', 'geo-admin' ),
				'desc'		=> __( 'Yazının okunma sayısı yazı detaylarında gösterir.', 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'blog'
			),
			array(
				'id'		=> 'social_share',
				'label'		=>  __( 'Paylaş Butonları (Yazı İçin)', 'geo-admin' ),
				'std'		=> 'default',
				'type'		=> 'radio-image',
				'section'	=> 'blog',
				'choices'	=> array(
					array(
						'value'		=> 'default',
						'label'		=> __('Varsayılan', 'geo-admin'),
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/social/style_1.png'
					),
					array(
						'value'		=> 'style-2',
						'label'		=> __('Görünüm', 'geo-admin').' #2',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/social/style_2.png'
					),
					array(
						'value'		=> 'style-3',
						'label'		=> __('Görünüm', 'geo-admin').' #3',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/social/style_3.png'
					),
					array(
						'value'		=> 'off',
						'label'		=> __('Kapalı', 'geo-admin'),
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/off.png'
					),
				)
			),
			array(
				'id'		=> 'social_share_page',
				'label'		=>  __( 'Paylaş Butonları (Sayfa İçin)', 'geo-admin' ),
				'std'		=> 'default',
				'type'		=> 'radio-image',
				'section'	=> 'blog',
				'choices'	=> array(
					array(
						'value'		=> 'default',
						'label'		=> __('Varsayılan', 'geo-admin'),
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/social/style_1.png'
					),
					array(
						'value'		=> 'style-2',
						'label'		=> __('Görünüm', 'geo-admin').' #2',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/social/style_2.png'
					),
					array(
						'value'		=> 'style-3',
						'label'		=> __('Görünüm', 'geo-admin').' #3',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/social/style_3.png'
					),
					array(
						'value'		=> 'off',
						'label'		=> __('Kapalı', 'geo-admin'),
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/off.png'
					),
				)
			),
			array(
				'id'		=> 'geo_post_share_links',
				'label'		=> __( 'Sosyal Paylaşım Siteleri', 'geo-admin' ),
				'desc'		=> __( 'Yazı paylaş alanlarında gözükmesini istediğiniz sosyal paylaşım sitelerini belirleyin.', 'geo-admin' ),
				'std'		=> array('facebook', 'twitter', 'whatsapp', 'email'),
				'type'		=> 'checkbox',
				'section'	=> 'blog',
				'choices'      => array(
					array(
						'value' => 'facebook',
						'label' => 'Facebook',
						'src'   => '',
					),
					array(
						'value' => 'twitter',
						'label' => 'Twitter',
						'src'   => '',
					),
					array(
						'value' => 'whatsapp',
						'label' => 'Whatsapp',
						'src'   => '',
					),
					array(
						'value' => 'pinterest',
						'label' => 'Pinterest',
						'src'   => '',
					),
					array(
						'value' => 'linkedin',
						'label' => 'Linkedin',
						'src'   => '',
					),
					array(
						'value' => 'telegram',
						'label' => 'Telegram',
						'src'   => '',
					),
					array(
						'value' => 'email',
						'label' => 'E Posta',
						'src'   => '',
					),
				),
			),
			
			array(
				'id'		=> 'geo_post_share_mobile',
				'label'		=> __( 'Paylaş Butonları (Mobil)', 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'blog'
			),
			array(
				'id'		=> 'geo_post_share_links_mobile',
				'label'		=> __( 'Sosyal Paylaşım Siteleri (Mobil)', 'geo-admin' ),
				'desc'		=> __( 'Yazı paylaş alanlarında gözükmesini istediğiniz sosyal paylaşım sitelerini belirleyin.', 'geo-admin' ),
				'std'		=> array('facebook', 'twitter', 'whatsapp', 'email'),
				'type'		=> 'checkbox',
				'section'	=> 'blog',
				'condition'   => 'geo_post_share_mobile:not(off)',
				'choices'      => array(
					array(
						'value' => 'facebook',
						'label' => 'Facebook',
						'src'   => '',
					),
					array(
						'value' => 'twitter',
						'label' => 'Twitter',
						'src'   => '',
					),
					array(
						'value' => 'whatsapp',
						'label' => 'Whatsapp',
						'src'   => '',
					),
					array(
						'value' => 'pinterest',
						'label' => 'Pinterest',
						'src'   => '',
					),
					array(
						'value' => 'linkedin',
						'label' => 'Linkedin',
						'src'   => '',
					),
					array(
						'value' => 'telegram',
						'label' => 'Telegram',
						'src'   => '',
					),
					array(
						'value' => 'email',
						'label' => 'E Posta',
						'src'   => '',
					),
				),
			),
			array(
				'id'		=> 'related-posts-styles',
				'label'		=>  __( 'Benzer Yazılar', 'geo-admin' ),
				'desc'		=>  __( 'Benzer yazıların görünümünü ve durumu ayarlayabilirsiniz.', 'geo-admin' ),
				'std'		=> 'blog-grid',
				'type'		=> 'radio-image',
				'section'	=> 'blog',
				'choices'	=> array(
					array(
						'value'		=> 'blog-list',
						'label'		=> 'Standart List',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/blog-list.png'
					),
					array(
						'value'		=> 'blog-masonry',
						'label'		=> 'Masonry',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/blog-masonry.png'
					),
					array(
						'value'		=> 'blog-grid',
						'label'		=> 'Grid',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/blog-grid.png'
					),
					array(
						'value'		=> 'blog-masonry2',
						'label'		=> 'Masonry 2',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/blog-masonry2.png'
					),
					array(
						'value'		=> 'off',
						'label'		=> __('Kapalı', 'geo-admin'),
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/off.png'
					),
				)
			),
			array(
				'id'			=> 'related_count',
				'label'			=> __('Benzer Yazı Sayısı', 'geo-admin'),
				'std'			=> '6',
				'condition'   => 'related-posts-styles:not(off)',
				'type'			=> 'numeric-slider',
				'section'		=> 'blog',
				'min_max_step'	=> '0,10,1',
				'operator'    => 'and'
			),
			array(
				'id'          => 'related_order',
				'label'       => __( 'Benzer Yazıların Sıralanışı', 'geo-admin' ),
				'std'         => 'random-posts',
				'type'        => 'select',
				'section'     => 'blog',
				'operator'    => 'and',
				'choices'     => array( 
					array(
						'value'       => 'random-posts',
						'label'       => __( 'Rastgele', 'geo-admin' ),
						'src'         => ''
					),
					array(
						'value'       => 'recent-posts',
						'label'       => __( 'Yayın Tarihi', 'geo-admin' ),
						'src'         => ''
					),
					array(
						'value'       => 'most-commented',
						'label'       => __( 'Yorum Sayısı', 'geo-admin' ),
						'src'         => ''
					),
					array(
						'value'       => 'most-viewed',
						'label'       => __( 'Okunma Sayısı', 'geo-admin' ),
						'src'         => ''
					),
					array(
						'value'       => 'tags',
						'label'       => __( 'Etikete Göre', 'geo-admin' ),
						'src'         => ''
					)
				)
			),
			array(
				'id'		=> 'author-box',
				'label'		=> __( 'Yazar Kutusu', 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'blog'
			),
			array(
				'id'		=> 'reading-time',
				'label'		=> __( 'Okuma Süresi', 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'blog'
			),
			array(
				'id'		=> 'yorum-yap',
				'label'		=> __( 'Yorum Yap Butonu', 'geo-admin' ),
				'std'		=> 'on',

				'type'		=> 'on-off',
				'section'	=> 'blog'
			),
			array(
				'label'       => __( 'Adblock Yakalayıcısı', 'geo-admin' ),
				'id'          => 'adblock_detecter',
				'type'				=> 'on-off',
				'section'			=> 'ads',
				'std'					=> 'off',
				'operator'    => 'and',
			),
			array(
				'label'       => __( 'Adblock Yakalayıcısı için Kısa Yazı', 'geo-admin' ),
				'id'          => 'adblock_text',
				'type'				=> 'textarea',
				'section'			=> 'ads',
				'std'					=> __('Lütfen reklam engelleyiciyi devre dışı bırakarak bizi desteklemeyi düşünün.', 'geo-admin'),
				'operator'    => 'and',
			),
			array(
				'id'		=> 'geo-1-ads',
				'label'		=> __( 'Header Reklam', 'geo-admin' ),
				'desc'    => 'HTML Kod Kullanın <code>728x90, 468x60</code>',
				'type'		=> 'textarea-simple',
				'rows'       => '6',
				'section'	=> 'ads',
				'operator' => 'and'
			),
			array(
				'id'		=> 'geo-1-ads-m',
				'label'		=> __( 'Header Reklam (Mobil)', 'geo-admin' ),
				'desc'    => 'HTML Kod Kullanın <code>728x90, 468x60vb</code>',
				'type'		=> 'textarea-simple',
				'rows'       => '6',
				'section'	=> 'ads',
				'operator' => 'and'
			),
			array(
				'id'		=> 'geo-28-ads',
				'label'		=> __( 'Öne Çıkan Görsel Yanı', 'geo-admin' ),
				'desc'    => 'HTML Kod Kullanın <code>Max: Yükseklik 250px</code>',
				'type'		=> 'textarea-simple',
				'rows'       => '6',
				'section'	=> 'ads',
				'operator' => 'and'
			),
			array(
				'id'		=> 'geo-2-ads',
				'label'		=> __( 'Yazı Başlangıç', 'geo-admin' ),
				'desc'    => 'HTML Kod Kullanın <code>728x90, 468x60, 300x250, 150x125vb</code>',
				'type'		=> 'textarea-simple',
				'rows'       => '6',
				'section'	=> 'ads',
				'operator' => 'and'
			),
			
			array(
				'id'		=> 'geo-2-ads-m',
				'label'		=> __( 'Yazı Başlangıç (Mobil)', 'geo-admin' ),
				'desc'    => 'HTML Kod Kullanın <code>728x90, 468x60, 300x250, 150x125vb</code>',
				'type'		=> 'textarea-simple',
				'rows'       => '6',
				'section'	=> 'ads',
				'operator' => 'and'
			),
			array(
				'id'		=> 'geo-3-ads',
				'label'		=> __( 'Yazı Sonu', 'geo-admin' ),
				'desc'    => 'HTML Kod Kullanın <code>728x90, 468x60, 300x250, 150x125vb</code>',
				'type'		=> 'textarea-simple',
				'rows'       => '6',
				'section'	=> 'ads',
				'operator' => 'and'
			),
			array(
				'id'		=> 'geo-3-ads-m',
				'label'		=> __( 'Yazı Sonu (Mobil)', 'geo-admin' ),
				'desc'    => 'HTML Kod Kullanın <code>728x90, 468x60, 300x250, 150x125 vb</code>',
				'type'		=> 'textarea-simple',
				'rows'       => '6',
				'section'	=> 'ads',
				'operator' => 'and'
			),
			array(
				'id'		=> 'ad_single_aut',
				'label'		=> __( 'Yazı Arasına Reklam', 'geo-admin' ),
				'desc'    => 'HTML Kod Kullanın <code>728x90, 468x60 vb.</code>',
				'type'		=> 'textarea-simple',
				'rows'       => '6',
				'section'	=> 'ads',
				'operator' => 'and'
			),
			array(
				'id'			=> 'sp_ad_position',
				'label'			=> __('Yazı Arasına Reklam Paragraf Ayarlarma', 'geo-admin'),
				'desc'			=> __('Reklamınızın kaçıncı paragraftan sonra gözükmesini istediğinizi seçin.', 'geo-admin'),
				'std'			=> '2',
				'type'			=> 'numeric-slider',
				'section'		=> 'ads',
				'min_max_step'	=> '1,20,1',
				'operator'    => 'and'
			),
			array(
				'id'		=> 'geo-4-ads',
				'label'		=> __( 'Yazı/Sayfa - Kısakod', 'geo-admin' ),
				'desc'    => 'HTML Kod Kullanın <code>728x90, 468x60, 300x250, 150x125</code> Yazı veya sayfada örnek kullanım <code>[geo_ad]</code>',
				'type'		=> 'textarea-simple',
				'rows'       => '6',
				'section'	=> 'ads',
				'operator' => 'and'
			),
			array(
				'id'		=> 'geo-4-1-ads',
				'label'		=> __( 'Yazı/Sayfa - Kısakod', 'geo-admin' ).' #2',
				'desc'    => 'HTML Kod Kullanın <code>728x90, 468x60, 300x250, 150x125</code> Yazı veya sayfada örnek kullanım <code>[geo_ad2]</code>',
				'type'		=> 'textarea-simple',
				'rows'       => '6',
				'section'	=> 'ads',
				'operator' => 'and'
			),
			array(
				'id'		=> 'geo-4-2-ads',
				'label'		=> __( 'Yazı/Sayfa - Kısakod', 'geo-admin' ).' #3',
				'desc'    => 'HTML Kod Kullanın <code>728x90, 468x60, 300x250, 150x125</code> Yazı veya sayfada örnek kullanım <code>[geo_ad3]</code>',
				'type'		=> 'textarea-simple',
				'rows'       => '6',
				'section'	=> 'ads',
				'operator' => 'and'
			),
			array(
				'id'		=> 'geo-5-ads',
				'label'		=> __( 'Son Yazıların Başına', 'geo-admin' ),
				'desc'    => 'İkinci yazı olarak gözükür.',
				'type'		=> 'textarea-simple',
				'rows'       => '6',
				'section'	=> 'ads',
				'operator' => 'and'
			),
			array(
				'id'		=> 'geo-6-ads',
				'label'		=> __( 'Popup Reklam', 'geo-admin' ),
				'desc'    => 'Sayfanın en altında popup şeklinde gözükmektedir, reklam "x" butonuyla kapatıldığında bir daha gösterilmez. (7 Gün)',
				'type'		=> 'textarea-simple',
				'rows'       => '6',
				'section'	=> 'ads',
				'operator' => 'and'
			),
			array(
				'id'		   => 'geo-6-ads-mobile',
				'label'		 => __( 'Popup Reklam (Mobil)', 'geo-admin' ),
				'desc'     => 'Sayfanın en altında popup şeklinde gözükmektedir, reklam "x" butonuyla kapatıldığında bir daha gösterilmez. (7 Gün)',
				'type'		 => 'textarea-simple',
				'rows'     => '6',
				'section'	 => 'ads',
				'operator' => 'and'
			),
			
			array(
				'id'		=> 'head-layout-select',
				'label'		=>  __( 'Header Düzeni', 'geo-admin' ),
				'std'		=> 'head-layout-0',
				'type'		=> 'radio-image',
				'section'	=> 'header',
				'class'		=> '',
				'choices'	=> array(
					array(
						'value'		=> 'head-layout-0',
						'label'		=> __('Varsayılan', 'geo-admin'),
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/header.png'
					),
					array(
						'value'		=> 'head-layout-1',
						'label'		=> 'Header 1',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/header-1.png'
					),
					array(
						'value'		=> 'head-layout-2',
						'label'		=> 'Header 2',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/header-2.png'
					),
				)
			),
			array(
				'id'		=> 'navbar-sticky',
				'label'		=> __( 'Yapışkan Menü', 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'header'
			),
			array(
				'id'		=> 'header-trending',
				'label'		=> __( 'Trendlerdeki Yazılar', 'geo-admin' ),
				'std'		=> 'on',
				'condition'   => 'head-layout-select:is(head-layout-2)',
				'type'		=> 'on-off',
				'section'	=> 'header'
			),
			array(
				'id'		=> 'header-top-status',
				'label'		=> __( 'Header Üst', 'geo-admin' ),
				'std'		=> 'on',
				'condition'   => 'head-layout-select:not(head-layout-2)',
				'type'		=> 'on-off',
				'section'	=> 'header'
			),
			array(
				'id'		=> 'header-top-status-mobil',
				'label'		=> __( 'Mobilde Header Üstü Gizle', 'geo-admin' ),
				'std'		=> 'off',
				'class'		=> 'yeni',
				'condition' => 'header-top-status:not(off),head-layout-select:not(head-layout-2)',
				'operator' => 'and',
				'type'		=> 'on-off',
				'section'	=> 'header'
			),
			array(
			  'id'          => 'geo-header-top-left',
			  'label'       => __( 'Header Üst Sol Kısım', 'geo-admin' ),
			  'std'         => 'trends',
			  'type'        => 'select',
				'condition'   => 'header-top-status:not(off),head-layout-select:not(head-layout-2)',
				'operator' => 'and',
			  'section'     => 'header',
			  'operator'    => 'and',
			 'choices'     => array(
				 array(
					'value'       => 'trends',
					'label'       => __( 'Trendlerdeki Yazılar', 'geo-admin' ),
					'src'         => ''
				 ),
				 array(
					'value'       => 'date',
					'label'       => __( 'Günün Tarihi', 'geo-admin' ),
					'src'         => ''
				 ),
				 array(
					'value'       => 'menu',
					'label'       => __( 'Menü', 'geo-admin' ),
					'src'         => ''
				 ),
				),
			),
			array(
				'id'		=> 'header-top-social',
				'label'		=> __( 'Sosyal Medya Ikonları', 'geo-admin' ),
				'std'		=> 'on',
				'condition'   => 'header-top-status:not(off),head-layout-select:is(head-layout-2)',
				'operator' => 'or',
				'type'		=> 'on-off',
				'section'	=> 'header'
			),
			array(
				'id'		=> 'header_top_login',
				'label'		=> __( 'Üyelik Butonları', 'geo-admin' ),
				'std'		=> 'on',
				'condition'   => 'header-top-status:not(off),head-layout-select:is(head-layout-2)',
				'operator' => 'or',
				'type'		=> 'on-off',
				'section'	=> 'header'
			),
			array(
				'id'		=> 'header_dark_mode',
				'label'		=> __( 'Gece Modu Butonu', 'geo-admin' ),
				'std'		=> 'on',
				'condition'   => 'header-top-status:not(off),head-layout-select:is(head-layout-2)',
				'operator' => 'or',
				'type'		=> 'on-off',
				'section'	=> 'header'
			),
			array(
				'id'		=> 'social-links',
				'label'		=> __( 'Sosyal Medya', 'geo-admin' ),
				'type'		=> 'list-item',
				'section'	=> 'social',
				'choices'	=> array(),
				'settings'	=> array(
					array(
						'id'		=> 'social-icon',
						'label'		=> __('İkon İsmi', 'geo-admin'),
						'desc'		=> __('Örnek ikonlar için [<a href="https://kanthemes.com/files/geoit/fontello" target="_blank"><strong>Fontello</strong>]</a> adresini ziyaret edin. Örnek: <code>fa-facebook</code>', 'geo-admin'),
						'std'		=> 'fa-',
						'type'		=> 'text',
						'choices'	=> array()
					),
					array(
						'id'		=> 'social-link',
						'label'		=> 'Link',
						'std'		=> 'http://',
						'type'		=> 'text',
						'choices'	=> array()
					)
				)
			),
			array(
				'id'		=> 'geo_popup_box',
				'label'		=> __( 'Popup Durumu', 'geo-admin' ),
				'desc'		=> __( 'Sitenize giren herkesin görebileceği popup alanı yaratır, popup kapatılırsa 30 gün boyunca bir daha o kişi tarafından görülmez. (20sn sonra ortaya çıkar) Görünüm>Bileşenler>Popup bileşenine gözükmesini istediğiniz bileşeni ekleyin.', 'geo-admin' ),
				'type'		=> 'on-off',
				'std'		=> 'off',
				'section'	=> 'popup'
			),
			array(
				'id'		=> 'geo_cookie_box',
				'label'		=> __( 'Gizlilik politikası', 'geo-admin' ),
				'desc'		=> __( '(Sitenizin sol altında sitenize giren herkese gizlilik politikası bildiriminizi gösterebilirsiniz. Kabul ediyorum butonuna tıklandıktan sonra bir daha gözükmez.', 'geo-admin' ),
				'type'		=> 'on-off',
				'std'			=> 'off',
				'section'	=> 'popup'
			),
			array(
			   'id'          => 'geo_cookie_page',
			   'label'       => __('Gizlilik Politikaları Sayfası', 'geo-admin'),
			   'std'         => '',
			   'type'        => 'page-select',
			   'section'     => 'popup',
			   'operator'    => 'and'
			),
			array(
				'id'		=> 'footer-layout-select',
				'label'		=>  __( 'Footer Düzeni', 'geo-admin' ),
				'std'		=> '1',
				'type'		=> 'radio-image',
				'section'	=> 'footer',
				'choices'	=> array(
					array(
						'value'		=> '1',
						'label'		=> 'Footer 1',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/footer-1.png'
					),
					array(
						'value'		=> '2',
						'label'		=> 'Footer 2',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/footer-2.png'
					),
				)
			),
			array(
				'id'		=> 'footer-text',
				'label'		=> __( 'Footer Yazı', 'geo-admin' ),
				'std'		=> __( '© Copyright 2020, Tüm Hakları Saklıdır', 'geo-admin' ),
				'type'		=> 'textarea',
				'section'	=> 'footer'
			),
			array(
				'id'		=> 'geo-footerwidgets',
				'label'		=> __( 'Footer Bileşenler', 'geo-admin' ),
				'desc'		=> __( 'Sadece footer-1 görünümünde çalışır.', 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'footer'
			),
			array(
				'id'		=> 'geo-gotop',
				'label'		=> __( 'Yukarı Çık', 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'footer'
			),
			array(
			  'id'          => 'geo_postsubmit_status',
			  'label'       => __( 'Gönderilen Yazının Durumu', 'geo-admin' ),
			  'std'         => 'default',
			  'type'        => 'select',
			  'section'     => 'members',
			  'operator'    => 'and',
			 'choices'     => array(
				 array(
					'value'       => 'pending',
					'label'       => __( 'Onay Sürecinde', 'geo-admin' ),
					'src'         => ''
				 ),
				 array(
					'value'       => 'publish',
					'label'       => __( 'Yayınlandı', 'geo-admin' ),
					'src'         => ''
				 ),
				 array(
					'value'       => 'draft',
					'label'       => __( 'Taslak', 'geo-admin' ),
					'src'         => ''
				 ),
				 array(
					'value'       => 'private',
					'label'       => __( 'Özel', 'geo-admin' ),
					'src'         => ''
				 ),
					),
			),
			array(
				'id'		=> 'geo_admin_bar',
				'label'		=>  __( 'Üyelere Admin Panel Çubuğunu Gizle' , 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'members'
			),
			array(
				'id'		=> 'geo_admin_bar_2',
				'label'		=>  __( 'Yöneticilere Admin Panel Çubuğunu Gizle' , 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'members',
			),
			array(
				'id'		=> 'geo_yonlendirme',
				'label'		=>  __( 'Ziyaretçilerin Wp-admin\'e erişimini engelle' , 'geo-admin' ),
				'std'		=> 'off',
				'type'		=> 'on-off',
				'section'	=> 'members'
			),
			array(
				'id'		=> 'geo_wp_admin',
				'label'		=>  __( 'Normal Üyelerin Wp-admin\'e erişimini engelle' , 'geo-admin' ),
				'std'		=> 'off',
				'type'		=> 'on-off',
				'section'	=> 'members'
			),
			array(
				'id'		=> 'geo_favorites',
				'label'		=>  __( 'Favori Sistemi' , 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'members'
			),
			array(
				'id'		=> 'geo_favorites_guest',
				'label'		=>  __( 'Ziyaretçiler Favorilerine Ekleyebilsin' , 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'members'
			),
			array(
				'id'		=> 'geo_facebook_login',
				'label'		=>  __( 'Facebook ile Bağlan' , 'geo-admin' ),
				'desc'		=>  sprintf(__('Bu özelliği kullanmak için <a href="%1$splugin-install.php?tab=plugin-information&plugin=nextend-facebook-connect&TB_iframe=true&width=772&height=596">Nextend Social Login</a> eklentisini kurup gerekli ayarları yapmanız gerekmekte. <a href="%2$soptions-general.php?page=nextend-social-login&view=provider-facebook&subview=settings">Ayarları Yapın</a>' , 'geo-admin'),
					get_admin_url(),
					get_admin_url()
				),
				'std'		=> 'off',
				'type'		=> 'on-off',
				'section'	=> 'members'
			),
			array(
				'id'		=> 'geo_twitter_login',
				'label'		=>  __( 'Twitter ile Bağlan' , 'geo-admin' ),
				'desc'		=>  sprintf(__('Bu özelliği kullanmak için <a href="%1$splugin-install.php?tab=plugin-information&plugin=nextend-facebook-connect&TB_iframe=true&width=772&height=596">Nextend Social Login</a> eklentisini kurup gerekli ayarları yapmanız gerekmekte. <a href="%2$soptions-general.php?page=nextend-social-login&view=provider-twitter&subview">Ayarları Yapın</a>' , 'geo-admin'),
					get_admin_url(),
					get_admin_url()
				),
				'std'		=> 'off',
				'type'		=> 'on-off',
				'section'	=> 'members'
			),
			array(
				'id'		=> 'geo_google_login',
				'label'		=>  __( 'Google ile Bağlan' , 'geo-admin' ),
				'desc'		=>  sprintf(__('Bu özelliği kullanmak için <a href="%1$splugin-install.php?tab=plugin-information&plugin=nextend-facebook-connect&TB_iframe=true&width=772&height=596">Nextend Social Login</a> eklentisini kurup gerekli ayarları yapmanız gerekmekte. <a href="%2$soptions-general.php?page=nextend-social-login&view=provider-google&subview">Ayarları Yapın</a>' , 'geo-admin'),
					get_admin_url(),
					get_admin_url()
				),
				'std'		=> 'off',
				'type'		=> 'on-off',
				'section'	=> 'members'
			),
			array(
				'id'		  => 'geo_puan_sistem',
				'label'		=>  __( 'Puanlama Sistemi' , 'geo-admin' ),
				'std'		  => 'off',
				'type'		=> 'on-off',
				'section'	=> 'puan'
			),
			array(
				'id'		  => 'geo_puan_reset',
				'label'		=>  __( 'Puanları Sıfırla' , 'geo-admin' ),
				'std'		  => 'off',
				'type'		=> 'on-off',
				'section'	=> 'puan'
			),
			array(
				'id'		  => 'geo_puan_yazi',
				'label'		=>  __( 'Yazıya Verilecek Puan' , 'geo-admin' ),
				'std'		  => '10',
				'type'		=> 'numeric-slider',
				'rows'		=> '1',
				'section'	=> 'puan'
			),
			array(
				'id'		  => 'geo_puan_yorum',
				'label'		=>  __( 'Yoruma Verilecek Puan' , 'geo-admin' ),
				'std'		  => '5',
				'type'		=> 'numeric-slider',
				'rows'		=> '1',
				'section'	=> 'puan'
			),
			array(
				'id'		  => 'geo_puan_avatar',
				'label'		=>  __( 'Avatar Eklendiğinde Verilecek Puan' , 'geo-admin' ),
				'std'		  => '5',
				'type'		=> 'numeric-slider',
				'rows'		=> '1',
				'section'	=> 'puan'
			),
			array(
				'id'		  => 'geo_puan_cover',
				'label'		=>  __( 'Profil Arkaplanı Eklendiğinde Verilecek Puan' , 'geo-admin' ),
				'std'		  => '5',
				'type'		=> 'numeric-slider',
				'rows'		=> '1',
				'section'	=> 'puan'
			),
			array(
				'id'		=> 'geo_ranks',
				'label'		=> __( 'Puana Göre Ranklar', 'geo-admin' ),
				'type'		=> 'list-item',
				'section'	=> 'puan',
				'choices'	=> array(),
				'settings'	=> array(
					array(
						'id'		=> 'rank-min',
						'label'		=> __('Puan Aralığı #Minimum', 'geo-admin'),
						'desc'		=> __( 'Yarattığınız rankın minumum puan değeri. (Bir önceki rankta örneğin max değeri 50 yaptıysanız buradaki min değerini 51 yapmalısınız.)', 'geo-admin' ),
						'std'		=> '1',
						'rows'	=> 1,
						'type'		=> 'textarea-simple',
						'choices'	=> array()
					),
					array(
						'id'		=> 'rank-max',
						'label'		=> __('Puan Aralığı #Maksimum', 'geo-admin'),
						'desc'		=> __( 'Yarattığınız rankın maksimum puan değeri', 'geo-admin' ),
						'std'		=> '50',
						'rows'	=> 1,
						'type'		=> 'textarea-simple', 
						'choices'	=> array()
					),
					array(
						'id'		=> 'color',
						'label'		=> __('Renk', 'geo-admin'),
						'type'		=> 'colorpicker',
						'std'	=> '#22bb67',
						'choices'	=> array()
					)
				)
			),
			array(
				'id'		=> 'geo_role_ranks',
				'label'		=> __( 'Üyelik Rolüne Göre Ranklar', 'geo-admin' ),
				'type'		=> 'list-item',
				'section'	=> 'puan',
				'choices'	=> array(),
				'settings'	=> array(
					array(
						'id'		=> 'role',
						'label'		=> __('Üyenin Rolü', 'geo-admin'),
						'desc'		=> __( 'Seçilen üyelik rolüne rank ekler.', 'geo-admin' ),
						'std'		=> 'subscriber',
						'type'		=> 'select',
						'choices'     => array(
							array(
								'value'       => 'subscriber',
								'label'       => __( 'Abone', 'geo-admin' ),
								'src'         => ''
							),
							array(
								'value'       => 'contributor',
								'label'       => __( 'İçerik Sağlayıcı', 'geo-admin' ),
								'src'         => ''
							),
							array(
								'value'       => 'editor',
								'label'       => __( 'Editör', 'geo-admin' ),
								'src'         => ''
							),
							array(
								'value'       => 'administrator',
								'label'       => __( 'Yönetici', 'geo-admin' ),
								'src'         => ''
							),
					),
					),
					array(
						'id'		=> 'color',
						'label'		=> __('Renk', 'geo-admin'),
						'type'		=> 'colorpicker',
						'std'	=> '#22bb67',
						'choices'	=> array()
					)
				)
			),
			array(
				'id'		=> 'geoit_stories',
				'label'		=>  __( 'Hikaye Sistemi' , 'geo-admin' ),
				'std'		=> 'off',
				'type'		=> 'on-off',
				'section'	=> 'stories'
			),
			array(
				'id'		=> 'geoit_stories_page',
				'label'		=>  __( 'Her Sayfada Gözüksün' , 'geo-admin' ),
				'desc'		=>  __( 'Off durumunda sadece anasayfa\'da gözükür on durumunda tüm sayfalarda gözükür.' , 'geo-admin' ),
				'std'		=> 'off',
				'type'		=> 'on-off',
				'section'	=> 'stories'
			),
			array(
				'id'			=> 'geoit_stories_post',
				'label'			=> __('Gösterilecek Hikaye Sayısı', 'geo-admin'),
				'desc'			=> __('Kategori başına gösterilecek hikaye sayısı.', 'geo-admin'),
				'std'			=> '5',
				'type'			=> 'numeric-slider',
				'section'		=> 'stories',
				'min_max_step'	=> '0,20,1',
				'operator'    => 'and'
			),
			array(
				'id'		=> 'geoit_stories_time',
				'label'		=>  __( 'Son 24 Saati Baz Alsın' , 'geo-admin' ),
				'desc'		=>  __( 'On durumunda oluşturduğunuz kategorilerde son 24 saatte paylaşılan yazılar eklenir, off durumunda oluşturduğunuz kategorilerde yazıların yayınlanma tarihine bakılmaksızın son yazılar hikaye olarak eklenir.' , 'geo-admin' ),
				'std'		=> 'off',
				'type'		=> 'on-off',
				'section'	=> 'stories'
			),
			array(
				'id'			=> 'geoit_stories_dr',
				'label'			=> __('Geçiş Süresi', 'geo-admin'),
				'desc'			=> __('Hikayeler arası geçiş süresini ayarlayın (saniye)', 'geo-admin'),
				'std'			=> '5',
				'type'			=> 'numeric-slider',
				'section'		=> 'stories',
				'min_max_step'	=> '0,60,1',
				'operator'    => 'and'
			),
			array(
				'id'		=> 'geoit_story_cats',
				'label'		=> __( 'Hikaye Kategorisi Oluşturun', 'geo-admin' ),
				'type'		=> 'list-item',
				'section'	=> 'stories',
				'choices'	=> array(),
				'settings'	=> array(
					array(
						'id'          => 'id',
						'label'       => __( 'Kategori Seç', 'geo-admin' ),
						'std'         => '',
						'type'        => 'category-select',
						'operator'    => 'and'
					),
					array(
						'id'          => 'image',
						'label'       => __( 'Kategori Görseli', 'geo-admin' ),
						'desc'			=> __('Görsel boyutunun <code>90x90</code> ebatlarında olması tavsiye edilir.', 'geo-admin'),
						'std'         => '',
						'type'        => 'upload',
						'operator'    => 'and'
					),
				)
			),
			array(
				'id'		=> 'geoit_story_site',
				'label'		=> __( 'Özel Hikayeler', 'geo-admin' ),
				'desc'		=> __( 'Bu kısımda blog kategorilerinin dışında özel hikayeler oluşturabilirsiniz.', 'geo-admin' ),
				'type'		=> 'list-item',
				'section'	=> 'stories',
				'choices'	=> array(),
				'settings'	=> array(
					array(
						'id'		=> 'link',
						'label'		=> __( 'Link', 'geo-admin' ),
						'type'		=> 'textarea-simple',
						'rows'       => '1',
						'operator' => 'and'
					),
					array(
						'id'          => 'image',
						'label'       => __( 'Hikaye Görseli', 'geo-admin' ),
						'std'         => '',
						'type'        => 'upload',
						'operator'    => 'and'
					),
					array(
						'id'          => 'date',
						'label'       => __( 'Hikaye Tarihi', 'geo-admin' ),
						'std'         => '',
						'type'        => 'date-time-picker',
						'operator'    => 'and'
					),
				)
			),
			
			array(
				'id'			=> 'geoit_story_site_title',
				'label'			=> __('Özel Hikayelerinin Başlığı', 'geo-admin'),
				'desc'			=> __('Girmezseniz site adı gözükür.', 'geo-admin'),
				'type'        => 'textarea-simple',
				'section'		=> 'stories',
				'rows'		=> '1',
				'operator'    => 'and',
			),
			
			array(
				'id'			=> 'geoit_story_site_avatar',
				'label'			=> __('Özel Hikayelerinin Avatarı', 'geo-admin'),
				'desc'			=> __('Avatar boyutunun <code>90x90</code> ebatlarında olması tavsiye edilir.', 'geo-admin'),
				'type'        => 'upload',
				'section'		=> 'stories',
				'operator'    => 'and',
			),
			
			array(
				'id'		=> 'geoit_sidebar_mobile',
				'label'		=> __( 'Sidebar Mobilde Gözüksün', 'geo-admin' ),
				'type'		=> 'on-off',
				'std'		=> 'off',
				'section'	=> 'sidebar',
			),
			
			array(
				'id'		=> 'geoit_custom_sidebars',
				'label'		=> __( 'Özel Sidebar Oluştur', 'geo-admin' ),
				'type'		=> 'list-item',
				'section'	=> 'sidebar',
				'choices'	=> array(),
				'settings'	=> array(
					array(
						'id'		=> 'id',
						'label'		=> __( 'ID', 'geo-admin' ),
						'desc'		=> __( 'Benzersiz bir kimlik girin. (Türkçe karakter, boşluk, nokta, büyük harf kullanmayın <code>örnek: geoit-sidebar-1</code>)', 'geo-admin' ),
						'type'		=> 'textarea-simple',
						'rows'       => '1',
						'operator' => 'and'
					),
				)
			),
			
			array(
				'id'          => 'geoit-home-sidebar',
			    'label'       => __( 'Sidebar: Anasayfa', 'geo-admin' ),
				'std'          => '',
				'type'         => 'sidebar-select',
				'section'      => 'sidebar',
				'operator'     => 'and',
			),
			
			array(
				'id'          => 'geoit-post-sidebar',
			    'label'       => __( 'Sidebar: Yazı Sayfası', 'geo-admin' ),
				'std'          => '',
				'type'         => 'sidebar-select',
				'section'      => 'sidebar',
				'operator'     => 'and',
			),
			
			array(
				'id'          => 'geoit-page-sidebar',
			    'label'       => __( 'Sidebar: Normal Sayfa', 'geo-admin' ),
				'std'          => '',
				'type'         => 'sidebar-select',
				'section'      => 'sidebar',
				'operator'     => 'and',
			),
			array(
				'id'          => 'geoit-cat-sidebar',
			    'label'       => __( 'Sidebar: Kategori Sayfası', 'geo-admin' ),
				'std'          => '',
				'type'         => 'sidebar-select',
				'section'      => 'sidebar',
				'operator'     => 'and',
			),
			array(
				'id'          => 'geoit-tag-sidebar',
			    'label'       => __( 'Sidebar: Etiket Sayfası', 'geo-admin' ),
				'std'          => '',
				'type'         => 'sidebar-select',
				'section'      => 'sidebar',
				'operator'     => 'and',
			),
			
			// Reaction
			
			array(
				'id'		=> 'geo_react_status',
				'label'		=> __( 'Reaksiyon Butonları', 'geo-admin' ),
				'std'		=> 'off',
				'type'		=> 'on-off',
				'section'	=> 'reaction'
			),
			
			array(
				'id'		=> 'geo_post_emoji_show',
				'label'		=> __( 'En Çok Tıklanan Reaksiyon Butonu', 'geo-admin' ),
				'desc'	=> __('En çok tepki verilen reaksiyon butonunu yazı listeleme alanlarında görsellerinin herhangi bir alanında göstermek istiyorsanız anahtarı "on" durumuna getirin.', 'geo-admin'),
				'std'		=> 'off',
				'type'		=> 'on-off',
				'section'	=> 'reaction'
			),
			
			array(
				'id'		=> 'geo_post_emoji_title',
				'label'		=> __( 'Reaksiyon Butonlarının Başlığı', 'geo-admin' ),
				'type'		=> 'textarea-simple',
				'rows'		=> 1,
				'section'	=> 'reaction'
			),
			
			array(
				'id'		=> 'geoit_create_reaction_emoji',
				'label'		=> __( 'Emoji Oluşturun', 'geo-admin' ),
				'type'		=> 'list-item',
				'section'	=> 'reaction',
				'choices'	=> array(),
				'settings'	=> array(
					array(
						'id'		=> 'emoji',
						'label'		=> __( 'Emoji', 'geo-admin' ),
						'type'		=> 'upload',
						'rows'       => '1',
						'operator' => 'and'
					),
				)
			),
			
			array(
				'id'		=> 'geoit_comments_closed',
				'label'		=>  __( 'Tüm Yazıları Yoruma Kapat' , 'geo-admin' ),
				'std'		=> 'off',
				'type'		=> 'on-off',
				'section'	=> 'comments'
			),
			array(
				'id'		=> 'geoit_comment_website',
				'label'		=>  __( 'Yorumlarda Web Site Alanı' , 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'comments'
			),
			array(
				'id'			=> 'comment_title',
				'label'			=> __('Yorum Yap Başlığı Yazısı', 'geo-admin'),
				'rows'			=> '1',
				'type'			=> 'textarea-simple',
				'section'		=> 'comments',
				'operator'    => 'and'
			),
			array(
				'id'			=> 'geoit_comment_submit_btn_text',
				'label'			=> __('Yorum Gönder Butonu Yazısı', 'geo-admin'),
				'rows'			=> '1',
				'type'			=> 'textarea-simple',
				'section'		=> 'comments',
				'operator'    => 'and'
			),
			array(
				'id'			=> 'geoit_comments_closed_text',
				'label'			=> __('Yoruma Kapatılan Yazıların Açıklaması', 'geo-admin'),
				'rows'			=> '2',
				'type'			=> 'textarea-simple',
				'section'		=> 'comments',
				'operator'    => 'and'
			),
			array(
				'id'		=> 'geo-amp-wp-head',
				'label'		=> __( 'Head Kodları', 'geo-admin' ),
				'desc'		=> __( 'Buraya eklenen kodlar < head > etiketi içerisine eklenir.', 'geo-admin' ),
				'type'		=> 'textarea-simple',
				'rows'       => '5',
				'section'	=> 'amp',
				'operator' => 'and'
			),
			array(
				'id'		=> 'geo-amp-footer-codes',
				'label'		=> __( 'Footer Kodları', 'geo-admin' ),
				'type'		=> 'textarea-simple',
				'rows'       => '5',
				'section'	=> 'amp',
				'operator' => 'and'
			),
			
			
			array(
				'id'			=> 'geo_slider_autoplay',
				'label'			=> __('Otomatik Oynatma', 'geo-admin'),
				'std'			=> 'on',
				'type'			=> 'on-off',
				'section'		=> 'slider',
				'operator'    => 'and'
			),
			array(
				'id'			=> 'geo_slider_pagination',
				'label'			=> __('Yön Tuşları', 'geo-admin'),
				'std'			=> 'on',
				'type'			=> 'on-off',
				'section'		=> 'slider',
				'operator'    => 'and'
			),
			array(
				'id'			=> 'geo_slider_overlay',
				'label'			=> __('Görsel Kaplama (Overlay)', 'geo-admin'),
				'std'			=> 'on',
				'type'			=> 'on-off',
				'section'		=> 'slider',
				'operator'    => 'and'
			),
			array(
				'id'		=> 'geo_slider_position_content',
				'label'		=> __( 'İçerik Pozisyonu', 'geo-admin' ),
				'std'		=> 'default',
				'type'		=> 'select',
				'section'	=> 'slider',
				'choices'     => array(
				  array(
					'value'       => 'default',
					'label'       => __( 'Varsayılan', 'geo-admin' )
				  ),
				  array(
					'value'       => 'bottom',
					'label'       => __( 'Aşağıda', 'geo-admin' )
				  ),
				  array(
					'value'       => 'middle',
					'label'       => __( 'Ortada ', 'geo-admin' )
				  ),
				  array(
					'value'       => 'top',
					'label'       => __( 'Yukarıda', 'geo-admin' )
				  ),
				)
			),
			array(
				'id'		=> 'geo_slider_position_align',
				'label'		=> __( 'İçerik Hizalama', 'geo-admin' ),
				'std'		=> 'default',
				'type'		=> 'select',
				'section'	=> 'slider',
				'choices'     => array(
				  array(
					'value'       => 'default',
					'label'       => __( 'Varsayılan', 'geo-admin' )
				  ),
				  array(
					'value'       => 'left',
					'label'       => __( 'Sola Yaslanmış', 'geo-admin' )
				  ),
				  array(
					'value'       => 'center',
					'label'       => __( 'Ortalanmış', 'geo-admin' )
				  ),
				  array(
					'value'       => 'right',
					'label'       => __( 'Sağa Yaslanmış', 'geo-admin' )
				  ),
				)
			),
			
			array(
				'id'		=> 'geo-amp-share',
				'label'		=>  __( 'Paylaş Butonları', 'geo-admin' ),
				'std'		=> 'default',
				'type'		=> 'radio-image',
				'section'	=> 'amp',
				'choices'	=> array(
					array(
						'value'		=> 'default',
						'label'		=> __('Varsayılan', 'geo-admin'),
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/social/style_1.png'
					),
					array(
						'value'		=> 'style-2',
						'label'		=> __('Görünüm', 'geo-admin').' #2',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/social/style_2.png'
					),
					array(
						'value'		=> 'style-3',
						'label'		=> __('Görünüm', 'geo-admin').' #3',
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/social/style_3.png'
					),
					array(
						'value'		=> 'off',
						'label'		=> __('Kapalı', 'geo-admin'),
						'src'		=> get_template_directory_uri() . '/theme-options/assets/images/layout/off.png'
					),
				)
			),
			
			array(
				'id'		=> 'geo-amp-post-reading',
				'label'		=> __( 'Okuma Süresi', 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'amp'
			),
			
			array(
				'id'		=> 'geo-amp-post-related',
				'label'		=> __( 'Benzer Yazılar', 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'amp'
			),
			array(
				'id'		=> 'geo-amp-post-tags',
				'label'		=> __( 'Etiketler', 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'amp'
			),
			array(
				'id'		=> 'geo-amp-post-cats',
				'label'		=> __( 'Kategoriler', 'geo-admin' ),
				'std'		=> 'on',
				'type'		=> 'on-off',
				'section'	=> 'amp'
			),
			
			array(
				'id'		=> 'geoit_ad_amp',
				'label'		=> __( 'AMP Reklam', 'geo-admin' ),
				'desc'		=> __( 'Otomatik reklamlarlar için.', 'geo-admin' ),
				'type'		=> 'textarea-simple',
				'rows'       => '4',
				'section'	=> 'amp',
				'operator' => 'and'
			),
			
			array(
				'id'		=> 'geoit_ad_amp_header',
				'label'		=> __( 'AMP Reklam: Header Altı', 'geo-admin' ),
				'type'		=> 'textarea-simple',
				'rows'       => '4',
				'section'	=> 'amp',
				'operator' => 'and'
			),
			
			array(
				'id'		=> 'geoit_ad_amp_above',
				'label'		=> __( 'AMP Reklam: Yazı Başlangıcı', 'geo-admin' ),
				'type'		=> 'textarea-simple',
				'rows'       => '4',
				'section'	=> 'amp',
				'operator' => 'and'
			),
			
			array(
				'id'		=> 'geoit_ad_amp_below',
				'label'		=> __( 'AMP Reklam: Yazı Sonu', 'geo-admin' ),
				'type'		=> 'textarea-simple',
				'rows'       => '4',
				'section'	=> 'amp',
				'operator' => 'and'
			),
			
		
    )
  );
  
  /* allow settings to be filtered before saving */
  $custom_settings = apply_filters( ot_settings_id() . '_args', $custom_settings );
  
  /* settings are not the same update the DB */
  if ( $saved_settings !== $custom_settings ) {
    update_option( ot_settings_id(), $custom_settings ); 
  }
  
  /* Lets OptionTree know the UI Builder is being overridden */
  global $ot_has_custom_theme_options;
  $ot_has_custom_theme_options = true;
  
}